/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.exception;

import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class FitException
extends RuntimeException {
    public static final int DEFAULT_ERROR_CODE = 0x7F000000;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final int code;
    private String genericableId;
    private String fitableId;

    public FitException(String message) {
        this(null, null, 0x7F000000, message, null);
    }

    public FitException(String message, Throwable cause) {
        this(null, null, 0x7F000000, message, cause);
    }

    public FitException(int code, String message) {
        this(null, null, code, message, null);
    }

    public FitException(int code, String errorMessage, String detailMessage) {
        this(null, null, code, StringUtils.format((String)errorMessage, (Object[])new Object[]{detailMessage}), null);
    }

    public FitException(int code, String message, Throwable cause) {
        this(null, null, code, message, cause);
    }

    public FitException(int code, String errorMessage, String detailMessage, Throwable cause) {
        this(null, null, code, StringUtils.format((String)errorMessage, (Object[])new Object[]{detailMessage}), cause);
    }

    public FitException(String genericableId, String fitableId, String message) {
        this(genericableId, fitableId, 0x7F000000, message, null);
    }

    public FitException(String genericableId, String fitableId, String message, Throwable cause) {
        this(genericableId, fitableId, 0x7F000000, message, cause);
    }

    public FitException(String genericableId, String fitableId, int code, String message) {
        this(genericableId, fitableId, code, message, null);
    }

    public FitException(String genericableId, String fitableId, int code, String message, Throwable cause) {
        super(message, cause);
        this.genericableId = genericableId;
        this.fitableId = fitableId;
        this.code = code;
    }

    public FitException(String genericableId, String fitableId, int code, String message, Throwable cause, Map<String, String> properties) {
        super(message, cause);
        this.genericableId = genericableId;
        this.fitableId = fitableId;
        this.code = code;
        this.properties.putAll(properties);
    }

    public boolean associate(String genericableId, String fitableId) {
        if (StringUtils.isBlank((String)genericableId) || StringUtils.isBlank((String)fitableId)) {
            return false;
        }
        if (StringUtils.isNotBlank((String)this.genericableId) || StringUtils.isNotBlank((String)this.fitableId)) {
            return false;
        }
        this.genericableId = genericableId;
        this.fitableId = fitableId;
        return true;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getGenericableId() {
        return this.genericableId;
    }

    @Generated
    public String getFitableId() {
        return this.fitableId;
    }
}

