/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.utils;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;

public final class PyJavaUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PyJavaUtils.class);
    private static final String SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT";
    private static final String REST_CONNECTION = "REST_CONNECTION";

    private PyJavaUtils() {
    }

    public static PyDictionary convertMap2Dict(Map<String, Object> args) {
        PyDictionary dict = new PyDictionary();
        dict.putAll(args);
        return dict;
    }

    public static List<Object> convertTuple2List(PyObject pyReturnRet) {
        ArrayList<Object> ret = new ArrayList<Object>();
        if (pyReturnRet instanceof PyTuple) {
            PyObject[] array;
            for (PyObject obj : array = ((PyTuple)pyReturnRet).getArray()) {
                ret.add(PyJavaUtils.converBaseType(obj));
            }
        } else {
            LOGGER.info("pyReturnRet : {} not is tuple type.", (Object)pyReturnRet);
        }
        return ret;
    }

    public static Object converBaseType(PyObject pyObject) {
        String type = pyObject.getType().getName();
        if ("bool".equals(type)) {
            PyBoolean pyBoolean = (PyBoolean)pyObject;
            return pyBoolean.getBooleanValue();
        }
        if ("dict".equals(type)) {
            return pyObject.__tojava__(Object.class);
        }
        if ("tuple".equals(type)) {
            return PyJavaUtils.convertTuple2List(pyObject);
        }
        if (null != type && type.toLowerCase(Locale.ENGLISH).contains("map")) {
            return pyObject.__tojava__(Object.class);
        }
        return pyObject.toString();
    }

    public static <T> List<T> convertPyList2Jlist(Object pyObject) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (pyObject instanceof PyList) {
            Object[] arr = ((PyList)pyObject).toArray();
            list.addAll(Arrays.asList(arr));
        }
        return list;
    }

    public static void releaseRestConnection(Map<String, Object> context) {
        LOGGER.info("###call close python rest connection");
        if (null == context || !context.containsKey(SCRIPT_DEF_CONTEXT)) {
            LOGGER.info("###no exist script def context");
            return;
        }
        try (PythonInterpreter interpreter = new PythonInterpreter();){
            LOGGER.info("###enter release rest connection");
            Object scriptDict = context.getOrDefault(SCRIPT_DEF_CONTEXT, "");
            if (!(scriptDict instanceof PyDictionary)) {
                LOGGER.info("###context is not python dict");
                return;
            }
            Object restConnection = ((PyDictionary)scriptDict).getOrDefault((Object)REST_CONNECTION, (Object)"");
            if ("".equals(restConnection)) {
                LOGGER.info("###rest connection is not exist");
                return;
            }
            interpreter.set("restConnection", restConnection);
            interpreter.exec("restConnection.close()");
        }
        catch (Exception e) {
            LOGGER.error("###call close connection error.");
        }
    }

    public static List<Object> executePyMethod(String methodName, DevNode devNode, ICliConnection ssh) throws ToolException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("ssh", ssh);
        String loggerFileName = devNode.getIp().replace(":", ".");
        context.put("logger", ToolLoggerFactory.getLoggerInStandAlone(loggerFileName));
        String lang = LanguageManager.getInstance().getCurrentLanguage().getLanguage();
        context.put("lang", lang);
        context.put("dev", EntityUtils.getDevMapDict(devNode));
        PythonInterpreter interpreter = new PythonInterpreter();
        interpreter.exec("from cbb.common.py_utils_for_java import " + methodName);
        return new JythonExecuter(interpreter).invokeFunction(methodName, context);
    }
}

