/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.ui;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicegraph.Constants;
import com.huawei.ism.tool.devicegraph.config.DeviceGraphConfig;
import com.huawei.ism.tool.devicegraph.config.EnclosureCfg;
import com.huawei.ism.tool.devicegraph.config.ModuleCfg;
import com.huawei.ism.tool.devicegraph.config.SlotCfg;
import com.huawei.ism.tool.devicegraph.listener.EnGraphMouseMotion;
import com.huawei.ism.tool.devicegraph.listener.PopupMenuListener;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosureGraph;
import com.huawei.ism.tool.devicegraph.ui.components.RackPanel;
import com.huawei.ism.tool.devicegraph.util.GraphUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceRetriever;
import com.huawei.ism.tool.framework.pubservice.exception.DeviceException;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareDetail;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;
import com.huawei.ism.tool.framework.pubui.common.ui.AbstractDeviceGraph;
import com.huawei.ism.tool.framework.pubui.common.ui.EnclosureMenuItem;
import com.huawei.ism.tool.framework.pubui.entity.DeviceStatusEnum;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;

public class DeviceGraphPanel
extends AbstractDeviceGraph {
    private static final long serialVersionUID = 8487015371166378702L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceGraphPanel.class.getClass());
    private static final String REGEX_DOT = "\\.";
    private static final int DEFAULT_WIDTH = 800;
    private static final String EDGE_STYLE = "edgeStyle";
    private static final String LIGHT_COLOR_STR = "#02EEFD";
    private static final int PADDING = 2;
    private static final int RED_COLOR = 255;
    private static final int DEFAULT_HEIGHT = 600;
    private static final int TITLE_PANEL_HEIGHT = 30;
    private static final int HEIGHT_2U = 19;
    private static final int SVP_START_U = 25;
    private static final int SVP_ETH_0_X = 81;
    private static final int SVP_ETH_0_Y = 6;
    private static final int SVP_ETH_1_X = 81;
    private static final int SVP_ETH_1_Y = 9;
    private static final int INT_4 = 4;
    private static final int INT_3 = 3;
    private static final int INT_2 = 2;
    private static final float FLOAT_2 = 2.0f;
    private static final int HEIGHT_SVP = 181;
    private static final int WIDTH_SVP = 94;
    private static final int WIDTH = 9;
    private static final int HEIGHT = 18;
    private static Map<String, IHardwareInfo> portMap = null;
    private static IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
    private static IDeviceRetriever retriver = devMng.getDeviceRetriever(devMng.getCurrentDevice());
    private List<RackPanel> rackList = null;
    private mxGraphComponent canvasGraph = null;
    private boolean isBack;
    private Map<String, Map<String, IHardwareInfo>> hardwareMap = new HashMap<String, Map<String, IHardwareInfo>>();
    private static final Object lock = new Object();

    public DeviceGraphPanel(List<RackPanel> rackList, boolean isSupportLight, boolean isBack) {
        this.isBack = isBack;
        this.rackList = rackList;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.anchor = 17;
        this.add((Component)this.createOpaquePanel(), gbc);
        gbc.gridy = 2;
        this.add((Component)this.createOpaquePanel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.add((Component)this.createOpaquePanel(), gbc);
        gbc.gridx = 2;
        this.add((Component)this.createOpaquePanel(), gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        if (!isSupportLight) {
            this.canvasGraph = this.buildCableGraph(rackList.size());
            this.canvasGraph.setOpaque(false);
            this.add((Component)this.canvasGraph, gbc);
        }
        this.add((Component)this.layoutRacks(rackList), gbc);
    }

    public List<RackPanel> getRackList() {
        return this.rackList;
    }

    @Override
    public Dimension getDefaultSize() {
        return new Dimension(800, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void highlightCable(IPortInfo fromPort, IPortInfo toPort, DeviceStatusEnum status) {
        mxGraph graph = this.canvasGraph.getGraph();
        graph.getModel().beginUpdate();
        try {
            mxCell fromCell;
            Point fromPoint;
            EnclosureGraph tograph;
            if (fromPort.getLocation().contains("SVP")) {
                this.highlightSVP();
                tograph = this.getEnclosureGraph(GraphUtils.getEnclosureName(toPort));
                this.highlightEnclosure(tograph);
                fromPoint = this.calSvpEthPortCoordinate(fromPort.getLocation());
                fromCell = (mxCell)graph.insertVertex(graph.getDefaultParent(), null, null, fromPoint.getX(), fromPoint.getY(), 1.0, 1.0);
            } else {
                EnclosureGraph fromgraph = this.getEnclosureGraph(GraphUtils.getEnclosureName(fromPort));
                this.highlightEnclosure(fromgraph);
                tograph = this.getEnclosureGraph(GraphUtils.getEnclosureName(toPort));
                this.highlightEnclosure(tograph);
                fromPoint = this.calPortCoordinate(fromgraph, fromPort);
                fromCell = (mxCell)graph.insertVertex(graph.getDefaultParent(), null, null, fromPoint.getX(), fromPoint.getY(), 1.0, 1.0);
            }
            fromCell.setConnectable(false);
            Point toPoint = this.calPortCoordinate(tograph, toPort);
            mxCell toCell = (mxCell)graph.insertVertex(graph.getDefaultParent(), null, null, toPoint.getX(), toPoint.getY(), 1.0, 1.0);
            mxCell routeCell = (mxCell)graph.insertVertex(graph.getDefaultParent(), null, null, toPoint.getX(), fromPoint.getY(), 0.0, 0.0);
            String styleName = this.getEdgeStyle(graph, status);
            graph.insertEdge(graph.getDefaultParent(), null, null, fromCell, routeCell, styleName);
            graph.insertEdge(graph.getDefaultParent(), null, null, routeCell, toCell, styleName);
        }
        finally {
            graph.getModel().endUpdate();
        }
    }

    private String getEdgeStyle(mxGraph graph, DeviceStatusEnum status) {
        if (graph == null) {
            return "";
        }
        mxStylesheet stylesheet = graph.getStylesheet();
        Map<String, Object> style = stylesheet.getCellStyle(EDGE_STYLE, new HashMap<String, Object>());
        if (style.isEmpty()) {
            style.put(mxConstants.STYLE_EDGE, "connector");
            style.put(mxConstants.STYLE_ENDARROW, "none");
            style.put(mxConstants.STYLE_STROKEWIDTH, 2);
            style.put(mxConstants.STYLE_STROKECOLOR, status.getColorStr());
            stylesheet.putCellStyle(EDGE_STYLE, style);
        }
        return EDGE_STYLE;
    }

    @Override
    public void highlightModule(IHardwareInfo module) {
        this.hilight(module, DeviceStatusEnum.selected, -1);
    }

    @Override
    public void highlightModules(List<IHardwareInfo> moduleList, DeviceStatusEnum status) {
        for (IHardwareInfo module : moduleList) {
            String bayId = this.getLocatedBayId(module);
            if (StringUtils.isNULLStr(bayId)) {
                LOGGER.error("[BI]The bay id can't get: " + module.getLocation());
                continue;
            }
            int bayIndex = this.queryBayIndex(bayId);
            if (bayIndex == -1) {
                LOGGER.error("[BX]The bay index can't get: " + module.getLocation());
                continue;
            }
            this.hilight(module, status, bayIndex);
        }
    }

    @Override
    public List<Rectangle> getModulesLocation(List<IHardwareInfo> moduleList) {
        List<String> bayIds = this.getBayIds(moduleList);
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        int i = 0;
        for (String bayId : bayIds) {
            for (IHardwareInfo module : moduleList) {
                if (module.getTypeName().contains("PORT")) {
                    rectangles.add(this.getPortLocationWithTryCatch((IPortInfo)module));
                    continue;
                }
                if (module.getTypeName().equals("SFP_OPTICAL_TRANSCEIVER")) {
                    rectangles.add(this.getPortLocationWithTryCatch(module));
                    continue;
                }
                if (!bayId.equals(this.getLocatedBayId(module))) continue;
                rectangles.add(this.getHardwareLocation(module, i));
            }
            ++i;
        }
        return rectangles;
    }

    @Override
    public void highLightModule(Rectangle rectangle, DeviceStatusEnum status) {
        this.highLight(rectangle, status);
    }

    @Override
    public void turnOffLocatingLight(IHardwareInfo module, Window parent) {
        if (null == module) {
            return;
        }
        IEnclosureInfo enclosure = this.getParentEnclosure(module);
        if (null != enclosure) {
            EnclosureGraph enclosureGraph = this.getEnclosureGraph(enclosure.getName());
            if (null == enclosureGraph) {
                LOGGER.error("Failed to get the enclosure graph.");
                return;
            }
            mxGraph graph = enclosureGraph.getGraph();
            Object[] cells = graph.getChildCells(graph.getDefaultParent());
            graph.removeCells(cells, true);
            parent.repaint();
        }
    }

    @Override
    public void turnOnLocatingLight(IHardwareInfo module, Window parent) {
        Rectangle rectangle;
        if (null == module) {
            return;
        }
        IEnclosureInfo enclosure = null;
        ImageIcon lightImg = null;
        if (MOType.ENCLOSURE.name().equals(module.getTypeName())) {
            enclosure = (IEnclosureInfo)module;
            int heightU = enclosure.getHeightU();
            lightImg = this.getLightImg(heightU);
            if (null == lightImg) {
                return;
            }
            EnclosureCfg enclosureCfg = DeviceGraphConfig.getInstance().getEnclosureCfg(enclosure.getLogicTypeName(), enclosure.getModelName());
            if (this.enclosureCfgIsNull(enclosureCfg)) {
                return;
            }
            rectangle = new Rectangle(Constants.PLACE_HOLDER_CELL_WIDTH, 0, enclosureCfg.getWidth(), enclosureCfg.getHeight());
        } else {
            enclosure = this.getParentEnclosure(module);
            if (null == enclosure) {
                LOGGER.error("Get enclosure failed!");
                return;
            }
            EnclosureCfg ctrlCfg = DeviceGraphConfig.getInstance().getEnclosureCfg(enclosure.getLogicTypeName(), enclosure.getModelName());
            if (null == ctrlCfg) {
                LOGGER.error("Failed to get the enclosure cfg.");
                return;
            }
            String silkScreen = GraphUtils.getHardwareSilkScreen(module.getLocation());
            SlotCfg slotCfg = null;
            slotCfg = this.getSlotCfg(module, ctrlCfg, silkScreen);
            if (this.slotCfgIsNull(slotCfg)) {
                return;
            }
            int xValue = slotCfg.getxCoordinates();
            int yValue = slotCfg.getyCoordinates();
            URL url = RackPanel.class.getResource("/config/images/light_controller_front_1u.png");
            lightImg = new ImageIcon(url);
            rectangle = new Rectangle(xValue, yValue, slotCfg.getWidth(), slotCfg.getHeight());
        }
        if (this.enclosureGraphIsNull(this.getEnclosureGraph(enclosure.getName()))) {
            return;
        }
        this.paintGraph(parent, enclosure, rectangle, lightImg);
    }

    private boolean enclosureGraphIsNull(EnclosureGraph enclosureGraph) {
        if (null == enclosureGraph) {
            LOGGER.error("Failed to get the enclosure graph.");
            return true;
        }
        return false;
    }

    private boolean slotCfgIsNull(SlotCfg slotCfg) {
        if (null == slotCfg) {
            LOGGER.error("Turn on locating light error: SlotCfg is null.");
            return true;
        }
        return false;
    }

    private boolean enclosureCfgIsNull(EnclosureCfg enclosureCfg) {
        if (null == enclosureCfg) {
            LOGGER.error("Failed to get the enclosure cfg.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGraph(Window parent, IEnclosureInfo enclosure, Rectangle rectangle, ImageIcon lightImg) {
        mxGraph graph = this.canvasGraph.getGraph();
        graph.getModel().beginUpdate();
        try {
            mxCell cell = GraphUtils.addImage(graph, graph.getDefaultParent(), lightImg.toString(), rectangle);
            Map<String, Object> style = graph.getCellStyle(cell);
            style.put(mxConstants.STYLE_STROKECOLOR, LIGHT_COLOR_STR);
            style.put(mxConstants.STYLE_STROKEWIDTH, 2);
            graph.getStylesheet().putCellStyle(cell.getStyle(), style);
        }
        finally {
            parent.repaint();
            graph.getModel().endUpdate();
        }
    }

    private SlotCfg getSlotCfg(IHardwareInfo module, EnclosureCfg ctrlCfg, String silkScreen) {
        SlotCfg slotCfg;
        boolean isHDGraph = ApplicationContext.getInstance().isHDGraph();
        if (this.isBack) {
            slotCfg = ctrlCfg.getBackSlotCfg(module.getTypeName(), silkScreen);
            if (isHDGraph) {
                slotCfg = ctrlCfg.getHdBackSlotCfg(module.getTypeName(), silkScreen);
            }
        } else {
            slotCfg = ctrlCfg.getFrontSlotCfg(module.getTypeName(), silkScreen);
            if (isHDGraph) {
                slotCfg = ctrlCfg.getHdFrontSlotCfg(module.getTypeName(), silkScreen);
            }
        }
        return slotCfg;
    }

    @Override
    public void updateGraph(List<HardwareDetail> hardwareList) {
        for (HardwareDetail hardware : hardwareList) {
            this.updateGraph(hardware);
        }
    }

    @Override
    public void updateGraph(HardwareDetail hardware) {
        if (null == hardware) {
            return;
        }
        IHardwareInfo selfInfo = hardware.getInfo();
        Map<String, IHardwareInfo> selfMap = this.hardwareMap.get(selfInfo.getTypeName());
        if (null == selfMap) {
            selfMap = new HashMap<String, IHardwareInfo>();
            this.hardwareMap.put(selfInfo.getTypeName(), selfMap);
        }
        selfMap.put(selfInfo.getID(), selfInfo);
        for (HardwareDetail subHardware : hardware.getSubModules()) {
            this.updateGraph(subHardware);
        }
    }

    @Override
    public void addHardware(String typeName, IHardwareInfo hardware) {
        Map<String, IHardwareInfo> map = this.hardwareMap.get(typeName);
        if (map == null) {
            map = new HashMap<String, IHardwareInfo>();
            this.hardwareMap.put(typeName, map);
        }
        map.put(hardware.getID(), hardware);
    }

    @Override
    public void addEnclosurePopupMenuItem(List<EnclosureMenuItem> items) {
        JPopupMenu menu = new JPopupMenu();
        for (JMenuItem jMenuItem : items) {
            if (menu.getComponentCount() > 0) {
                menu.addSeparator();
            }
            menu.add(jMenuItem);
        }
        this.bondListner(menu, items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDeviceGraph() {
        if (this.canvasGraph != null) {
            mxGraph graph = this.canvasGraph.getGraph();
            graph.getModel().beginUpdate();
            try {
                Object parent = graph.getDefaultParent();
                Object[] cells = graph.getChildCells(parent);
                graph.removeCells(cells, true);
            }
            finally {
                this.updateUI();
                graph.getModel().endUpdate();
            }
        }
    }

    @Override
    public void clearEnclosurePopupMenuItem(String enTypeName) {
    }

    @Override
    public void cancelHighlightModules() {
    }

    @Override
    public void cancelHighlightCables() {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        String imgPath = "/config/images/grid_background.png";
        URL url = RackPanel.class.getResource(imgPath);
        ImageIcon imgIcon = new ImageIcon(url);
        Image img = imgIcon.getImage();
        graphics.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private JPanel createOpaquePanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }

    private void hilight(IHardwareInfo module, DeviceStatusEnum status, int index) {
        Rectangle rectangle = this.getHardwareLocation(module, index);
        if (null == rectangle) {
            return;
        }
        this.highLight(new Rectangle((int)rectangle.getX() + 2, (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight()), status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highLight(Rectangle rectangle, DeviceStatusEnum status) {
        mxGraph graph = this.canvasGraph.getGraph();
        graph.getModel().beginUpdate();
        try {
            int xValue = (int)rectangle.getX();
            int yValue = (int)rectangle.getY();
            int width = (int)rectangle.getWidth();
            int height = (int)rectangle.getHeight();
            String styleName = "cellOverlay";
            HashMap<String, Object> style = new HashMap<String, Object>();
            style.put(mxConstants.STYLE_FILLCOLOR, "none");
            style.put(mxConstants.STYLE_STROKECOLOR, status.getColorStr());
            style.put(mxConstants.STYLE_STROKEWIDTH, 2);
            GraphUtils.setDefaultStyle(graph, this.canvasGraph);
            graph.getStylesheet().putCellStyle(styleName, style);
            graph.insertVertex(graph.getDefaultParent(), null, null, xValue, yValue, width, height, styleName);
        }
        finally {
            graph.getModel().endUpdate();
            this.updateUI();
        }
    }

    private List<String> getBayIds(List<IHardwareInfo> moduleList) {
        ArrayList<String> bayIds = new ArrayList<String>();
        for (IHardwareInfo module : moduleList) {
            String bayId = this.getLocatedBayId(module);
            if (StringUtils.isNULLStr(bayId)) continue;
            bayIds.add(bayId);
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(bayIds);
        bayIds.clear();
        bayIds.addAll(set);
        Collections.sort(bayIds);
        return bayIds;
    }

    private mxGraphComponent buildCableGraph(int rackSize) {
        mxGraph graph = new mxGraph();
        mxGraphComponent component = new mxGraphComponent(graph){};
        component.setBorder(null);
        component.setOpaque(false);
        component.getViewport().setBackground(null);
        component.setBackground(new Color(255, 0, 0, 0));
        Dimension dimension = new Dimension(Constants.RACK_WIDTH * rackSize, Constants.RACK_HEIGHT + 30);
        GraphUtils.setChangelessSize(component, dimension);
        GraphUtils.setDefaultStyle(graph, component);
        return component;
    }

    private JPanel layoutRacks(List<RackPanel> racks) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        for (RackPanel rack : racks) {
            JPanel title = this.buildGraphTitle(rack.getEnclosureList());
            gbc.gridy = 0;
            panel.add((Component)title, gbc);
            gbc.gridy = 1;
            panel.add((Component)rack, gbc);
            ++gbc.gridx;
        }
        int width = racks.size() * Constants.RACK_WIDTH;
        Dimension dimension = new Dimension(width, Constants.RACK_HEIGHT + 30);
        GraphUtils.setChangelessSize(panel, dimension);
        return panel;
    }

    private void highlightEnclosure(EnclosureGraph component) {
        if (null == component) {
            throw new EncapsulatedRuntimeException("graph is null.");
        }
        Point graphP = GraphUtils.getEnclosureCoordinateX(component);
        int rackIndex = component.getRackIndex();
        int xValue = (int)((double)(rackIndex * Constants.RACK_WIDTH) + graphP.getX());
        int yValue = (int)graphP.getY() + 30;
        int height = component.getEnclosureHeight();
        this.canvasGraph.getGraph().insertVertex(this.canvasGraph.getGraph().getDefaultParent(), null, null, xValue, yValue, Constants.ENCLOSURE_WIDTH, height, "strokeColor=yellow;fillColor=none;strokeWidth=2");
        GraphUtils.getEnclosureCoordinateX(component);
    }

    private void highlightSVP() {
        int rackIndex = this.getSMB0RackIndex();
        int xValue = rackIndex * Constants.RACK_WIDTH;
        int yValue = Constants.RACK_HEIGHT - 22 - 19 - 24 * (Constants.ENCLOSURE_1U_HEIGHT + 1) + 30;
        this.canvasGraph.getGraph().insertVertex(this.canvasGraph.getGraph().getDefaultParent(), null, null, xValue, yValue, Constants.ENCLOSURE_WIDTH, 19.0, " strokeColor=yellow;fillColor=none");
    }

    private Point calPortCoordinate(EnclosureGraph graph, IPortInfo port) {
        DeviceGraphConfig graphCfg = DeviceGraphConfig.getInstance();
        IHardwareInfo parentInfo = this.hardwareMap.get(MOType.getTypeName((int)port.getParentType())).get(port.getParentID());
        Point enCoordinate = GraphUtils.getEnclosureCoordinateX(graph);
        ModuleCfg parentCfg = graphCfg.getModuleCfg(parentInfo.getTypeName(), parentInfo.getModelName());
        String portSilkScreen = GraphUtils.getHardwareSilkScreen(port.getLocation());
        if (null == parentCfg) {
            LOGGER.info("come in null parentCfg.");
            return new Point(0, 0);
        }
        SlotCfg portSlot = parentCfg.getFrontSlotCfg(port.getTypeName(), portSilkScreen);
        if (null == portSlot) {
            throw new EncapsulatedRuntimeException("protSlot is null.");
        }
        int rackIndex = graph.getRackIndex();
        if (MOType.ENCLOSURE.getValue() == port.getParentType()) {
            int xValue = (int)((double)(rackIndex * Constants.RACK_WIDTH) + enCoordinate.getX() + (double)portSlot.getxCoordinates());
            int yValue = (int)enCoordinate.getY() + portSlot.getyCoordinates() + 30;
            LOGGER.info("Point={}_{}_portSlot.getX={}_portSlot.getY={}_enCoordinate.getX={}_enCoordinate.getX={}", xValue, yValue, portSlot.getxCoordinates(), portSlot.getyCoordinates(), enCoordinate.getX(), enCoordinate.getX());
            return new Point(xValue, yValue);
        }
        IEnclosureInfo enclosure = graph.getEnclosureInfo();
        EnclosureCfg enCfg = graphCfg.getEnclosureCfg(enclosure.getLogicTypeName(), enclosure.getModelName());
        if (null == enCfg) {
            throw new EncapsulatedRuntimeException("enCfg is null.");
        }
        SlotCfg parentSlot = null;
        if (MOType.INTF_MODULE.name().equals(parentInfo.getTypeName())) {
            parentSlot = enCfg.getBackCfgByLocation(parentInfo.getTypeName(), parentInfo.getLocation());
        } else {
            String slotSilkSreen = GraphUtils.getHardwareSilkScreen(parentInfo.getLocation());
            parentSlot = enCfg.getBackSlotCfg(parentInfo.getTypeName(), slotSilkSreen);
        }
        if (null == parentSlot) {
            throw new EncapsulatedRuntimeException("parentSlot is null.");
        }
        int xValue = (int)((double)(rackIndex * Constants.RACK_WIDTH) + enCoordinate.getX() + (double)parentSlot.getxCoordinates() + (double)portSlot.getxCoordinates());
        int yValue = (int)enCoordinate.getY() + parentSlot.getyCoordinates() + portSlot.getyCoordinates() + 30;
        return new Point(xValue + 2, yValue);
    }

    private Point calSvpEthPortCoordinate(String svpEthPort) {
        int ethX = 0;
        int ethY = 0;
        String[] locArrays = svpEthPort.split(REGEX_DOT);
        if ("2".equals(locArrays[locArrays.length - 1])) {
            ethX = 81;
            ethY = 6;
        } else {
            ethX = 81;
            ethY = 9;
        }
        int rackIndex = this.getSMB0RackIndex();
        int xValue = rackIndex * Constants.RACK_WIDTH + ethX;
        int yValue = Constants.RACK_HEIGHT - 22 - 19 - 24 * (Constants.ENCLOSURE_1U_HEIGHT + 1) + 30 + ethY;
        return new Point(xValue, yValue);
    }

    private EnclosureGraph getEnclosureGraph(String enclosureName) {
        for (RackPanel rack : this.rackList) {
            List<EnclosureGraph> graphList = rack.getEnclosureGraphList();
            for (EnclosureGraph graph : graphList) {
                if (!graph.getEnclosureInfo().getName().equals(enclosureName)) continue;
                return graph;
            }
        }
        LOGGER.error("Get enclosure by enclosureName error. Name=" + enclosureName);
        return null;
    }

    private int getSMB0RackIndex() {
        for (RackPanel rack : this.rackList) {
            if (!rack.isSMB0()) continue;
            return rack.getRackIndex();
        }
        return 0;
    }

    private Rectangle getPortLocationWithTryCatch(IHardwareInfo port) {
        try {
            return this.getPortLocation(port);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return new Rectangle();
        }
    }

    private Rectangle getPortLocation(IHardwareInfo port) {
        ModuleCfg parentCfg;
        if (port.getLocation().contains("SVP")) {
            Point point = this.calSvpEthPortCoordinate(port.getLocation());
            return new Rectangle((int)point.getX(), (int)point.getY(), 2, 2);
        }
        DeviceGraphConfig graphCfg = DeviceGraphConfig.getInstance();
        IHardwareInfo parentInfo = null;
        parentInfo = this.getiHardwareInfo(port, parentInfo);
        EnclosureGraph graph = this.getEnclosureGraph(GraphUtils.getEnclosureName(port));
        if (null == graph) {
            throw new EncapsulatedRuntimeException("graph is null.");
        }
        Point enCoordinate = GraphUtils.getEnclosureCoordinateX(graph);
        int rackIndex = graph.getRackIndex();
        ModuleCfg moduleCfg = parentCfg = parentInfo == null ? null : graphCfg.getModuleCfg(parentInfo.getTypeName(), parentInfo.getModelName());
        if (this.parentCfgIsNull(parentCfg)) {
            return new Rectangle();
        }
        SlotCfg portSlot = parentCfg.getFrontCfgByLocation(port.getTypeName().equals("SFP_OPTICAL_TRANSCEIVER") ? this.getOpticalParentType(port) : port.getTypeName(), port.getLocation());
        if (portSlot == null) {
            LOGGER.error("[!!!!!!!!!DS]portSlot is null.");
        }
        int xValue = 0;
        int yValue = 0;
        int width = 0;
        int height = 0;
        if (MOType.ENCLOSURE.getValue() == port.getParentType()) {
            if (portSlot == null) {
                throw new EncapsulatedRuntimeException("portSlot is null.");
            }
            xValue = (int)((double)(rackIndex * Constants.RACK_WIDTH) + enCoordinate.getX() + (double)portSlot.getxCoordinates()) - portSlot.getWidth() / 2;
            yValue = (int)enCoordinate.getY() + portSlot.getyCoordinates() + 30;
            width = portSlot.getWidth();
            height = portSlot.getHeight();
            return new Rectangle(xValue, yValue, width, height);
        }
        SlotCfg parentSlot = this.getSlotCfg(graphCfg, parentInfo, graph, portSlot);
        xValue = (int)((double)(rackIndex * Constants.RACK_WIDTH) + enCoordinate.getX() + (double)parentSlot.getxCoordinates() + (double)portSlot.getxCoordinates()) - portSlot.getWidth() / 2;
        yValue = (int)enCoordinate.getY() + parentSlot.getyCoordinates() + portSlot.getyCoordinates() + 30 - (portSlot.getHeight() + 1) / 2;
        width = portSlot.getWidth();
        height = portSlot.getHeight();
        return new Rectangle(xValue, yValue, width, height);
    }

    private boolean parentCfgIsNull(ModuleCfg parentCfg) {
        if (parentCfg == null) {
            LOGGER.error("Failed to get the parent configuration.");
            return true;
        }
        return false;
    }

    private SlotCfg getSlotCfg(DeviceGraphConfig graphCfg, IHardwareInfo parentInfo, EnclosureGraph graph, SlotCfg portSlot) {
        IEnclosureInfo enclosure = graph.getEnclosureInfo();
        EnclosureCfg enCfg = graphCfg.getEnclosureCfg(enclosure.getLogicTypeName(), enclosure.getModelName());
        if (enCfg == null) {
            throw new EncapsulatedRuntimeException("enCfg is null.");
        }
        if (parentInfo == null) {
            throw new EncapsulatedRuntimeException("parentInfo is null.");
        }
        SlotCfg parentSlot = enCfg.getBackCfgByLocation(parentInfo.getTypeName(), parentInfo.getLocation());
        this.exceptionForSomeStatus(parentInfo, portSlot, enCfg, parentSlot);
        return parentSlot;
    }

    private IHardwareInfo getiHardwareInfo(IHardwareInfo port, IHardwareInfo parentInfo) {
        if (port.getTypeName().equals("SFP_OPTICAL_TRANSCEIVER")) {
            Map<String, IHardwareInfo> map = this.hardwareMap.get("INTF_MODULE");
            for (Map.Entry<String, IHardwareInfo> entry : map.entrySet()) {
                IHardwareInfo info = entry.getValue();
                if (!port.getLocation().startsWith(info.getLocation())) continue;
                return info;
            }
        } else {
            return this.hardwareMap.get(MOType.getTypeName((int)port.getParentType())).get(port.getParentID());
        }
        return parentInfo;
    }

    private void exceptionForSomeStatus(IHardwareInfo parentInfo, SlotCfg portSlot, EnclosureCfg enCfg, SlotCfg parentSlot) {
        if (null == enCfg) {
            throw new EncapsulatedRuntimeException("enCfg is null.");
        }
        if (parentInfo == null) {
            LOGGER.error("[DS!!!!!!!!!!!!!!!]parentInfo is null.");
            throw new EncapsulatedRuntimeException("portSlot is null.");
        }
        if (parentSlot == null) {
            LOGGER.error("[DS]parentSlot is null.");
            throw new EncapsulatedRuntimeException("parentSlot is null.");
        }
        if (portSlot == null) {
            LOGGER.error("[DS!!!!!!!!!!!!!!!]parentSlot is null.");
            throw new EncapsulatedRuntimeException("portSlot is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOpticalParentType(IHardwareInfo port) {
        Object object = lock;
        synchronized (object) {
            IHardwareInfo portInfo;
            if (portMap == null) {
                portMap = new HashMap<String, IHardwareInfo>();
                ArrayList<IHardwareInfo> portList = new ArrayList<IHardwareInfo>();
                portList.addAll(this.getPortList("FC_PORT"));
                portList.addAll(this.getPortList("ETH_PORT"));
                portList.addAll(this.getPortList("FCOE_PORT"));
                portList.addAll(this.getPortList("PCIE_PORT"));
                portList.addAll(this.getPortList("SAS_PORT"));
                portList.addAll(this.getPortList("SERIAL_PORT"));
                for (IHardwareInfo portInfo2 : portList) {
                    if (portInfo2 == null) continue;
                    portMap.put(portInfo2.getLocation(), portInfo2);
                }
            }
            if ((portInfo = portMap.get(port.getLocation())) == null) {
                return "";
            }
            return portInfo.getTypeName();
        }
    }

    private List<IHardwareInfo> getPortList(String portType) {
        try {
            return retriver.retrieveModules(portType);
        }
        catch (DeviceException e) {
            LOGGER.error(e.getMessage());
            return new ArrayList<IHardwareInfo>();
        }
    }

    private Rectangle getHardwareLocation(IHardwareInfo module, int index) {
        if (module.getID().toUpperCase(Locale.ENGLISH).contains("SVP")) {
            return this.getRectangle(module);
        }
        EnclosureGraph enGraph = this.getEnclosureGraph(GraphUtils.getEnclosureName(module));
        if (enGraph == null) {
            return null;
        }
        int rackIndex = enGraph.getRackIndex();
        if (index >= 0) {
            rackIndex = index;
        }
        IEnclosureInfo en = enGraph.getEnclosureInfo();
        EnclosureCfg enCfg = DeviceGraphConfig.getInstance().getEnclosureCfg(en.getLogicTypeName(), en.getModelName());
        if (null == enCfg) {
            throw new EncapsulatedRuntimeException("enCfg is null.");
        }
        Point enclosurePoint = GraphUtils.getEnclosureCoordinateX(enGraph);
        int xValue = 0;
        int yValue = 0;
        int width = 0;
        int height = 0;
        xValue = (int)((double)(rackIndex * Constants.RACK_WIDTH) + enclosurePoint.getX());
        yValue = (int)enclosurePoint.getY() + 30;
        width = enCfg.getWidth();
        height = enCfg.getHeight();
        if (!MOType.ENCLOSURE.name().equals(module.getTypeName())) {
            String typeName = module.getTypeName();
            SlotCfg slotcfg = null;
            slotcfg = this.isBack ? enCfg.getBackCfgByLocation(typeName, module.getLocation()) : enCfg.getFrontCfgByLocation(typeName, module.getLocation());
            if (null == slotcfg) {
                LOGGER.error("Highlight module error: SlotCfg is null.");
                return null;
            }
            xValue += slotcfg.getxCoordinates();
            yValue += slotcfg.getyCoordinates();
            width = slotcfg.getWidth();
            height = slotcfg.getHeight();
        }
        if (MOType.INTF_MODULE.name().equals(module.getTypeName())) {
            ++yValue;
        }
        return new Rectangle(xValue, yValue, width, height);
    }

    private Rectangle getRectangle(IHardwareInfo module) {
        int yValue;
        int xValue;
        int indexsvp;
        int rackIndex = this.getSMB0RackIndex();
        String name = module.getID();
        int symbol = Integer.parseInt(name.substring(indexsvp = name.length() - 1));
        if (symbol == 1) {
            xValue = rackIndex * Constants.RACK_WIDTH;
            yValue = 211;
        } else {
            xValue = rackIndex * Constants.RACK_WIDTH + 94;
            yValue = 211;
        }
        return new Rectangle(xValue, yValue, 9, 18);
    }

    private void bondListner(JPopupMenu menu, List<EnclosureMenuItem> items) {
        for (RackPanel rack : this.rackList) {
            for (EnclosureGraph graph : rack.getEnclosureGraphList()) {
                graph.addMouseListener(new PopupMenuListener(menu, items));
                graph.addMouseMotionListener(new EnGraphMouseMotion(graph));
            }
        }
    }

    private IEnclosureInfo getParentEnclosure(IHardwareInfo module) {
        if (MOType.ENCLOSURE.name().equals(module.getTypeName())) {
            return (IEnclosureInfo)module;
        }
        ArrayList<IEnclosureInfo> enclosures = new ArrayList<IEnclosureInfo>();
        for (RackPanel rack : this.rackList) {
            enclosures.addAll(rack.getEnclosureList());
        }
        String parentEnName = GraphUtils.getEnclosureName(module);
        for (IEnclosureInfo enclosure : enclosures) {
            if (!enclosure.getName().equals(parentEnName)) continue;
            return enclosure;
        }
        return null;
    }

    private String getGraphTitle(List<IEnclosureInfo> enclosureList) {
        if (enclosureList.isEmpty()) {
            return "";
        }
        String bayName = enclosureList.get(0).getLocation().split(REGEX_DOT)[0];
        String bayType = bayName.substring(0, 3);
        String bayIndex = bayName.substring(3);
        if ("DKB".equals(bayType)) {
            return ResourceUtil.getString("dev.graph.rack.dkb") + " " + bayIndex;
        }
        if ("SMB".equals(bayType)) {
            return ResourceUtil.getString("dev.graph.rack.smb") + " " + bayIndex;
        }
        return "";
    }

    private JPanel buildGraphTitle(List<IEnclosureInfo> enclosures) {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(this.getGraphTitle(enclosures));
        titleLabel.setFont(new Font(null, 1, 12));
        titlePanel.add((Component)titleLabel, "Center");
        Dimension dimension = new Dimension(Constants.RACK_WIDTH, 30);
        GraphUtils.setChangelessSize(titlePanel, dimension);
        titlePanel.setOpaque(false);
        return titlePanel;
    }

    private ImageIcon getLightImg(int heightU) {
        if (2 == heightU) {
            URL url = RackPanel.class.getResource("/config/images/light_enclosure_front_2u.png");
            return new ImageIcon(url);
        }
        if (4 == heightU) {
            URL url = RackPanel.class.getResource("/config/images/light_enclosure_front_4u.png");
            return new ImageIcon(url);
        }
        return null;
    }

    private int queryBayIndex(String bayId) {
        for (int i = 0; i < this.rackList.size(); ++i) {
            if (!bayId.equals(this.rackList.get(i).getBayId())) continue;
            return this.rackList.get(i).getRackIndex();
        }
        return -1;
    }

    private String getLocatedBayId(IHardwareInfo module) {
        if (module.getTypeName().equals(MOType.BAY.name())) {
            return module.getID();
        }
        String enclosureName = module.getTypeName().equals(MOType.ENCLOSURE.name()) ? ((IEnclosureInfo)module).getName() : module.getLocation().split(REGEX_DOT)[0];
        for (RackPanel rack : this.rackList) {
            for (IEnclosureInfo info : rack.getEnclosureList()) {
                if (!enclosureName.equals(info.getName())) continue;
                return rack.getBayId();
            }
        }
        return null;
    }
}

