/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.ui.components;

import com.huawei.ism.tool.devicegraph.config.DeviceGraphConfig;
import com.huawei.ism.tool.devicegraph.config.EnclosureCfg;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosureGraph;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosureHDGraph;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class EnclosurePanel
extends JPanel {
    private static final long serialVersionUID = 1036030268210424219L;
    private boolean isBack;
    private boolean isIdSMB0;
    private int rackIndex;
    private String encId;
    private IEnclosureInfo encInfo;
    private EnclosureHDGraph graph;
    private List<EnclosureGraph> graphList = new ArrayList<EnclosureGraph>();
    private List<IHardwareInfo> allSubModules = new ArrayList<IHardwareInfo>();

    public EnclosureHDGraph getGraph() {
        return this.graph;
    }

    public void setGraph(EnclosureHDGraph graph) {
        this.graph = graph;
    }

    public EnclosurePanel(IEnclosureInfo enclosureInfo, List<IHardwareInfo> allSubModules, boolean isBack) {
        this.encInfo = enclosureInfo;
        this.isBack = isBack;
        this.graphList.clear();
        EnclosureCfg enclosureCfg = DeviceGraphConfig.getInstance().getHdEnclosureCfg(enclosureInfo.getLogicTypeName(), enclosureInfo.getModelName());
        EnclosureHDGraph comp = new EnclosureHDGraph(enclosureInfo, allSubModules, isBack, new mxGraph());
        if (enclosureCfg != null) {
            comp.setSize(enclosureCfg.getWidth(), enclosureCfg.getHeight());
        }
        comp.setLocation(new Point(15, 15));
        this.setGraph(comp);
        this.setOpaque(true);
        this.add(comp);
    }

    public int getRackIndex() {
        return this.rackIndex;
    }

    public boolean isSMB0() {
        return this.isIdSMB0;
    }

    public IEnclosureInfo getEncInfo() {
        return this.encInfo;
    }

    public void setEncInfo(IEnclosureInfo encInfo) {
        this.encInfo = encInfo;
    }

    private List<IHardwareInfo> getSubModulesInEn(String enName) {
        ArrayList<IHardwareInfo> subModules = new ArrayList<IHardwareInfo>();
        for (IHardwareInfo subModule : this.allSubModules) {
            String[] locArrays = subModule.getLocation().split("\\.");
            if (!enName.equals(locArrays[0])) continue;
            subModules.add(subModule);
        }
        return subModules;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void setSMB0(boolean smb) {
        this.isIdSMB0 = smb;
    }

    public String getEncId() {
        return this.encId;
    }

    public List<IHardwareInfo> getAllSubModules() {
        return this.allSubModules;
    }
}

