/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.parse;

import org.python.icu.impl.StaticUnicodeSets;
import org.python.icu.impl.StringSegment;
import org.python.icu.impl.number.parse.ParsedNumber;
import org.python.icu.impl.number.parse.ParsingUtils;
import org.python.icu.impl.number.parse.SymbolMatcher;
import org.python.icu.text.DecimalFormatSymbols;

public class InfinityMatcher
extends SymbolMatcher {
    private static final InfinityMatcher DEFAULT = new InfinityMatcher();

    public static InfinityMatcher getInstance(DecimalFormatSymbols symbols2) {
        String symbolString = symbols2.getInfinity();
        if (ParsingUtils.safeContains(InfinityMatcher.DEFAULT.uniSet, symbolString)) {
            return DEFAULT;
        }
        return new InfinityMatcher(symbolString);
    }

    private InfinityMatcher(String symbolString) {
        super(symbolString, InfinityMatcher.DEFAULT.uniSet);
    }

    private InfinityMatcher() {
        super(StaticUnicodeSets.Key.INFINITY);
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return 0 != (result2.flags & 0x80);
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.flags |= 0x80;
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<InfinityMatcher>";
    }
}

