/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.Utils;
import com.huawei.ism.util.parser.XmlParser;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Event
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    private static final long serialVersionUID = -4467061853203606299L;
    private static final String MIXED_PARAM_SEPERATOR = "$(";
    private static final String MIXED_PARAM_SEPERATOR_REGEX = "\\$\\(";
    private static final String ALARM_PARAMETER_SEPARATOR = ",";
    private static final String ALARM_PARAMETER_PLACEHOLDER_PREFIX = "##";
    private static EventConfLoader cfgloader = new EventConfLoader();
    private static final String PARAM_RAPLACE_REGEX = "@@@";
    private static Map<Locale, EventConfigData> sharedEventConfigDataLocal = new ConcurrentHashMap<Locale, EventConfigData>();
    private static final long EVENT_ID_1 = 35192996233236L;
    private static final long EVENT_ID_2 = 35192996233237L;
    private static final long EVENT_ID_3 = 35192996233238L;
    private static final long EVENT_ID_4 = 146063097876L;
    private static final long EVENT_ID_5 = 146063097877L;
    private static final long EVENT_ID_6 = 146063097878L;
    private static final long EVENT_ID_7 = 146063097879L;
    private static final long EVENT_ID_8 = 146063097880L;
    private static final long EVENT_ID_9 = 146063097881L;
    private static final long EVENT_ID_10 = 146063097882L;
    private static final long EVENT_ID_11 = 146063097883L;
    private static final long EVENT_ID_12 = 146063097884L;
    private static final long EVENT_ID_13 = 146063097885L;
    private static final long EVENT_ID_14 = 146063097886L;
    private static final long EVENT_ID_15 = 146063097887L;
    private static final long EVENT_ID_16 = 0x22020A0020L;
    private static final long EVENT_ID_17 = 146063097889L;
    private static final long EVENT_ID_18 = 0x22020A0022L;
    private static final long EVENT_ID_19 = 146063097891L;
    private static final long EVENT_ID_20 = 146063097892L;
    private static final long EVENT_ID_21 = 146063097893L;
    private static final long EVENT_ID_22 = 146063097894L;
    private static final long EVENT_ID_23 = 146063097895L;
    private static final long EVENT_ID_24 = 146063097896L;
    private String name = "";
    private String detail = "";
    private String description = "";
    private String suggestion = "";
    private String eventParam;
    private Locale locale;
    private StringBuffer parserdParam = new StringBuffer();
    private long eventID;
    private Identifier identifier;
    private Type type;
    private Level level;
    private long startTime;
    private long recoverTime;
    private long confirmTime;

    public Event(Identifier identifier) {
        this.identifier = identifier;
    }

    public Event(Identifier identifier, Level level, long eventID) {
        this(identifier, level, eventID, "");
    }

    public Event(Identifier identifier, Level level, long eventID, String eventParam) {
        this(identifier, level, eventID, eventParam, ResourceManager.getLocale());
    }

    public Event(Identifier identifier, Level level, long eventID, String eventParam, Locale loc) {
        this.identifier = identifier;
        this.eventID = eventID;
        this.level = level;
        this.eventParam = eventParam;
        this.locale = loc;
        EventConfigData eventConfigData = sharedEventConfigDataLocal.get(loc);
        if (null != eventConfigData) {
            this.parseEventParam(eventParam);
        }
    }

    public Locale getLocle() {
        return this.getEventCfgData().getLocale();
    }

    public boolean equals(Object object) {
        if (null == object || !(object instanceof Event)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.identifier.equals(((Event)object).identifier);
    }

    public String getEventParam() {
        return this.eventParam;
    }

    public String getEventParserdParam() {
        if (null == this.parserdParam || "".equals(this.parserdParam.toString())) {
            return this.eventParam;
        }
        if (this.parserdParam.toString().endsWith(ALARM_PARAMETER_SEPARATOR)) {
            this.parserdParam.setLength(this.parserdParam.length() - 1);
        }
        return this.parserdParam.toString();
    }

    public long getEventID() {
        return this.eventID;
    }

    public String getLevelString() {
        return ResourceManager.getString("Event_Level_" + this.level.name(), this.level.name(), this.getEventCfgData().getLocale());
    }

    public Level getLevel() {
        return this.level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getConfirmTime() {
        return this.confirmTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public long getRecoverTime() {
        return this.recoverTime;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.getClass().hashCode();
        hashCode += 37 * hashCode + this.identifier.hashCode();
        return hashCode;
    }

    public boolean isConfirmed() {
        return this.confirmTime > 0L;
    }

    public boolean isRecovered() {
        return this.recoverTime > 0L;
    }

    public void setConfirmTime(long confirmTime) {
        this.confirmTime = confirmTime;
    }

    public void setRecoverTime(long recoverTime) {
        this.recoverTime = recoverTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("Identifier", (Object)this.identifier).append("EventID", this.eventID).append("EventName", (Object)this.name).append("StartTime", (Object)new Date(this.startTime)).append("RecoverTime", (Object)new Date(this.recoverTime)).append("ConfirmTime", (Object)new Date(this.confirmTime)).append("EventLevel", (Object)this.level).append("Description", (Object)this.description).append("Suggest", (Object)this.suggestion).toString();
    }

    protected EventConfigData getEventCfgData() {
        return sharedEventConfigDataLocal.get(this.locale);
    }

    private void parseEventParam(String eventParamValue) {
        Definition eventDef = this.getEventCfgData().getDefintionMap().get(this.eventID);
        if (eventDef == null) {
            return;
        }
        String paramDesc = eventDef.definitionParamDesc;
        this.name = this.replaceParams(eventParamValue, paramDesc, eventDef.definitionName, false);
        this.detail = this.replaceParams(eventParamValue, paramDesc, eventDef.definitionDetail, false);
        this.suggestion = this.replaceParams(eventParamValue, paramDesc, eventDef.definitionSuggestion, false);
        this.description = this.replaceParams(eventParamValue, paramDesc, eventDef.definitionDescription, true);
    }

    private String replaceParams(String params, String paramDescs, String rawContent, boolean ifParserd) {
        String actualRawContent = rawContent;
        if (null != actualRawContent && actualRawContent.length() > 0 && null != params) {
            String[] paramList = this.splitParams(params);
            Map<String, String> paramDescMap = this.parseParamDesc(paramDescs);
            for (int i = 0; i < paramList.length; ++i) {
                actualRawContent = this.getString(params, paramDescs, actualRawContent, ifParserd, paramList[i], paramDescMap, i);
            }
            try {
                actualRawContent = Utils.matchBlank(actualRawContent);
                actualRawContent = actualRawContent.replaceAll(PARAM_RAPLACE_REGEX, "");
            }
            catch (Exception e) {
                LOGGER.warn("matchBlank error:" + e.getMessage() + " alarmId is:" + this.eventID, (Throwable)e);
            }
        }
        return actualRawContent;
    }

    private String getString(String params, String paramDescs, String rawContent, boolean ifParserd, String param1, Map<String, String> paramDescMap, int i) {
        String number = (i <= 9 ? "0" : "") + i;
        String regex = ALARM_PARAMETER_PLACEHOLDER_PREFIX + number;
        String param = param1;
        if (param.contains(MIXED_PARAM_SEPERATOR)) {
            param = param.replaceAll(MIXED_PARAM_SEPERATOR_REGEX, ALARM_PARAMETER_SEPARATOR);
        }
        String parserdParamValue = param;
        if (paramDescMap.containsKey(String.valueOf(i))) {
            String paramDesc = paramDescMap.get(String.valueOf(i));
            String oprateType = "";
            if (paramDescs.contains("OprateType")) {
                oprateType = this.getEventCfgData().getOprateMap().get(this.eventID).definitionOprateType;
            }
            String paramDescKey = "EventParamDesc_" + paramDesc + oprateType + '_' + param.trim();
            param = this.handleNonEnumTypeParamDesc(paramDesc, param);
            parserdParamValue = ResourceManager.getString(paramDescKey, param);
        }
        parserdParamValue = this.parseIDParams(i, param, parserdParamValue);
        String result = rawContent;
        try {
            String temp0 = parserdParamValue.trim();
            temp0 = this.convertSpecialChars(temp0);
            result = result.replaceAll(regex, PARAM_RAPLACE_REGEX + temp0);
        }
        catch (Exception e) {
            LOGGER.error("Event.replaceParams error: Event ID:" + this.eventID + " Event Params:" + params + " Raw content:" + result, (Throwable)e);
        }
        if (ifParserd) {
            this.parserdParam.append(parserdParamValue);
            this.parserdParam.append(ALARM_PARAMETER_SEPARATOR);
        }
        return result;
    }

    private String parseIDParams(int i, String param, String parserdParamValue) {
        String resultValue = parserdParamValue;
        if (EventConfigData.getConsistentGrpMap().containsKey(this.eventID)) {
            try {
                String tempString = EventConfigData.getConsistentGrpMap().get(this.eventID);
                if (!"".equals(tempString) && tempString.contains(String.valueOf(i))) {
                    resultValue = Long.toHexString(Long.valueOf(param.trim()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Process ConsistentGrp Alarm error:" + e.getMessage(), (Throwable)e);
            }
        }
        return resultValue;
    }

    private Map<String, String> parseParamDesc(String paramDescs) {
        HashMap<String, String> paramDescMap = new HashMap<String, String>(0);
        if (null != paramDescs && paramDescs.length() > 0) {
            String[] paramDescList = paramDescs.split(ALARM_PARAMETER_SEPARATOR);
            String[] keyValue = null;
            for (String paramDesc : paramDescList) {
                keyValue = paramDesc.split("=");
                if (keyValue.length < 2) continue;
                paramDescMap.put(keyValue[0], keyValue[1]);
            }
        }
        return paramDescMap;
    }

    private String[] splitParams(String params) {
        String[] paramList = params.split(ALARM_PARAMETER_SEPARATOR, -1);
        int index = 0;
        for (String param : paramList) {
            if (null == param || "".equals(param)) {
                paramList[index] = "--";
            }
            ++index;
        }
        return paramList;
    }

    private String handleNonEnumTypeParamDesc(String paramDesc, String param) {
        if ("TimeUnit".equals(paramDesc)) {
            long value = Long.parseLong(param.trim());
            Date date = new Date(value * 1000L);
            TimeZone timeZone = FrameworkCommon.getInstance().getDeviceTimeZone(this.identifier.getDeviceID());
            return TimeUtil.gmtToString(date, timeZone);
        }
        if ("TimeUnitNoYear".equals(paramDesc)) {
            long value = Long.parseLong(param.trim());
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            return timeFormat.format(new Date(value * 1000L));
        }
        try {
            if ("ConsistentGroupID".equals(paramDesc) || "ReplicationID".equals(paramDesc)) {
                return this.convert2HEX(param);
            }
        }
        catch (Exception e) {
            LOGGER.error("Convert ConsistentGroupID or ReplicationID error,id is " + param, (Throwable)e);
        }
        return param;
    }

    private String convert2HEX(String param) {
        BigInteger bigInteger = new BigInteger(param);
        String id = bigInteger.toString(16).toUpperCase(ResourceManager.getLocale());
        if (id.length() < 16) {
            int count = 16 - id.length();
            for (int i = 0; i < count; ++i) {
                id = '0' + id;
            }
        }
        return id;
    }

    public static void updateConsistenGrp(Map<Long, String> consGrp) {
        EventConfigData.getConsistentGrpMap().clear();
        EventConfigData.getConsistentGrpMap().putAll(consGrp);
    }

    public static void loadEventConfig(Locale loc) throws IOException {
        EventConfigData eventCfg = new EventConfigData(loc);
        cfgloader.initEventDefinition(eventCfg);
        sharedEventConfigDataLocal.put(loc, eventCfg);
    }

    public static void setLoader(EventConfLoader loader) {
        cfgloader = loader;
    }

    private String convertSpecialChars(String original) {
        char[] x2;
        StringBuilder sb = new StringBuilder();
        for (char ch : x2 = original.toCharArray()) {
            if (ch == '$') {
                sb.append("\\$");
                continue;
            }
            if (ch == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static {
        try {
            Locale loc = ResourceManager.getLocale();
            EventConfigData eventConfigDataLocal = new EventConfigData(loc);
            cfgloader.initEventDefinition(eventConfigDataLocal);
            sharedEventConfigDataLocal.put(loc, eventConfigDataLocal);
        }
        catch (Exception e) {
            LOGGER.error("initEventDefinition error", (Throwable)e);
        }
    }

    public static class EventConfLoader {
        public void initEventDefinition(EventConfigData eventCfgData) throws IOException {
            for (XmlParser domParser : this.getConfParser(eventCfgData.getLocale())) {
                this.parseEvents(domParser, eventCfgData);
            }
        }

        protected List<XmlParser> getConfParser(Locale loc) throws IOException {
            ArrayList<XmlParser> ret = new ArrayList<XmlParser>();
            ret.add(XmlParser.getXmlDomParser("config/framework/configuration/event_" + loc.getLanguage() + ".xml"));
            ret.add(XmlParser.getXmlDomParser("config/framework/configuration/event_xve_" + loc.getLanguage() + ".xml"));
            return ret;
        }

        protected void parseEvents(XmlParser domParser, EventConfigData eventCfgData) {
            Element node = domParser.treeWalkOfOneElementNode("eventDefinition");
            if (null == node) {
                throw new NullPointerException();
            }
            Element element = node;
            NodeList nodeList = element.getElementsByTagName("param");
            Definition definition = null;
            Node rowNode = null;
            int length = nodeList.getLength();
            NamedNodeMap nodeMap = null;
            String eventIDStr = null;
            long eventID = 0L;
            Node oprateNode = null;
            for (int i = 0; i < length; ++i) {
                definition = new Definition();
                rowNode = nodeList.item(i);
                nodeMap = rowNode.getAttributes();
                eventIDStr = nodeMap.getNamedItem("eventID").getNodeValue();
                if (null == eventIDStr || eventIDStr.length() == 0) continue;
                eventID = Long.decode(eventIDStr);
                definition.definitionDetail = nodeMap.getNamedItem("detail").getNodeValue();
                definition.definitionSuggestion = nodeMap.getNamedItem("suggestion").getNodeValue();
                definition.definitionName = nodeMap.getNamedItem("name").getNodeValue();
                definition.definitionDescription = nodeMap.getNamedItem("description").getNodeValue();
                if (nodeMap.getNamedItem("paramDesc") == null) {
                    definition.definitionParamDesc = "";
                } else {
                    definition.definitionParamDesc = nodeMap.getNamedItem("paramDesc").getNodeValue();
                }
                eventCfgData.getDefintionMap().put(eventID, definition);
                oprateNode = nodeMap.getNamedItem("OprateType");
                if (null == oprateNode) continue;
                definition.definitionOprateType = oprateNode.getNodeValue();
                eventCfgData.getOprateMap().put(eventID, definition);
            }
        }
    }

    private static class Definition {
        private String definitionDetail;
        private String definitionName;
        private String definitionDescription;
        private String definitionSuggestion;
        private String definitionParamDesc;
        private String definitionOprateType;

        private Definition() {
        }
    }

    public static enum Type {
        FAULT(0),
        EVENT(1),
        RESUME(2),
        OPERATION_LOG(3),
        RUNNING_LOG(4);

        private int val;

        private Type(int val) {
            this.val = val;
        }

        public static Type valueOf(int nType) {
            for (Type type : Type.values()) {
                if (type.val != nType) continue;
                return type;
            }
            return EVENT;
        }

        public int getValue() {
            return this.val;
        }
    }

    public static enum Level {
        INFO("Info", 2, "info.png"),
        WARNING("Warning", 3, "warning.png"),
        MAJOR("Major", 5, "major.png"),
        CRITICAL("Critical", 6, "critical.png");

        private int levelValue;
        private String iconKey;
        private String name;
        private String strKey = "Event_Level_" + this.getName();

        private Level(String name, int level, String iconKey) {
            this.levelValue = level;
            this.iconKey = iconKey;
            this.name = name;
        }

        public static Level valueOf(int nLevel) {
            for (Level level : Level.values()) {
                if (level.levelValue != nLevel) continue;
                return level;
            }
            return INFO;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.levelValue;
        }

        public String toString() {
            return ResourceManager.getString(this.strKey, this.getName());
        }

        public boolean isFault() {
            switch (this) {
                case WARNING: 
                case MAJOR: 
                case CRITICAL: {
                    return true;
                }
            }
            return false;
        }

        public String getIconKey() {
            return this.iconKey;
        }
    }

    public static class Identifier
    implements Serializable {
        private static final long serialVersionUID = 8468503836385192415L;
        private long alarmSN;
        private String deviceID;

        public Identifier(String deviceID, long alarmSN) {
            this.deviceID = deviceID;
            this.alarmSN = alarmSN;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (null == this.deviceID || null == object || !(object instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)object;
            return this.deviceID.equals(that.deviceID) && this.alarmSN == that.alarmSN;
        }

        public long getEventSN() {
            return this.alarmSN;
        }

        public String getDeviceID() {
            return this.deviceID;
        }

        public int hashCode() {
            long hashCode = 17L;
            hashCode = 37L * hashCode + (long)this.getClass().hashCode();
            hashCode = 37L * hashCode + (long)this.deviceID.hashCode();
            hashCode = 37L * hashCode + this.alarmSN;
            return (int)hashCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("DeviceID", (Object)this.deviceID).append("AlarmSN", this.alarmSN).toString();
        }
    }

    protected static class EventConfigData {
        private static Map<Long, String> consistentGrpMap = new HashMap<Long, String>();
        private Map<Long, Definition> definitionMap = new HashMap<Long, Definition>();
        private Map<Long, Definition> oprateMap = new HashMap<Long, Definition>();
        private Locale locale;

        public EventConfigData(Locale loc) {
            this.locale = loc;
        }

        private static void initConsistentGrp(Map<Long, String> consGrpMap) {
            consGrpMap.put(35192996233236L, "");
            consGrpMap.put(35192996233237L, "1");
            consGrpMap.put(35192996233238L, "1");
            consGrpMap.put(146063097876L, "");
            consGrpMap.put(146063097877L, "1");
            consGrpMap.put(146063097878L, "1");
            consGrpMap.put(146063097879L, "1");
            consGrpMap.put(146063097880L, "1");
            consGrpMap.put(146063097881L, "1");
            consGrpMap.put(146063097882L, "1");
            consGrpMap.put(146063097883L, "1");
            consGrpMap.put(146063097884L, "1");
            consGrpMap.put(146063097885L, "1");
            consGrpMap.put(146063097886L, "1");
            consGrpMap.put(146063097887L, "");
            consGrpMap.put(0x22020A0020L, "1");
            consGrpMap.put(146063097889L, "1");
            consGrpMap.put(0x22020A0022L, "1,2");
            consGrpMap.put(146063097891L, "1,2");
            consGrpMap.put(146063097892L, "1");
            consGrpMap.put(146063097893L, "1");
            consGrpMap.put(146063097894L, "1");
            consGrpMap.put(146063097895L, "1");
            consGrpMap.put(146063097896L, "1");
        }

        public void setLocale(Locale loc) {
            this.locale = loc;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Map<Long, Definition> getDefintionMap() {
            return this.definitionMap;
        }

        public Map<Long, Definition> getOprateMap() {
            return this.oprateMap;
        }

        public static Map<Long, String> getConsistentGrpMap() {
            return consistentGrpMap;
        }

        static {
            EventConfigData.initConsistentGrp(consistentGrpMap);
        }
    }
}

