/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class User
implements Cloneable {
    public static final String TEMP_USER_KEY = "temp_user_key";
    private String deviceID = "temp_user_key";
    private USER_SCOPE userScope;
    private String id;
    private Level level = Level.ReadOnly;
    private Status userStatus = Status.Offline;
    private Scope scope = Scope.LOCAL;
    private AuthMode authMode = AuthMode.LOCAL;
    private String userGroup = "";
    private AccessType accessType = AccessType.READ_WRITE;
    private String createTime;
    private String plainPassword;
    private String userName;
    private String sessionKey;
    private String localUserAddressinfo;
    private String devicelUserAddressinfo;
    private long pwdChangeTime;

    public User(String userName) {
        this.userName = userName;
    }

    public User(String name, String password) {
        this.setUserName(name);
        this.setPassword(password);
    }

    public User(String name, String password, USER_SCOPE userScope) {
        this.setUserName(name);
        this.setPassword(password);
        this.setUserScope(userScope);
    }

    public long getPwdChangeTime() {
        return this.pwdChangeTime;
    }

    public void setPwdChangeTime(long pwdChangeTime) {
        this.pwdChangeTime = pwdChangeTime;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getPassword() {
        return AESEncrypt.decrypt(this.plainPassword);
    }

    public String getUserName() {
        return this.userName;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLevelDescriptor() {
        if (null == this.level) {
            return "--";
        }
        return this.level.getDescription();
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setPassword(String password) {
        this.plainPassword = AESEncrypt.encrypt(password);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Status getStatus() {
        return this.userStatus;
    }

    public void setStatus(Status status) {
        this.userStatus = status;
    }

    public String getDevicelUserAddressinfo() {
        return this.devicelUserAddressinfo;
    }

    public void setDevicelUserAddressinfo(String userAddressinfo) {
        this.devicelUserAddressinfo = userAddressinfo;
    }

    public String getLocalUserAddressinfo() {
        return this.localUserAddressinfo;
    }

    public void setLocalUserAddressinfo(String userAddressinfo) {
        this.localUserAddressinfo = userAddressinfo;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String key) {
        this.sessionKey = key;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("DeviceID", (Object)this.deviceID).append("UserName", (Object)this.userName).append("Level", (Object)this.level).append("CreateTime", (Object)this.createTime).append("LoginStatus", (Object)this.userStatus).append("localUserAddressinfo", (Object)this.localUserAddressinfo).append("DevicelUserAddressinfo", (Object)this.devicelUserAddressinfo).append("AccessType", (Object)this.accessType.name()).append("Scope", (Object)this.scope.name()).append("UserGroup", (Object)this.userName).append("AuthMode", (Object)this.authMode.toString()).toString();
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scopeIn) {
        this.scope = scopeIn;
    }

    public AuthMode getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(AuthMode authMode) {
        this.authMode = authMode;
    }

    public User clone() throws CloneNotSupportedException {
        return (User)super.clone();
    }

    public USER_SCOPE getUserScope() {
        return this.userScope;
    }

    public void setUserScope(USER_SCOPE userScope) {
        this.userScope = userScope;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String idIn) {
        this.id = idIn;
    }

    public static enum AccessType {
        READ_ONLY(0),
        READ_WRITE(1);

        private int value;

        private AccessType(int value) {
            this.value = value;
        }

        public static AccessType valueOf(int value) {
            for (AccessType level : AccessType.values()) {
                if (level.getValue() != value) continue;
                return level;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Status {
        Online(0),
        Offline(1),
        Locked(2),
        Pwd_expired(3),
        Pwd_initial(4),
        Pwd_expiring(5),
        Pwd_unSafe(6);

        private int value;

        private Status(int value) {
            this.value = value;
        }

        public static Status valueOf(int iValue) {
            for (Status value : Status.values()) {
                if (value.value != iValue) continue;
                return value;
            }
            throw new IllegalArgumentException("wrong USER_STATE_E value:" + iValue);
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return ResourceManager.getString("User.Status." + this.toString());
        }
    }

    public static enum Level {
        SuperAdmin(1),
        Admin(2),
        ReadOnly(3),
        StorageAdmin(4);

        private int value;

        private Level(int value) {
            this.value = value;
        }

        public static Level valueOf(int iLevel) {
            for (Level level : Level.values()) {
                if (level.getValue() != iLevel) continue;
                return level;
            }
            throw new IllegalArgumentException("wrong user type value:" + iLevel);
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return ResourceManager.getString("User.Level." + this.toString());
        }
    }

    public static enum Scope {
        LOCAL(0),
        LDAP(1),
        LDAP_GROUP(2);

        private int value;

        private Scope(int value) {
            this.value = value;
        }

        public String toString() {
            return ResourceManager.getString("USER_SCOPE_" + this.name());
        }

        public static Scope valueOf(int intValue) throws IsmException {
            Scope[] values;
            for (Scope s : values = Scope.values()) {
                if (s.getValue() != intValue) continue;
                return s;
            }
            throw new IsmException(-1L, "wrong Scope value ! type:" + intValue);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum USER_SCOPE {
        LOCAL(0),
        LDAP(1);

        private int value;

        private USER_SCOPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static USER_SCOPE valueOf(int iValue) {
            for (USER_SCOPE value : USER_SCOPE.values()) {
                if (value.value != iValue) continue;
                return value;
            }
            throw new IllegalArgumentException("wrong USER_SCOPE_E value:" + iValue);
        }

        public String toString() {
            return ResourceManager.getString("EnumDefine." + ((Object)((Object)this)).getClass().getSimpleName() + '.' + this.name());
        }
    }

    public static enum AuthMode {
        LOCAL(0),
        LDAP(1);

        private int value;

        private AuthMode(int value) {
            this.value = value;
        }

        public static AuthMode valueOf(int value) {
            for (AuthMode type : AuthMode.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return ResourceManager.getString("DEVICECONTEXT_AUTHMODE_" + this.name());
        }

        public int getValue() {
            return this.value;
        }
    }
}

