/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.notification;

import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Param;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandshakeThread.class);
    private static final int HAND_SHAKE_INTERVAL = 10000;
    private static final short HAND_SHAKE_MSG_SN = 1;
    private Map<Socket, String> notiConn2Sessionkey;
    private DataPackage handshakeMsg;
    private final Object LOCK = new Object();

    public HandshakeThread() {
        this.notiConn2Sessionkey = new HashMap<Socket, String>();
        this.handshakeMsg = TLVUtils.param2DP(55847813125L, "0", TLVUtils.paramList(new Param[0]));
    }

    public void setHandshakeMsg(DataPackage dataPackage) {
        if (null != dataPackage) {
            this.handshakeMsg = dataPackage;
        }
    }

    public synchronized void addTask(Socket socket, String sessionkey) {
        this.notiConn2Sessionkey.put(socket, sessionkey);
        this.notifyAll();
    }

    public synchronized void removeTask(Socket socket) {
        this.notiConn2Sessionkey.remove(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.handshakeMsg.getHead().setSerial((short)1);
        HashMap<Socket, String> tmp = new HashMap<Socket, String>(0);
        while (!Thread.interrupted()) {
            try {
                tmp.clear();
                Object object = this.LOCK;
                synchronized (object) {
                    while (this.notiConn2Sessionkey.isEmpty()) {
                        this.wait();
                    }
                    tmp.putAll(this.notiConn2Sessionkey);
                }
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            Iterator iter = tmp.entrySet().iterator();
            Map.Entry entry = null;
            while (iter.hasNext()) {
                entry = iter.next();
                try {
                    this.handshakeMsg.getHead().setSessionKey(Long.valueOf((String)entry.getValue()));
                    byte[] handshakemsg = this.handshakeMsg.toByteArray();
                    ((Socket)entry.getKey()).getOutputStream().write(handshakemsg);
                }
                catch (IOException e) {
                    LOGGER.warn(" handshake in notification connection failed:" + ((Socket)entry.getKey()).getRemoteSocketAddress(), (Throwable)e);
                }
            }
        }
    }
}

