/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.docoder;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class BitUtils {
    private BitUtils() {
    }

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char bytes2Char(byte[] bytes, int off) {
        return (char)(((bytes[off + 1] & 0xFF) << 0) + ((bytes[off + 0] & 0xFF) << 8));
    }

    public static short bytes2Short(byte[] bytes, int off) {
        int result = ((bytes[off + 1] & 0xFF) << 0) + ((bytes[off + 0] & 0xFF) << 8);
        return (short)result;
    }

    public static int bytes2Int(byte[] bytes, int off) {
        return ((bytes[off + 3] & 0xFF) << 0) + ((bytes[off + 2] & 0xFF) << 8) + ((bytes[off + 1] & 0xFF) << 16) + ((bytes[off + 0] & 0xFF) << 24);
    }

    public static float bytes2Float(byte[] bytes, int off) {
        int i = ((bytes[off + 3] & 0xFF) << 0) + ((bytes[off + 2] & 0xFF) << 8) + ((bytes[off + 1] & 0xFF) << 16) + ((bytes[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i);
    }

    public static long bytes2Long(byte[] bytes, int off) {
        long longResult = ((long)bytes[off + 7] & 0xFFL) << 0;
        longResult += ((long)bytes[off + 6] & 0xFFL) << 8;
        longResult += ((long)bytes[off + 5] & 0xFFL) << 16;
        longResult += ((long)bytes[off + 4] & 0xFFL) << 24;
        longResult += ((long)bytes[off + 3] & 0xFFL) << 32;
        longResult += ((long)bytes[off + 2] & 0xFFL) << 40;
        longResult += ((long)bytes[off + 1] & 0xFFL) << 48;
        return longResult += ((long)bytes[off + 0] & 0xFFL) << 56;
    }

    public static double bytes2Double(byte[] bytes, int off) {
        long longResult = ((long)bytes[off + 7] & 0xFFL) << 0;
        longResult += ((long)bytes[off + 6] & 0xFFL) << 8;
        longResult += ((long)bytes[off + 5] & 0xFFL) << 16;
        longResult += ((long)bytes[off + 4] & 0xFFL) << 24;
        longResult += ((long)bytes[off + 3] & 0xFFL) << 32;
        longResult += ((long)bytes[off + 2] & 0xFFL) << 40;
        longResult += ((long)bytes[off + 1] & 0xFFL) << 48;
        return Double.longBitsToDouble(longResult += ((long)bytes[off + 0] & 0xFFL) << 56);
    }

    public static short getUsignByte(byte[] b, int off) {
        return (short)(b[off] & 0xFF);
    }

    public static int getUsignShort(byte[] b, int off) {
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8);
    }

    public static long getUsignInt(byte[] bytes, int off) {
        int tempK = (bytes[off + 0] & 0xFF) << 0;
        int tmpJ = (bytes[off + 1] & 0xFF) << 8;
        int tmpL = (bytes[off + 2] & 0xFF) << 16;
        int tmpM = (bytes[off + 3] & 0xFF) << 24;
        int tmpI = tempK + tmpJ + tmpL + tmpM;
        return (long)tmpI & 0xFFFFFFFFL;
    }

    public static byte[] boolean2ByteArray(boolean val) {
        byte[] b = new byte[]{(byte)(val ? 1 : 0)};
        return b;
    }

    public static byte[] char2ByteArray(char val) {
        byte[] b = new byte[2];
        b[1] = (byte)(val >>> 0);
        b[0] = (byte)(val >>> 8);
        return b;
    }

    public static byte[] short2ByteArray(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)(val >>> 0);
        b[0] = (byte)(val >>> 8);
        return b;
    }

    public static byte[] int2ByteArray(int val) {
        byte[] b = new byte[4];
        b[3] = (byte)(val >>> 0);
        b[2] = (byte)(val >>> 8);
        b[1] = (byte)(val >>> 16);
        b[0] = (byte)(val >>> 24);
        return b;
    }

    public static byte[] float2ByteArray(float val) {
        byte[] b = new byte[4];
        int i = Float.floatToIntBits(val);
        b[3] = (byte)(i >>> 0);
        b[2] = (byte)(i >>> 8);
        b[1] = (byte)(i >>> 16);
        b[0] = (byte)(i >>> 24);
        return b;
    }

    public static byte[] long2ByteArray(long val) {
        byte[] b = new byte[8];
        b[7] = (byte)(val >>> 0);
        b[6] = (byte)(val >>> 8);
        b[5] = (byte)(val >>> 16);
        b[4] = (byte)(val >>> 24);
        b[3] = (byte)(val >>> 32);
        b[2] = (byte)(val >>> 40);
        b[1] = (byte)(val >>> 48);
        b[0] = (byte)(val >>> 56);
        return b;
    }

    public static byte[] double2ByteArray(double val) {
        byte[] bytes = new byte[8];
        long tmpJ = Double.doubleToLongBits(val);
        bytes[7] = (byte)(tmpJ >>> 0);
        bytes[6] = (byte)(tmpJ >>> 8);
        bytes[5] = (byte)(tmpJ >>> 16);
        bytes[4] = (byte)(tmpJ >>> 24);
        bytes[3] = (byte)(tmpJ >>> 32);
        bytes[2] = (byte)(tmpJ >>> 40);
        bytes[1] = (byte)(tmpJ >>> 48);
        bytes[0] = (byte)(tmpJ >>> 56);
        return bytes;
    }

    public static int orderInt(int input) {
        return Integer.reverseBytes(input);
    }

    public static short orderShort(short input) {
        return Short.reverseBytes(input);
    }

    public static long orderLong(long input) {
        return Long.reverseBytes(input);
    }

    public static byte[] stringToByteArray(String str, int length) {
        if (str == null) {
            return new byte[length];
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = i < str.length() ? (byte)str.charAt(i) : (byte)0;
        }
        return bytes;
    }

    public static byte[] stringToUtf8ByteArray(String str) {
        if (str == null) {
            return new byte[0];
        }
        try {
            byte[] originalArray = str.getBytes("utf-8");
            byte[] newArray = Arrays.copyOf(originalArray, originalArray.length + 1);
            newArray[originalArray.length] = 0;
            return newArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new IsmException(-1L, (Throwable)e);
        }
    }

    public static String byteArrayToString(byte[] b, int length, int offset) {
        StringBuffer sb = new StringBuffer();
        int iterOffset = offset;
        for (int i = 0; i < length && b[iterOffset] != 0; ++i) {
            sb.append((char)b[iterOffset]);
            ++iterOffset;
        }
        return sb.toString();
    }

    public static String utf8ByteArrayToString(byte[] b, int length, int offset) {
        try {
            return new String(b, offset, length - 1, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            ToolLoggerFactory.getLogger(BitUtils.class).error("UnsupportedEncodingException", (Throwable)e);
            throw new IsmException(-1L, (Throwable)e);
        }
    }
}

