/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.lang;

import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmUnsignedInteger;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsignedInt64
extends IsmUnsignedInteger {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsignedInt64.class);
    private static final long serialVersionUID = -2709436714093579811L;
    private final long unSignedInt64value;

    public UnsignedInt64(long value) {
        this.unSignedInt64value = value;
    }

    public UnsignedInt64(byte[] bytes) {
        this.unSignedInt64value = this.fromByteArray(bytes, bytes.length);
    }

    public UnsignedInt64(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 8) {
            LOGGER.error("bytes.length is : " + bytes.length);
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[8];
        System.arraycopy(bytes, offset, tmp, 0, 8);
        this.unSignedInt64value = this.fromByteArray(tmp, tmp.length);
    }

    public UnsignedInt64(BigInteger value) {
        this.unSignedInt64value = value.longValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.unSignedInt64value ^ this.unSignedInt64value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt64 other = (UnsignedInt64)obj;
        return this.unSignedInt64value == other.unSignedInt64value;
    }

    private long fromByteArray(byte[] values, int bytesToRead) {
        if (values.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        long longVal = 0L;
        int arrayLength = values.length;
        int count = bytesToRead >= 8 ? 8 : bytesToRead;
        longVal = values[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            longVal <<= 8;
            longVal |= (long)(values[arrayLength - i] & 0xFF);
        }
        return longVal;
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[8];
        returnArray[7] = (byte)(this.unSignedInt64value >>> 56);
        returnArray[6] = (byte)(this.unSignedInt64value >>> 48 & 0xFFL);
        returnArray[5] = (byte)(this.unSignedInt64value >>> 40 & 0xFFL);
        returnArray[4] = (byte)(this.unSignedInt64value >>> 32 & 0xFFL);
        returnArray[3] = (byte)(this.unSignedInt64value >>> 24 & 0xFFL);
        returnArray[2] = (byte)(this.unSignedInt64value >>> 16 & 0xFFL);
        returnArray[1] = (byte)(this.unSignedInt64value >>> 8 & 0xFFL);
        returnArray[0] = (byte)this.unSignedInt64value;
        return returnArray;
    }

    @Override
    public byte[] toByteArray(int bytesToWrite) {
        byte[] buff;
        byte[] fillerBuff = this.toByteArray();
        if (fillerBuff.length == bytesToWrite) {
            buff = fillerBuff;
        } else {
            buff = new byte[bytesToWrite];
            int length = 0;
            length = fillerBuff.length < bytesToWrite ? fillerBuff.length : bytesToWrite;
            System.arraycopy(fillerBuff, 0, buff, 0, length);
        }
        return buff;
    }

    @Override
    public double doubleValue() {
        return this.unSignedInt64value;
    }

    @Override
    public float floatValue() {
        return this.unSignedInt64value;
    }

    @Override
    public int intValue() {
        return (int)this.unSignedInt64value;
    }

    @Override
    public long longValue() {
        return this.unSignedInt64value;
    }

    @Override
    public ParamType getType() {
        return ParamType.U64LONG_TYPE;
    }

    @Override
    public boolean isFFFF() {
        return this.unSignedInt64value == -1L;
    }

    public BigInteger bigIntergerValue() {
        return new BigInteger(Long.toHexString(this.unSignedInt64value), 16);
    }

    @Override
    public String toString() {
        return this.bigIntergerValue().toString();
    }
}

