/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;

public class EthPortMO
extends HardwareInfoAdapter
implements IPortInfo {
    private static final int MAGICNUMBER = 255;
    private final MO mo;

    public EthPortMO(MO mo) {
        this.mo = mo;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.TYPE).toString()));
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.ETH_PORT.TYPE, type.getValue());
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.ETH_PORT.ID, id);
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.ETH_PORT.PARENTTYPE, parentType.getValue());
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.ETH_PORT.PARENTID, parentID);
    }

    public void setName(String name) {
        this.mo.setProperty(TLV.ETH_PORT.NAME, name);
    }

    public int getSlotID() {
        return (int)(Long.valueOf(this.getID()) & 0xFFL);
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.ETH_PORT.ID);
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.ETH_PORT.NAME);
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.PARENTTYPE).toString());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.ETH_PORT.PARENTID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.ETH_PORT.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.ETH_PORT.LOCATION, location);
    }

    public Param getLocationParam() {
        if (this.getLocation() == null) {
            return null;
        }
        return new Param(TLV.ETH_PORT.LOCATION.getParamIndex(), TLV.ETH_PORT.LOCATION.getParamType(), this.getLocation());
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.HEALTHSTATUS).toString());
    }

    @Override
    public int getRunningStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.RUNNINGSTATUS).toString());
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E status) {
        this.mo.setProperty(TLV.ETH_PORT.RUNNINGSTATUS, status.getValue());
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.ETH_PORT.COUNT);
    }

    public EnumDefine.PORT_LOGIC_TYPE_E getLogicType() {
        return EnumDefine.PORT_LOGIC_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.LOGICTYPE).toString()));
    }

    public String getMacAddress() {
        return this.mo.getStrProperty(TLV.ETH_PORT.MACADDRESS);
    }

    public EnumDefine.INI_OR_TGT_E getIniOrTgt() {
        return EnumDefine.INI_OR_TGT_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.INIORTGT).toString()));
    }

    public EnumDefine.ETH_PORT_DUPLEX_E getEthDuplex() {
        return EnumDefine.ETH_PORT_DUPLEX_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.ETHDUPLEX).toString()));
    }

    public EnumDefine.ETH_PORT_DUPLEX_E getEthNegotiate() {
        return EnumDefine.ETH_PORT_DUPLEX_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ETH_PORT.ETHNEGOTIATE).toString()));
    }

    public long getMTU() {
        return this.mo.getLongProperty(TLV.ETH_PORT.MTU);
    }

    public void setMTU(long mtu) {
        this.mo.setProperty(TLV.ETH_PORT.MTU, new UnsignedInt32(mtu));
    }

    public String getBondName() {
        return this.mo.getStrProperty(TLV.ETH_PORT.BONDNAME);
    }

    public String getIpv4Addr() {
        return this.mo.getStrProperty(TLV.ETH_PORT.IPV4ADDR);
    }

    public String getIpv4Mask() {
        return this.mo.getStrProperty(TLV.ETH_PORT.IPV4MASK);
    }

    public String getIpv4Gateway() {
        return this.mo.getStrProperty(TLV.ETH_PORT.IPV4GATEWAY);
    }

    public String getIpv6Addr() {
        return this.mo.getStrProperty(TLV.ETH_PORT.IPV6ADDR);
    }

    public String getIpv6Mask() {
        return this.mo.getStrProperty(TLV.ETH_PORT.IPV6MASK);
    }

    public String getIpv6Gateway() {
        return this.mo.getStrProperty(TLV.ETH_PORT.IPV6GATEWAY);
    }

    public String getIscsiTcpPort() {
        return this.mo.getStrProperty(TLV.ETH_PORT.ISCSITCPPORT);
    }

    public String getIscsiName() {
        return this.mo.getStrProperty(TLV.ETH_PORT.ISCSINAME);
    }

    public long getErrorPackets() {
        return this.mo.getLongProperty(TLV.ETH_PORT.ERRORPACKETS);
    }

    public long getLostPackets() {
        return this.mo.getLongProperty(TLV.ETH_PORT.LOSTPACKETS);
    }

    public long getOverflowedPackets() {
        return this.mo.getLongProperty(TLV.ETH_PORT.OVERFLOWEDPACKETS);
    }

    public long getStartTime() {
        return this.mo.getLongProperty(TLV.ETH_PORT.STARTTIME);
    }

    public long getSpeed() {
        return this.mo.getLongProperty(TLV.ETH_PORT.SPEED);
    }

    public void setIpv4Addr(String ipv4Addr) {
        this.mo.setProperty(TLV.ETH_PORT.IPV4ADDR, ipv4Addr);
    }

    public void setIpv4Mask(String ipv4Mask) {
        this.mo.setProperty(TLV.ETH_PORT.IPV4MASK, ipv4Mask);
    }

    public void setIpv4Gateway(String ipv4Gateway) {
        this.mo.setProperty(TLV.ETH_PORT.IPV4GATEWAY, ipv4Gateway);
    }

    public void setIpv6Addr(String ipv6Addr) {
        this.mo.setProperty(TLV.ETH_PORT.IPV6ADDR, ipv6Addr);
    }

    public void setIpv6Mask(String ipv6Mask) {
        this.mo.setProperty(TLV.ETH_PORT.IPV6MASK, ipv6Mask);
    }

    public void setIpv6Gateway(String ipv6Gateway) {
        this.mo.setProperty(TLV.ETH_PORT.IPV6GATEWAY, ipv6Gateway);
    }

    public MO getMO() {
        return this.mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    @Override
    public String getCurrentPeerID() {
        return null;
    }

    @Override
    public String getSuggestPeerID() {
        return null;
    }
}

