/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareUtils;

public class ExpBoardMO
extends HardwareInfoAdapter {
    private final MO mo;

    public ExpBoardMO(MO mo) {
        this.mo = mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.EXPBOARD.TYPE).toString()));
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.EXPBOARD.ID);
    }

    public int getExpBoardID() {
        return HardwareUtils.parserID(this.getID());
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.EXPBOARD.NAME);
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.EXPBOARD.PARENTTYPE).toString());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.EXPBOARD.PARENTID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.EXPBOARD.LOCATION);
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.EXPBOARD.HEALTHSTATUS).toString());
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        return EnumDefine.RUNNING_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.EXPBOARD.RUNNINGSTATUS).toString()));
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.EXPBOARD.COUNT);
    }

    public EnumDefine.EXPBOARD_TYPE_E getModel() {
        return EnumDefine.EXPBOARD_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.EXPBOARD.MODEL).toString()));
    }

    public String getLogicVer() {
        return this.mo.getStrProperty(TLV.EXPBOARD.LOGICVER);
    }

    public String getPcbVer() {
        return this.mo.getStrProperty(TLV.EXPBOARD.PCBVER);
    }

    public String getSesVer() {
        return this.mo.getStrProperty(TLV.EXPBOARD.SESVER);
    }

    public String getElabel() {
        return this.mo.getStrProperty(TLV.EXPBOARD.ELABEL);
    }

    public String getMOName() {
        return ResourceManager.getString("EXPANDERMODULEPANE_EXPANDERMODULE") + " " + this.getName();
    }
}

