/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareUtils;

public class PowerMO
extends HardwareInfoAdapter {
    private final MO mo;

    public PowerMO(MO mo) {
        this.mo = mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.POWER.TYPE).toString()));
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.POWER.TYPE, type.getValue());
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.POWER.ID);
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.POWER.ID, id);
    }

    public int getSlotID() {
        return HardwareUtils.parserID(this.getID());
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.POWER.NAME);
    }

    public void setName(String name) {
        this.mo.setProperty(TLV.POWER.NAME, name);
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.POWER.PARENTTYPE).toString());
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.POWER.PARENTTYPE, parentType.getValue());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.POWER.PARENTID);
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.POWER.PARENTID, parentID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.POWER.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.POWER.LOCATION, location);
    }

    @Override
    public int getHealthStatus() {
        return this.mo.getIntProperty(TLV.POWER.HEALTHSTATUS);
    }

    public void setHealthStatus(EnumDefine.HEALTH_STATUS_E healthStatus) {
        this.mo.setProperty(TLV.POWER.HEALTHSTATUS, healthStatus.getValue());
    }

    public int getRunningStatus() {
        return this.mo.getIntProperty(TLV.POWER.RUNNINGSTATUS);
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E runningStatus) {
        this.mo.setProperty(TLV.POWER.RUNNINGSTATUS, runningStatus.getValue());
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.POWER.COUNT);
    }

    public long getTemperature() {
        return this.mo.getLongProperty(TLV.POWER.TEMPERATURE);
    }

    public EnumDefine.POWER_TYPE_E getPowerType() {
        return EnumDefine.POWER_TYPE_E.valueOf(this.mo.getIntProperty(TLV.POWER.POWERTYPE));
    }

    public long getInputVoltage() {
        return this.mo.getLongProperty(TLV.POWER.INPUTVOLTAGE);
    }

    public long getOutputVoltage() {
        return this.mo.getLongProperty(TLV.POWER.OUTPUTVOLTAGE);
    }

    public String getManufacturer() {
        return this.mo.getStrProperty(TLV.POWER.MANUFACTURER);
    }

    @Override
    public String getModel() {
        return this.mo.getStrProperty(TLV.POWER.MODEL);
    }

    public String getVersion() {
        return this.mo.getStrProperty(TLV.POWER.VERSION);
    }

    public String getProduceDate() {
        return this.mo.getStrProperty(TLV.POWER.PRODUCEDATE);
    }

    public String getSerialNumber() {
        return this.mo.getStrProperty(TLV.POWER.SERIALNUMBER);
    }
}

