/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;

public class SerialPortMO
extends HardwareInfoAdapter {
    private final MO mo;

    public SerialPortMO(MO mo) {
        this.mo = mo;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        Object moObjet = this.mo.getProperty(TLV.SERIAL_PORT.TYPE);
        if (null == moObjet) {
            return null;
        }
        Integer value = Integer.parseInt(moObjet.toString());
        return MOType.getType(value);
    }

    public int getSlotID() {
        return (int)(Long.valueOf(this.getID()) & 0xFFL);
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.SERIAL_PORT.TYPE, type.getValue());
    }

    public Param getTypeParam() {
        MOType type = this.getType();
        if (type == null) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.TYPE.getParamIndex(), TLV.SERIAL_PORT.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(type.getValue()));
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.SERIAL_PORT.ID);
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.SERIAL_PORT.ID, id);
    }

    public Param getIDParam() {
        if (this.getID() == null) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.ID.getParamIndex(), TLV.SERIAL_PORT.ID.getParamType(), this.getID());
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.SERIAL_PORT.NAME);
    }

    public void setName(String name) {
        this.mo.setProperty(TLV.SERIAL_PORT.NAME, name);
    }

    public Param getNameParam() {
        if (this.getName() == null) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.NAME.getParamIndex(), TLV.SERIAL_PORT.NAME.getParamType(), this.getName());
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.SERIAL_PORT.PARENTTYPE).toString());
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.SERIAL_PORT.PARENTTYPE, parentType.getValue());
    }

    public Param getParentTypeParam() {
        if (this.getParentType() == -1) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.PARENTTYPE.getParamIndex(), TLV.SERIAL_PORT.PARENTTYPE.getParamType(), (IsmInteger)new UnsignedInt32(this.getParentType()));
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.SERIAL_PORT.PARENTID);
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.SERIAL_PORT.PARENTID, parentID);
    }

    public Param getParentIDParam() {
        if (this.getParentID() == null) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.PARENTID.getParamIndex(), TLV.SERIAL_PORT.PARENTID.getParamType(), this.getParentID());
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.SERIAL_PORT.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.SERIAL_PORT.LOCATION, location);
    }

    @Override
    public int getHealthStatus() {
        Object moObject = this.mo.getProperty(TLV.SERIAL_PORT.HEALTHSTATUS);
        if (null == moObject) {
            return -1;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return value;
    }

    public void setHealthStatus(EnumDefine.HEALTH_STATUS_E healthStatus) {
        this.mo.setProperty(TLV.SERIAL_PORT.HEALTHSTATUS, healthStatus.getValue());
    }

    public Param getHealthStatusParam() {
        if (this.getHealthStatus() == -1) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.HEALTHSTATUS.getParamIndex(), TLV.SERIAL_PORT.HEALTHSTATUS.getParamType(), (IsmInteger)new UnsignedInt32(this.getHealthStatus()));
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        Object moObject = this.mo.getProperty(TLV.SERIAL_PORT.RUNNINGSTATUS);
        if (null == moObject) {
            return null;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return EnumDefine.RUNNING_STATUS_E.valueOf(value);
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E runningStatus) {
        this.mo.setProperty(TLV.SERIAL_PORT.RUNNINGSTATUS, runningStatus.getValue());
    }

    public Param getRunningStatusParam() {
        EnumDefine.RUNNING_STATUS_E status = this.getRunningStatus();
        if (status == null) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.RUNNINGSTATUS.getParamIndex(), TLV.SERIAL_PORT.RUNNINGSTATUS.getParamType(), (IsmInteger)new UnsignedInt32(status.getValue()));
    }

    public EnumDefine.PORT_LOGIC_TYPE_E getLogicType() {
        Object moObject = this.mo.getProperty(TLV.SERIAL_PORT.LOGICTYPE);
        if (null == moObject) {
            return null;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return EnumDefine.PORT_LOGIC_TYPE_E.valueOf(value);
    }

    public void setLogicType(EnumDefine.PORT_LOGIC_TYPE_E logicType) {
        this.mo.setProperty(TLV.SERIAL_PORT.LOGICTYPE, logicType.getValue());
    }

    public Param getLogicTypeParam() {
        EnumDefine.PORT_LOGIC_TYPE_E type = this.getLogicType();
        if (type == null) {
            return null;
        }
        return new Param(TLV.SERIAL_PORT.LOGICTYPE.getParamIndex(), TLV.SERIAL_PORT.LOGICTYPE.getParamType(), (IsmInteger)new UnsignedInt32(type.getValue()));
    }

    public String getMOName() {
        return ResourceManager.getString("FIGURELEGENDPANEL_SERIALPORT") + this.getName();
    }

    @Override
    public boolean isNormal() {
        return true;
    }
}

