/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.login;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutDialog
extends IsmDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutDialog.class);
    private JButton cancelButton;
    private JButton confirmButton;
    private JCheckBox saveDeviceInfoCbx = new JCheckBox();
    private int choice = Integer.MAX_VALUE;

    public LogoutDialog(Frame parentDialog) {
        super((Window)parentDialog);
        this.setName("ISMV1R2_framework_login_LogoutDialog");
        this.init();
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.cancelButton.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    private void init() {
        this.confirmButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CONFIRM"), 'O');
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogoutDialog.this.confirmButtonMouseClicked(actionEvent);
            }
        });
        this.cancelButton = UCD.createButton(ResourceManager.getString("CANCEL"), 'C');
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogoutDialog.this.cancelButtonMouseClicked(actionEvent);
            }
        });
        JComponent buttonBox = UCD.buildButtonBox(new JButton[][]{{this.confirmButton, this.cancelButton}});
        this.getSouthBox().add(buttonBox);
        this.getSouthBox().add(Box.createHorizontalGlue());
        IsmTextArea textArea = UCD.createTextArea(ResourceManager.getString("LOGOUT_ACTION_LOGOUT_WARNING_STRING"));
        textArea.setColumns(30);
        textArea.setRows(4);
        JPanel descPane = new JPanel(new BorderLayout());
        descPane.add((Component)textArea, "Center");
        descPane.add((Component)this.getSaveDeviceInfoArea(), "South");
        descPane.setBorder(new EmptyBorder(12, 20, 12, 12));
        this.addContentPane(descPane);
        this.setTitle(ResourceManager.getString("LOGOUT_DIALOG_TITLE"));
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        SwingUtil.putScreenCenter(this);
    }

    public int getValue() {
        return this.choice;
    }

    private Box getSaveDeviceInfoArea() {
        this.saveDeviceInfoCbx.setText(ResourceManager.getString("LOGOUT_ACTION_SAVE_DEVICE_INFO"));
        this.saveDeviceInfoCbx.setOpaque(false);
        Box box = Box.createHorizontalBox();
        box.add(this.saveDeviceInfoCbx);
        box.add(Box.createHorizontalGlue());
        if (LauncherManager.getInstance().getDeviceSize() == 0) {
            this.saveDeviceInfoCbx.setSelected(false);
            this.saveDeviceInfoCbx.setEnabled(false);
        } else {
            this.saveDeviceInfoCbx.setSelected(true);
            this.saveDeviceInfoCbx.setEnabled(true);
        }
        return box;
    }

    public boolean isSavingDeviceInfo() {
        return this.saveDeviceInfoCbx.isSelected();
    }

    protected void cancelButtonMouseClicked(ActionEvent evt) {
        this.choice = 1;
        this.dispose();
    }

    protected void confirmButtonMouseClicked(ActionEvent evt) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("confirm button clicked. choice is " + this.choice);
        }
        this.choice = 0;
        this.dispose();
    }
}

