/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.exception.BatchExecutionException;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.message.IMsgHandler;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.event.EventFilter;
import com.huawei.ism.ui.module.event.EventManagerFrame;
import com.huawei.ism.ui.module.event.EventManagerListener;
import com.huawei.ism.ui.module.event.EventProcessor;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManager.class);
    private static EventManager instance;
    private List<EventManagerListener> listeners = new ArrayList<EventManagerListener>(0);
    private Map<String, EventProcessor> processorMap;
    private Map<Event.Identifier, Event> recoveredEvent = new ConcurrentHashMap<Event.Identifier, Event>();
    private EventCache cache = new EventCache();
    private IndicationEventCache collector = new IndicationEventCache();
    private EventManagerFrame frame;
    private final ReentrantReadWriteLock rwl;
    private final Lock readLock;
    private final Lock writeLock;
    private boolean isNeedUpdate = true;

    private EventManager() {
        this.processorMap = new HashMap<String, EventProcessor>(0);
        this.rwl = new ReentrantReadWriteLock();
        this.readLock = this.rwl.readLock();
        this.writeLock = this.rwl.writeLock();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleWithFixedDelay(new TimingNotifyUITask(), 10L, 10L, TimeUnit.SECONDS);
        IsmMsgManager.getInstance().registerIsmMsgHandle("MSG_TYPE_EVENT_RECEIVE", new EventIMsHandler());
    }

    public void refreshFaultEvents(String ... deviceIDs) throws BatchExecutionException {
        if (null == deviceIDs || deviceIDs.length == 0) {
            return;
        }
        ArrayList<EventProcessor> list = new ArrayList<EventProcessor>(0);
        EventProcessor proxy = null;
        for (String deviceID : deviceIDs) {
            proxy = this.processorMap.get(deviceID);
            if (null == proxy) continue;
            list.add(proxy);
        }
        this.refreshFaultEvents(list.toArray(new EventProcessor[list.size()]));
    }

    public void refreshAllEvents(String deviceID) throws IsmException {
        if (null == deviceID) {
            return;
        }
        EventProcessor proxy = this.processorMap.get(deviceID);
        final List<Event> allEvents = proxy.queryAllEvents();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ArrayList handlers = new ArrayList(EventManager.this.listeners);
                for (EventManagerListener listener : handlers) {
                    listener.fireEventsAdded(allEvents);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public void refreshAllDevicesEvents(List<String> deviceIDs) throws IsmException {
        if (Utils.isNullList(deviceIDs)) {
            return;
        }
        ArrayList<Event> allEvents = new ArrayList<Event>(0);
        EventProcessor proxy = null;
        for (String deviceID : deviceIDs) {
            proxy = this.processorMap.get(deviceID);
            if (null == proxy) continue;
            allEvents.addAll(proxy.queryAllEvents());
        }
        final ArrayList<Event> allDeviceEvents = allEvents;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ArrayList handlers = new ArrayList(EventManager.this.listeners);
                for (EventManagerListener listener : handlers) {
                    listener.fireEventsAdded(allDeviceEvents);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public void removeEvents(String deviceID) {
        EventProcessor proxy = this.processorMap.get(deviceID);
        if (null != proxy) {
            this.removeEventProcessor(proxy);
        }
    }

    public List<String> getSourceIDs() {
        return new ArrayList<String>(this.processorMap.keySet());
    }

    public synchronized void addEventProcessor(final EventProcessor processor) throws BatchExecutionException {
        if (null != processor && !this.processorMap.containsKey(processor.getDeviceID())) {
            this.processorMap.put(processor.getDeviceID(), processor);
            this.refreshFaultEvents(processor);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ArrayList handlers = new ArrayList(EventManager.this.listeners);
                    for (EventManagerListener listener : handlers) {
                        listener.fireSourceAdded(processor.getDeviceID());
                    }
                }
            };
            SwingUtil.runInEventDispatchThread(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventProcessor(EventProcessor processor) {
        if (null == processor || !this.processorMap.containsKey(processor.getDeviceID())) {
            return;
        }
        this.processorMap.remove(processor.getDeviceID());
        LinkedList<Event> removedEvents = new LinkedList<Event>();
        try {
            this.writeLock.lock();
            EventFilter filter = EventFilter.createDeviceFilter(processor.getDeviceID());
            removedEvents.addAll(this.cache.removeEvents(filter));
            this.collector.removeEvents((List<Event>)removedEvents);
        }
        finally {
            this.writeLock.unlock();
        }
        SwingUtil.runInEventDispatchThread(new RemoveEventTask(processor, removedEvents));
    }

    public void showFrame() {
        this.showFrame(null, null);
    }

    public void showFrame(final Event.Level level, final String deviceID) {
        if (null == this.frame || !this.frame.isWindowValid()) {
            this.frame = new EventManagerFrame(Framework.getInstance().getMainFrame());
            AsyncExcutor.execute(new Callable(){

                public Object call() throws Exception {
                    EventManager.this.frame.synWithEventCache();
                    EventManager.this.frame.setFilter(level, deviceID);
                    return null;
                }
            });
        }
        SwingUtil.putScreenCenter(this.frame);
        this.frame.sortTime();
        this.frame.setVisible(true);
    }

    public static synchronized EventManager getInstance() {
        if (null == instance) {
            instance = new EventManager();
        }
        return instance;
    }

    public List<Event> getEvents(EventFilter filter) {
        try {
            this.readLock.lock();
            List<Event> list = this.cache.getEvents(filter);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Event> getFaultEvents(EventFilter filter) {
        try {
            this.readLock.lock();
            List<Event> list = this.cache.getFaultEvents(filter);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Event> getAllEvents() {
        try {
            this.readLock.lock();
            List<Event> list = this.cache.getAllEvents();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Event> getAllFaults() {
        try {
            this.readLock.lock();
            List<Event> list = this.cache.getAllFaults();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFaultEvents(EventProcessor ... proxies) throws BatchExecutionException {
        if (null == proxies || 0 == proxies.length) {
            return;
        }
        LinkedList<Event> events = new LinkedList<Event>();
        LinkedList<EventProcessor> proxyList = new LinkedList<EventProcessor>();
        ArrayList<String> failedDeviceIDs = new ArrayList<String>(0);
        BatchExecutionException exception = new BatchExecutionException();
        proxyList.addAll(Arrays.asList(proxies));
        ArrayList<Event> eventsToRemoved = new ArrayList<Event>(0);
        ArrayList<Event> recoveredEvents = new ArrayList<Event>(0);
        try {
            this.recordAndRefresh(events, proxyList, failedDeviceIDs, exception, eventsToRemoved, recoveredEvents);
        }
        finally {
            this.isNeedUpdate = true;
        }
        this.callbackRefresh(events, eventsToRemoved, recoveredEvents);
        if (!failedDeviceIDs.isEmpty()) {
            throw exception;
        }
    }

    private void callbackRefresh(final List<Event> events, final List<Event> eventsToRemoved, final Collection<Event> recoveredEvents) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                List<Event> notifyEvents = EventManager.this.cache.getAllNofityFaultEvents();
                EventManager.this.saveNotifyEvents(notifyEvents.toArray(new Event[notifyEvents.size()]));
                EventManager.this.cache.clearNofifyFaultEvents();
                ArrayList handlers = new ArrayList(EventManager.this.listeners);
                for (EventManagerListener listener : handlers) {
                    listener.fireFaultEventUpdated(recoveredEvents);
                    listener.fireFaultEventRemoved(eventsToRemoved);
                    listener.fireFaultEventsAdded(events);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAndRefresh(List<Event> events, List<EventProcessor> proxyList, List<String> failedDeviceIDs, BatchExecutionException exception, List<Event> eventsToRemoved, Collection<Event> recoveredEvents) {
        this.isNeedUpdate = false;
        for (EventProcessor handleProxy : proxyList) {
            try {
                events.addAll(handleProxy.queryAllFaultEvents());
            }
            catch (IsmException ex) {
                failedDeviceIDs.add(handleProxy.getDeviceID());
                ex.setOperationObject(handleProxy.getDeviceID());
                exception.addFail(ex);
                LOGGER.error("refreshEvents.error: ", (Throwable)ex);
            }
        }
        try {
            this.doRefresh(events, proxyList, failedDeviceIDs, eventsToRemoved, recoveredEvents);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void doRefresh(List<Event> events, List<EventProcessor> proxyList, List<String> failedDeviceIDs, List<Event> eventsToRemoved, Collection<Event> recoveredEvents) {
        this.writeLock.lock();
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>(0);
        String deviceID = null;
        for (EventProcessor eventProcessor : proxyList) {
            deviceID = eventProcessor.getDeviceID();
            if (failedDeviceIDs.contains(deviceID)) continue;
            filters.add(EventFilter.createDeviceFilter(deviceID));
        }
        this.resetRecoveredMap(events);
        Set<Event.Identifier> indicationRecoveredEvents = this.collector.getExistedEvents();
        for (Event.Identifier identifier : indicationRecoveredEvents) {
            if (!this.cache.getEventFast(identifier).isRecovered()) continue;
            recoveredEvents.add(this.cache.getEventFast(identifier));
        }
        EventFilter eventFilter = EventFilter.orFilter(filters.toArray(new EventFilter[filters.size()]));
        eventsToRemoved.addAll(this.cache.removeEvents(eventFilter));
        this.collector.removeEvents(eventsToRemoved);
        this.resetEventsRecoverdTime(events);
        this.cache.saveEvents(events);
    }

    private void resetRecoveredMap(Collection<Event> events) {
        if (null == events || events.isEmpty()) {
            return;
        }
        Collection<Event> recoverEvents = this.recoveredEvent.values();
        ArrayList<Event.Identifier> removeIds = new ArrayList<Event.Identifier>(0);
        for (Event recoverEvent : recoverEvents) {
            if (events.contains(recoverEvent)) continue;
            removeIds.add(recoverEvent.getIdentifier());
        }
        for (Event.Identifier id : removeIds) {
            this.recoveredEvent.remove(id);
        }
    }

    public void manualRecover(final List<Event> events, Map<Event.Identifier, Long> failedMap) throws IsmException {
        HashMap eventMap = new HashMap(0);
        final HashMap<Event.Identifier, Long> failInfo = new HashMap<Event.Identifier, Long>(0);
        String deviceID = null;
        Launcher launcher = null;
        User currentUser = null;
        for (Event event : events) {
            deviceID = event.getIdentifier().getDeviceID();
            launcher = LauncherManager.getInstance().getLauncher(deviceID);
            currentUser = launcher.getDeviceContext().getCurrentUser();
            if (currentUser.getLevel().getValue() > User.Level.Admin.getValue()) {
                failInfo.put(event.getIdentifier(), 16806407L);
                continue;
            }
            if (!eventMap.containsKey(deviceID)) {
                eventMap.put(deviceID, new ArrayList(0));
            }
            ((List)eventMap.get(deviceID)).add(event);
        }
        this.isNeedUpdate = false;
        Set entries = eventMap.entrySet();
        List deviceEvents = null;
        EventProcessor proxy = null;
        Map<Event.Identifier, Long> fail = null;
        for (Map.Entry entry : entries) {
            deviceID = (String)entry.getKey();
            deviceEvents = (List)entry.getValue();
            proxy = this.processorMap.get(deviceID);
            if (null == proxy || null == (fail = proxy.clearFaultEvents(deviceEvents))) continue;
            failInfo.putAll(fail);
        }
        this.isNeedUpdate = true;
        failedMap.putAll(failInfo);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ArrayList handlers = new ArrayList(EventManager.this.listeners);
                for (EventManagerListener listener : handlers) {
                    listener.fireFaultCleared(events, failInfo);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public void updateEvents(Event ... events) {
        if (!this.isNeedUpdate) {
            this.cache.addNotifyFaultEvents(events);
            return;
        }
        this.saveNotifyEvents(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNotifyEvents(Event ... events) {
        LinkedList<Event> newEvents = new LinkedList<Event>();
        LinkedList<Event> existEvents = new LinkedList<Event>();
        for (Event event : events) {
            this.resetEventRecoveredTime(event);
            if (this.cache.contains(event)) {
                existEvents.add(event);
                continue;
            }
            newEvents.add(event);
        }
        try {
            this.writeLock.lock();
            this.cache.saveEvents(Arrays.asList(events));
            this.collector.saveNewEvents(newEvents.toArray(new Event[newEvents.size()]));
            this.collector.saveExistedEvents(existEvents.toArray(new Event[existEvents.size()]));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void resetEventsRecoverdTime(Collection<Event> events) {
        for (Event event : events) {
            this.resetEventRecoveredTime(event);
        }
    }

    private void resetEventRecoveredTime(Event event) {
        if (event.isRecovered()) {
            this.recoveredEvent.put(event.getIdentifier(), event);
        } else if (this.recoveredEvent.containsKey(event.getIdentifier())) {
            event.setRecoverTime(this.recoveredEvent.get(event.getIdentifier()).getRecoverTime());
        }
    }

    public void saveAllEvents(String deviceID, String filePath) throws IsmException {
        EventProcessor eventProxy = this.processorMap.get(deviceID);
        eventProxy.saveAllEvents(deviceID, filePath);
    }

    public int getEventCount(EventFilter eventFilter) {
        try {
            this.readLock.lock();
            int n = this.cache.getEventCount(eventFilter);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getFaultCount(EventFilter eventFilter) {
        try {
            this.readLock.lock();
            int n = this.cache.getFaultCount(eventFilter);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addEventManagerListenerWithCheckDup(EventManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addEventManagerListener(EventManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventManagerListener(EventManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void removeEventsFromCache(final Collection<Event> events) {
        try {
            this.writeLock.lock();
            this.cache.removeEvents(events);
            this.collector.removeEvents(events);
        }
        finally {
            this.writeLock.unlock();
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (null != EventManager.this.frame) {
                    EventManager.this.frame.fireFaultEventRemoved(events);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public long getEventTime(Event event, boolean isStart) {
        Launcher launcher = CommonUtil.getLauncher(event.getIdentifier().getDeviceID());
        long timeLong = 0L;
        timeLong = isStart ? event.getStartTime() : event.getRecoverTime();
        if (null != launcher && launcher.getDeviceContext().getDeviceType() == DeviceType.C3) {
            timeLong *= 1000L;
        }
        return timeLong;
    }

    private class EventCache {
        private Map<Event.Identifier, Event> eventPool = new HashMap<Event.Identifier, Event>(0);
        private Map<Event.Identifier, Event> faultPool = new HashMap<Event.Identifier, Event>(0);
        private Map<Event.Identifier, Event> notifyFaultPool = new HashMap<Event.Identifier, Event>(0);

        private EventCache() {
        }

        public void addNotifyFaultEvents(Event ... events) {
            for (Event event : events) {
                this.notifyFaultPool.put(event.getIdentifier(), event);
            }
        }

        public List<Event> getAllNofityFaultEvents() {
            return new ArrayList<Event>(this.notifyFaultPool.values());
        }

        public void clearNofifyFaultEvents() {
            this.notifyFaultPool.clear();
        }

        public boolean contains(Event event) {
            return this.eventPool.containsValue(event);
        }

        public Event getEventFast(Event.Identifier identifier) {
            return this.eventPool.get(identifier);
        }

        public List<Event> getAllEvents() {
            LOGGER.info("Get all events");
            return new ArrayList<Event>(this.eventPool.values());
        }

        public List<Event> getAllFaults() {
            LOGGER.info("Get all events");
            return new ArrayList<Event>(this.faultPool.values());
        }

        public List<Event> getEvents(EventFilter filter) {
            LOGGER.info("Get all events with filter");
            ArrayList<Event> events = new ArrayList<Event>(0);
            events.addAll(this.eventPool.values());
            if (null != filter) {
                Iterator iterator = events.iterator();
                Event event = null;
                while (iterator.hasNext()) {
                    event = (Event)iterator.next();
                    if (filter.include(event)) continue;
                    iterator.remove();
                }
            }
            return events;
        }

        public List<Event> getFaultEvents(EventFilter filter) {
            ArrayList<Event> events = new ArrayList<Event>(0);
            events.addAll(this.faultPool.values());
            if (null != filter) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Get all fault events with filter" + filter);
                }
                Event event = null;
                Iterator iterator = events.iterator();
                while (iterator.hasNext()) {
                    event = (Event)iterator.next();
                    if (filter.include(event)) continue;
                    iterator.remove();
                }
            }
            return events;
        }

        public void saveEvents(Collection<Event> events) {
            for (Event event : events) {
                this.eventPool.put(event.getIdentifier(), event);
            }
            for (Event event : events) {
                if (!event.getLevel().isFault()) continue;
                this.faultPool.put(event.getIdentifier(), event);
                if (!event.isRecovered()) continue;
                this.faultPool.remove(event.getIdentifier());
            }
        }

        public void removeEvents(Collection<Event> events) {
            LOGGER.info("Remove events from cache");
            for (Event event : events) {
                this.eventPool.remove(event.getIdentifier());
                this.faultPool.remove(event.getIdentifier());
            }
        }

        public void clear(EventFilter filter) {
            this.eventPool.clear();
            this.faultPool.clear();
        }

        public List<Event> removeEvents(EventFilter filter) {
            LinkedList<Event> removedEvents = new LinkedList<Event>();
            if (null != filter) {
                this.degradeDepth(removedEvents, filter);
            }
            return removedEvents;
        }

        private void degradeDepth(List<Event> removedEvents, EventFilter filter) {
            HashMap<Event.Identifier, Event> events = new HashMap<Event.Identifier, Event>(this.eventPool);
            Set entrySets = events.entrySet();
            Event.Identifier key = null;
            Event event = null;
            for (Map.Entry entry : entrySets) {
                key = (Event.Identifier)entry.getKey();
                event = (Event)events.get(key);
                if (null == filter || !filter.include(event)) continue;
                this.eventPool.remove(key);
                removedEvents.add(event);
            }
            for (Event even : removedEvents) {
                this.faultPool.remove(even.getIdentifier());
            }
        }

        public int getEventCount(EventFilter filter) {
            return this.getEvents(filter).size();
        }

        public int getFaultCount(EventFilter filter) {
            ArrayList<Event> faults = new ArrayList<Event>(this.faultPool.values());
            int count = 0;
            if (null == filter) {
                return 0;
            }
            for (Event fault : faults) {
                if (!filter.include(fault)) continue;
                ++count;
            }
            return count;
        }
    }

    private final class RemoveEventTask
    implements Runnable {
        private final EventProcessor processor;
        private final List<Event> events;

        private RemoveEventTask(EventProcessor processor, List<Event> events) {
            this.processor = processor;
            this.events = events;
        }

        @Override
        public void run() {
            ArrayList handlers = new ArrayList(EventManager.this.listeners);
            for (EventManagerListener listener : handlers) {
                listener.fireSourceRemoved(this.processor.getDeviceID());
                listener.fireFaultEventRemoved(this.events);
            }
        }
    }

    private final class NotifyFreshRunnable
    implements Runnable {
        private List<Event> newEvents = new ArrayList<Event>(0);
        private List<Event> existedEvents = new ArrayList<Event>(0);

        public NotifyFreshRunnable(List<Event> newEvents, List<Event> existedEvents) {
            this.existedEvents = existedEvents;
            this.newEvents = newEvents;
        }

        @Override
        public void run() {
            ArrayList handler = new ArrayList(EventManager.this.listeners);
            for (EventManagerListener listener : handler) {
                listener.fireFaultEventUpdated(this.existedEvents);
                listener.fireFaultEventsAdded(this.newEvents);
            }
        }
    }

    private final class TimingNotifyUITask
    implements Runnable {
        private TimingNotifyUITask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("Timing Notify Events Thread ");
            ArrayList<Event> newEvents = new ArrayList<Event>(0);
            ArrayList<Event> existedEvents = new ArrayList<Event>(0);
            try {
                EventManager.this.writeLock.lock();
                for (Event.Identifier identifier : EventManager.this.collector.getNewEvents()) {
                    newEvents.add(EventManager.this.cache.getEventFast(identifier));
                }
                for (Event.Identifier identifier : EventManager.this.collector.getExistedEvents()) {
                    existedEvents.add(EventManager.this.cache.getEventFast(identifier));
                }
                EventManager.this.collector.clear();
                if (newEvents.isEmpty() && existedEvents.isEmpty()) {
                    return;
                }
            }
            finally {
                EventManager.this.writeLock.unlock();
            }
            SwingUtil.runInEventDispatchThread(new NotifyFreshRunnable(newEvents, existedEvents));
        }
    }

    private static final class IndicationEventCache {
        private Set<Event.Identifier> newEvents = new HashSet<Event.Identifier>(0);
        private Set<Event.Identifier> existedEvents = new HashSet<Event.Identifier>(0);

        private IndicationEventCache() {
        }

        public Set<Event.Identifier> getNewEvents() {
            return new HashSet<Event.Identifier>(this.newEvents);
        }

        public Set<Event.Identifier> getExistedEvents() {
            return new HashSet<Event.Identifier>(this.existedEvents);
        }

        public void saveNewEvents(Event ... events) {
            for (Event event : events) {
                this.newEvents.remove(event.getIdentifier());
                this.newEvents.add(event.getIdentifier());
            }
        }

        public void saveExistedEvents(Event ... events) {
            for (Event event : events) {
                this.existedEvents.remove(event.getIdentifier());
                this.existedEvents.add(event.getIdentifier());
            }
        }

        public void clear() {
            this.existedEvents.clear();
            this.newEvents.clear();
        }

        public void removeEvents(List<Event> events) {
            for (Event event : events) {
                this.existedEvents.remove(event.getIdentifier());
                this.newEvents.remove(event.getIdentifier());
            }
        }

        public void removeEvents(Collection<Event> events) {
            for (Event event : events) {
                this.existedEvents.remove(event.getIdentifier());
                this.newEvents.remove(event.getIdentifier());
            }
        }
    }

    class EventIMsHandler
    implements IMsgHandler {
        EventIMsHandler() {
        }

        @Override
        public void handleMsg(IsmMsg ismMsg) {
            Event event = (Event)ismMsg.getProperty("PROPERTY_EVENT");
            EventManager.this.updateEvents(event);
        }
    }
}

