/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.event.EventBuzzHandle;
import com.huawei.ism.ui.module.event.EventFilter;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.event.EventManagerFrame;
import com.huawei.ism.ui.module.event.EventManagerListener;
import com.huawei.ism.ui.module.event.EventProcessor;
import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorBorders;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStatPane
extends JPanel
implements EventManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventStatPane.class);
    private static final long serialVersionUID = -6794646367327403784L;
    private EventStatLayout layout = new EventStatLayout();
    private List<String> deviceIDList = new ArrayList<String>(0);
    private boolean countAll = true;

    public EventStatPane() {
        this.doUILayout();
        this.addHandler();
        SwingUtil.setName(this);
        EventManager.getInstance().addEventManagerListener(this);
        this.reCountEvents();
    }

    @Override
    public void fireSourceRemoved(String ... deviceIDs) {
        if (this.countAll) {
            this.countAllEvents();
        } else {
            boolean reCount = false;
            for (String deviceID : deviceIDs) {
                if (!this.deviceIDList.contains(deviceID)) continue;
                reCount = true;
                break;
            }
            if (reCount) {
                this.reCountEvents();
            }
        }
    }

    @Override
    public void fireSourceAdded(String ... sourceIDs) {
        if (this.countAll) {
            this.countAllEvents();
        }
    }

    @Override
    public void fireFaultEventsAdded(Collection<Event> events) {
        this.reCountEvents();
    }

    @Override
    public void fireFaultEventRemoved(Collection<Event> events) {
        this.reCountEvents();
    }

    @Override
    public void fireFaultEventUpdated(Collection<Event> events) {
        this.reCountEvents();
    }

    @Override
    public void fireFaultCleared(Collection<Event> events, Map<Event.Identifier, Long> failedMap) {
        this.reCountEvents();
    }

    @Override
    public void fireEventsAdded(List<Event> events) {
    }

    private void doUILayout() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
    }

    protected void addHandler() {
        Map<Event.Level, ToolBarButton> buttonMap = this.layout.getButtonMap();
        ToolBarButton levelButton = null;
        Event.Level level = null;
        for (Map.Entry<Event.Level, ToolBarButton> entry : buttonMap.entrySet()) {
            level = entry.getKey();
            levelButton = entry.getValue();
            this.ddd(levelButton, level);
        }
    }

    private void ddd(ToolBarButton levelButton, final Event.Level level) {
        levelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EventManagerFrame.showFrame(level, EventStatPane.this.getDeviceID());
            }
        });
    }

    public void countAllEvents() {
        if (!this.countAll) {
            this.countAll = true;
            this.deviceIDList.clear();
            EventStatWorker work = new EventStatWorker();
            work.execute();
        }
    }

    public void countEvents(String device) {
        this.deviceIDList.clear();
        if (!this.deviceIDList.contains(device) || this.countAll) {
            this.deviceIDList.add(device);
            this.reCountEvents();
        }
        this.countAll = false;
    }

    public void countEvents(Collection<String> devices) {
        this.countAll = false;
        this.deviceIDList.clear();
        this.deviceIDList.addAll(devices);
        this.reCountEvents();
    }

    public void reCountEvents() {
        EventStatWorker work = new EventStatWorker();
        work.execute();
    }

    protected String getDeviceID() {
        String deviceID = null;
        Launcher launcher = LauncherManager.getInstance().getActivedLauncher();
        if (null != launcher) {
            deviceID = launcher.getDeviceID();
        }
        return deviceID;
    }

    protected Map<Event.Level, ToolBarButton> getButtons() {
        return this.layout.getButtonMap();
    }

    private Map<Event.Level, Integer> countFaultByLevel() {
        int criticalCount = 0;
        int majorCount = 0;
        int warningCount = 0;
        EventFilter criticalFilter = EventFilter.createLevelFilter(Event.Level.CRITICAL);
        EventFilter majorFilter = EventFilter.createLevelFilter(Event.Level.MAJOR);
        EventFilter warningFilter = EventFilter.createLevelFilter(Event.Level.WARNING);
        Collection<String> deviceIDs = this.getDeviceListForCounting();
        EventFilter deviceFilter = null;
        for (String deviceID : deviceIDs) {
            deviceFilter = EventFilter.createDeviceFilter(deviceID);
            criticalCount += EventManager.getInstance().getFaultCount(EventFilter.andFilter(deviceFilter, criticalFilter));
            majorCount += EventManager.getInstance().getFaultCount(EventFilter.andFilter(deviceFilter, majorFilter));
            warningCount += EventManager.getInstance().getFaultCount(EventFilter.andFilter(deviceFilter, warningFilter));
        }
        HashMap<Event.Level, Integer> map = new HashMap<Event.Level, Integer>(0);
        map.put(Event.Level.CRITICAL, criticalCount);
        map.put(Event.Level.MAJOR, majorCount);
        map.put(Event.Level.WARNING, warningCount);
        return map;
    }

    public boolean shouldBuzz(Map<Event.Level, Integer> eventCountResultMap) {
        EventBuzzHandle buzz = EventBuzzHandle.getInstance();
        int criticalCount = eventCountResultMap.get((Object)Event.Level.CRITICAL);
        int majorCount = eventCountResultMap.get((Object)Event.Level.MAJOR);
        int warningCount = eventCountResultMap.get((Object)Event.Level.WARNING);
        int cnt = 0;
        switch (buzz.getLevel()) {
            case -1: 
            case 3: {
                cnt = criticalCount + majorCount + warningCount;
                break;
            }
            case 5: {
                cnt = criticalCount + majorCount;
                break;
            }
            case 6: {
                cnt = criticalCount;
                break;
            }
        }
        return cnt > 0;
    }

    private Collection<String> getDeviceListForCounting() {
        IsmTreeNode selectNode = Framework.getInstance().getSelectionNode();
        HashSet<String> deviceIDs = new HashSet<String>(0);
        ArrayList<Launcher> launchers = new ArrayList<Launcher>(0);
        if (null == selectNode || null == selectNode.getDeviceID()) {
            launchers.addAll(LauncherManager.getInstance().getAllLauncher());
        } else {
            launchers.add(LauncherManager.getInstance().findDeviceOwner(selectNode.getDeviceID()));
        }
        for (Launcher launcher : launchers) {
            if (null == launcher) continue;
            for (EventProcessor processor : launcher.getEventProcessor()) {
                if (null == processor) continue;
                deviceIDs.add(processor.getDeviceID());
            }
        }
        return deviceIDs;
    }

    class EventStatWorker
    extends SwingWorker<Map<Event.Level, Integer>, Object> {
        EventStatWorker() {
        }

        @Override
        protected Map<Event.Level, Integer> doInBackground() throws Exception {
            return EventStatPane.this.countFaultByLevel();
        }

        @Override
        public void done() {
            try {
                Map eventStatMap = (Map)this.get();
                this.updateEventCount(eventStatMap);
            }
            catch (Exception e) {
                LOGGER.error("Stat Alarm error:" + e.getMessage(), (Throwable)e);
            }
        }

        private void updateEventCount(Map<Event.Level, Integer> eventStatMap) {
            int criticalCount = eventStatMap.get((Object)Event.Level.CRITICAL);
            int majorCount = eventStatMap.get((Object)Event.Level.MAJOR);
            int warningCount = eventStatMap.get((Object)Event.Level.WARNING);
            EventStatPane.this.layout.updateIcon(Event.Level.CRITICAL, criticalCount);
            EventStatPane.this.layout.updateIcon(Event.Level.MAJOR, majorCount);
            EventStatPane.this.layout.updateIcon(Event.Level.WARNING, warningCount);
        }
    }

    static class EventStatLayout
    extends JPanel {
        private static final long serialVersionUID = 6750600545554352589L;
        private static final int BUTTON_GAP = 5;
        private static final int LABEL_BUTTON_GAP = 4;
        private static Map<Event.Level, ImageIcon> flashIconMap = new HashMap<Event.Level, ImageIcon>(0);
        private static Map<Event.Level, Icon> grayIconMap = new HashMap<Event.Level, Icon>(0);
        private static Map<Event.Level, ImageIcon> normalIconMap = new HashMap<Event.Level, ImageIcon>(0);
        private JLabel statisticLabel = new JLabel(ResourceManager.getString("ALARM_STATISTIC_PANE_ALARM_STATISTIC"));
        private Map<Event.Level, ToolBarButton> buttonMap = new HashMap<Event.Level, ToolBarButton>(0);

        public EventStatLayout() {
            this.doUILayout();
        }

        private void doUILayout() {
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            Box staticBox = Box.createHorizontalBox();
            this.setAlarmIconLabel();
            staticBox.add(this.getLayoutBox());
            this.add(staticBox);
        }

        public void updateIcon(Event.Level level, int count) {
            if (null == level || !this.buttonMap.containsKey((Object)level)) {
                return;
            }
            Icon grayIcon = grayIconMap.get((Object)level);
            Icon normIcon = normalIconMap.get((Object)level);
            Icon flashIcon = flashIconMap.get((Object)level);
            ToolBarButton button = this.buttonMap.get((Object)level);
            if (count == 0) {
                this.setButtonIcon(button, grayIcon, grayIcon);
            } else {
                this.setButtonIcon(button, flashIcon, normIcon);
            }
            String prefix = level.toString();
            String text = prefix + ' ' + count;
            button.setText(text);
        }

        private void setButtonIcon(ToolBarButton button, Icon normalIcon, Icon rolloverIcon) {
            if (null != button) {
                button.setIcon(normalIcon);
                button.setDisabledIcon(normalIcon);
                button.setRolloverIcon(rolloverIcon);
                button.setRolloverSelectedIcon(rolloverIcon);
                button.setSelectedIcon(rolloverIcon);
                button.setPressedIcon(rolloverIcon);
            }
        }

        Box getLayoutBox() {
            Box statBox = Box.createHorizontalBox();
            statBox.add(this.statisticLabel);
            statBox.add(Box.createHorizontalStrut(4));
            statBox.add(this.createLevelBox(Event.Level.CRITICAL));
            statBox.add(this.createLevelBox(Event.Level.MAJOR));
            Box statLevelBox = Box.createHorizontalBox();
            statLevelBox.add(this.buttonMap.get((Object)Event.Level.WARNING));
            statBox.add(this.createLevelBox(Event.Level.WARNING));
            return statBox;
        }

        private Box createLevelBox(Event.Level level) {
            Box statLevelBox = Box.createHorizontalBox();
            statLevelBox.add(this.buttonMap.get((Object)level));
            statLevelBox.add(Box.createHorizontalStrut(5));
            return statLevelBox;
        }

        private void setAlarmIconLabel() {
            this.createToolBarButton(Event.Level.CRITICAL);
            this.createToolBarButton(Event.Level.MAJOR);
            this.createToolBarButton(Event.Level.WARNING);
        }

        private void createToolBarButton(Event.Level level) {
            ToolBarButton levelButton = new ToolBarButton(grayIconMap.get((Object)level));
            if (IsmPlafUtils.isArmorStyle()) {
                this.statisticLabel.setForeground(Color.WHITE);
                levelButton.setForeground(Color.WHITE);
                levelButton.setBorder(ArmorBorders.getToolBarButtonBorder(true));
            } else if (IsmPlafUtils.isUnifyStyle()) {
                this.statisticLabel.setText(ResourceManager.getStringWithColon("FEATURE.NAME.ALARM"));
                this.statisticLabel.setForeground(Color.WHITE);
                levelButton.setForeground(Color.WHITE);
                levelButton.setBorderPainted(false);
            } else {
                levelButton.setBorder(IsmBorders.getToolBarButtonBorder(true));
            }
            this.buttonMap.put(level, levelButton);
            levelButton.setRolloverIcon(flashIconMap.get((Object)level));
            levelButton.setRolloverSelectedIcon(flashIconMap.get((Object)level));
        }

        public Map<Event.Level, ToolBarButton> getButtonMap() {
            return this.buttonMap;
        }

        static {
            grayIconMap.put(Event.Level.CRITICAL, ResourceManager.getImage("alarm_statistic_critical.png"));
            grayIconMap.put(Event.Level.MAJOR, ResourceManager.getImage("alarm_statistic_major.png"));
            grayIconMap.put(Event.Level.WARNING, ResourceManager.getImage("alarm_statistic_warning.png"));
            normalIconMap.put(Event.Level.CRITICAL, ResourceManager.getImage("alarm_statistic_critical.png"));
            normalIconMap.put(Event.Level.MAJOR, ResourceManager.getImage("alarm_statistic_major.png"));
            normalIconMap.put(Event.Level.WARNING, ResourceManager.getImage("alarm_statistic_warning.png"));
            flashIconMap.put(Event.Level.CRITICAL, ResourceManager.getImage("critical_flash.gif"));
            flashIconMap.put(Event.Level.MAJOR, ResourceManager.getImage("major_flash.gif"));
            flashIconMap.put(Event.Level.WARNING, ResourceManager.getImage("warning_flash.gif"));
        }
    }
}

