/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.notification;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsConfigInfos
implements Cloneable,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsConfigInfos.class);
    private static final long serialVersionUID = 8301920730090359151L;
    private static final String COUNTRY_CODE_FRONT1 = "0011000";
    private static final String COUNTRY_CODE_FRONT2 = "91";
    private static final String COUNTRY_CODE_BACK = "0008A7";
    private int timeout = 5;
    private int speed = 115200;
    private String portName = "";
    private int sleepTime = 5;
    private String countryCode = "86";
    private String countryCodeFront = null;

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryCodeBack() {
        return COUNTRY_CODE_BACK;
    }

    public String getCountryCodeFront(String telphoneNo) {
        if (null == this.countryCodeFront) {
            this.countryCodeFront = COUNTRY_CODE_FRONT1 + Integer.toHexString((this.countryCode + telphoneNo).length()).toUpperCase(ResourceManager.getLocale()) + COUNTRY_CODE_FRONT2;
        }
        return this.countryCodeFront;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setSleepTime(String sleepTime) {
        if (null != sleepTime && !"".equals(sleepTime)) {
            try {
                this.sleepTime = Integer.parseInt(sleepTime);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setSpeed(String speed) {
        if (null != speed && !"".equals(speed)) {
            try {
                this.speed = Integer.parseInt(speed);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTimeout(String timeout) {
        if (null != timeout && !"".equals(timeout)) {
            try {
                this.timeout = Integer.parseInt(timeout);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.portName == null ? 0 : this.portName.hashCode());
        result = prime * result + this.speed;
        result = prime * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        boolean bool = false;
        SmsConfigInfos other = (SmsConfigInfos)obj;
        if (this.portName.equals(other.portName) && this.speed == other.speed && this.timeout == other.timeout) {
            bool = true;
        }
        return bool;
    }

    public SmsConfigInfos clone() throws CloneNotSupportedException {
        super.clone();
        SmsConfigInfos info = null;
        try {
            info = (SmsConfigInfos)super.clone();
        }
        catch (CloneNotSupportedException e) {
            info = new SmsConfigInfos();
            LOGGER.error("", (Throwable)e);
        }
        info.countryCode = this.countryCode;
        info.countryCodeFront = this.countryCodeFront;
        info.portName = this.portName;
        info.sleepTime = this.sleepTime;
        info.timeout = this.timeout;
        info.speed = this.speed;
        return info;
    }
}

