/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendar;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DateGrid
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final int DAYGRID_NUMBER = 7;
    private JButton applyButton = null;
    private JLabel[][] dayLabel = new JLabel[7][7];
    private int year = 1;
    private int month = 1;
    private int day = 1;

    public DateGrid() {
        super(new GridLayout(7, 7));
        this.initDayGridPanel();
    }

    public void setRoot(JButton root) {
        this.applyButton = root;
    }

    private void initDayGridPanel() {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                JLabel jLabel = new JLabel((String)null);
                this.dayLabel[i][j] = jLabel;
                this.add(jLabel);
                this.dayLabel[i][j].setOpaque(true);
                this.dayLabel[i][j].setHorizontalAlignment(0);
                this.dayLabel[i][j].setBackground(Color.white);
                if (i <= 0) continue;
                this.dayLabel[i][j].addMouseListener(this);
            }
        }
        this.dayLabel[0][0].setText(ResourceManager.getString("WEEK_SUNDAY"));
        this.dayLabel[0][1].setText(ResourceManager.getString("WEEK_MONDAY"));
        this.dayLabel[0][2].setText(ResourceManager.getString("WEEK_TUESDAY"));
        this.dayLabel[0][3].setText(ResourceManager.getString("WEEK_WEDNESDAY"));
        this.dayLabel[0][4].setText(ResourceManager.getString("WEEK_THURSDAY"));
        this.dayLabel[0][5].setText(ResourceManager.getString("WEEK_FRIDAY"));
        this.dayLabel[0][6].setText(ResourceManager.getString("WEEK_SATURDAY"));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setBackground(Color.white);
    }

    public void setDay(int day) {
        int days;
        int actualDay = Math.max(1, day);
        if (actualDay > (days = this.maxDay(this.year, this.month))) {
            actualDay = days;
        }
        this.day = actualDay;
        int d = 0;
        for (int i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (this.dayLabel[i][j].getText() != null && ++d == actualDay) {
                    this.dayLabel[i][j].setBackground(UIManager.getColor("IsmOEMTheme.dateGridSelectColor"));
                    this.dayLabel[i][j].setForeground(Color.white);
                    continue;
                }
                this.dayLabel[i][j].setBackground(Color.white);
                this.dayLabel[i][j].setForeground(Color.black);
            }
        }
        this.repaint();
    }

    public int getDay() {
        return this.day;
    }

    public void set(int yearTemp, int monthTemp) {
        int dayInWeak;
        int validYearTemp = this.checkYear(yearTemp);
        int validMonthTemp = this.checkMonth(monthTemp);
        int pastdaysTemp = (validYearTemp - 1) * 365 + (validYearTemp - 1) / 4 - (validYearTemp - 1) / 100;
        pastdaysTemp += (validMonthTemp - 1) * 31;
        pastdaysTemp -= (validMonthTemp - 1) / 2;
        if (9 <= validMonthTemp && 1 == validMonthTemp % 2) {
            ++pastdaysTemp;
        }
        if (validMonthTemp > 2) {
            pastdaysTemp -= 2;
            if (validYearTemp % 4 == 0 && validYearTemp % 400 != 0) {
                ++pastdaysTemp;
            }
        }
        if ((dayInWeak = pastdaysTemp % 7 - 1) == -1) {
            dayInWeak = 6;
        }
        for (int i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.dayLabel[i][j].setText(null);
            }
        }
        int days = this.maxDay(validYearTemp, validMonthTemp);
        for (int i = 1; i <= days; ++i) {
            this.dayLabel[1 + (dayInWeak + i - 1) / 7][(dayInWeak + i - 1) % 7].setText(String.valueOf(i));
        }
        this.year = validYearTemp;
        this.month = validMonthTemp;
        this.setDay(this.day);
    }

    private int checkYear(int yearTemp) {
        if (yearTemp < 1) {
            return 1;
        }
        if (yearTemp > 9999) {
            return 9999;
        }
        return yearTemp;
    }

    private int checkMonth(int monthTemp) {
        if (monthTemp < 1) {
            return 1;
        }
        if (monthTemp > 12) {
            return 12;
        }
        return monthTemp;
    }

    private int maxDay(int yearTemp, int monthTemp) {
        int days;
        int n = days = monthTemp % 2 == (monthTemp > 7 ? 0 : 1) ? 31 : 30;
        if (monthTemp == 2) {
            days = yearTemp % 4 == 0 && yearTemp % 400 != 0 ? 29 : 28;
        }
        return days;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object source = mouseEvent.getSource();
        JLabel lb = null;
        JLabel jLabel = null;
        block0: for (int i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                jLabel = this.dayLabel[i][j];
                if (jLabel != source || jLabel.getText() == null) continue;
                lb = jLabel;
                continue block0;
            }
        }
        int dd = 0;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
        for (int i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (this.dayLabel[i][j].getText() == null) continue;
                ++dd;
                if (this.dayLabel[i][j] != lb) continue;
                this.setDay(dd);
                return;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

