/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.chart;

import com.huawei.ism.util.Assert;
import com.huawei.ism.util.Unit;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.data.category.CategoryDataset;

public class CategoryCapacityTooltipGenerator
extends StandardCategoryToolTipGenerator {
    private static final long serialVersionUID = -1600231784101966070L;
    private static final String DEFAULT_TOOL_TIP_FORMAT_STRING = "{1} {0} : {2}";
    private Unit.DataUnit dataUnit = Unit.DataUnit.GB;

    public CategoryCapacityTooltipGenerator(Unit.DataUnit dataUnit, int dataPrecision) {
        super(DEFAULT_TOOL_TIP_FORMAT_STRING, (NumberFormat)new DecimalFormat(CategoryCapacityTooltipGenerator.getDoubleFormatString(dataPrecision)));
        this.dataUnit = dataUnit;
    }

    public CategoryCapacityTooltipGenerator(int dataPrecision) {
        super(DEFAULT_TOOL_TIP_FORMAT_STRING, (NumberFormat)new DecimalFormat(CategoryCapacityTooltipGenerator.getDoubleFormatString(dataPrecision)));
    }

    private static String getDoubleFormatString(int percentPrecision) {
        if (1 > percentPrecision) {
            return "###,###,###,###,##0";
        }
        StringBuffer sb = new StringBuffer("###,###,###,###,##0.");
        for (int i = 0; i < percentPrecision; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public String generateToolTip(CategoryDataset dataset, int row, int column) {
        Assert.notNull(dataset);
        Object[] items = this.createItemArray(dataset, row, column);
        return MessageFormat.format(DEFAULT_TOOL_TIP_FORMAT_STRING, items);
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result = new Object[3];
        result[0] = dataset.getRowKey(row).toString();
        result[1] = dataset.getColumnKey(column).toString();
        Number value = dataset.getValue(row, column);
        if (value != null) {
            String convertValue = Unit.adaptConvert2(value, this.dataUnit);
            result[2] = convertValue;
        } else {
            result[2] = "-";
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CategoryCapacityTooltipGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

