/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.CommonUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateChooserPanel
extends JPanel
implements ChangeListener,
ItemListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateChooserPanel.class);
    private static final Dimension TIME_SPINNER_DIMENSION = new Dimension(120, 20);
    private static final long serialVersionUID = 1L;
    private static final int MAX_YEAR = 2038;
    private static final int MIN_YEAR = 1970;
    private static final int YEAR_SPINNER_STEP = 1;
    private static final int DAYGRID_NUMBER = 7;
    private static final String SET_NAME_PREFIX = "ISMV1R2_framework_uiComponent";
    private JComboBox monthComboBox = new JComboBox();
    private Calendar initialCalendar;
    private JSpinner yearSpinner = new JSpinner();
    private DateGrid dateGrid = new DateGrid();
    private JSpinner timeSpinner = new TimeSpinner(new SpinnerDateModel());
    private JPanel p1;
    private JPanel p2;
    private JPanel panel;
    private JPanel p11;
    private String oldHHMMSS;
    private String deviceID = null;
    private Pattern pattern;
    private TimeZone dateTimeZone;
    private boolean onlyTime = false;
    private boolean onlyDay = false;
    private int model;

    public DateChooserPanel(Calendar initialDate) {
        this(initialDate, null, null);
    }

    public DateChooserPanel(Calendar initialDate, String deviceId, TimeZone timeZone, int model) {
        this.judgeTimeModel(model);
        this.setName("ISMV1R2_framework_uiComponent_AkiDateChooser");
        this.setNameForAutoTest();
        this.initialCalendar = initialDate;
        this.deviceID = deviceId;
        this.dateTimeZone = timeZone;
        this.initMonthAndYearField();
        this.initTimeSpinner();
        this.initDateChooserPanel();
        this.setCalendar(this.initialCalendar);
    }

    public DateChooserPanel(Calendar initialDate, String deviceId, TimeZone timeZone) {
        this.setName("ISMV1R2_framework_uiComponent_AkiDateChooser");
        this.setNameForAutoTest();
        this.initialCalendar = initialDate;
        this.deviceID = deviceId;
        this.dateTimeZone = timeZone;
        this.initMonthAndYearField();
        this.initTimeSpinner();
        this.initDateChooserPanel();
        this.setCalendar(this.initialCalendar);
    }

    private void judgeTimeModel(int timeModel) {
        switch (timeModel) {
            case 0: {
                this.onlyDay = true;
                this.onlyTime = false;
                break;
            }
            case 1: {
                this.onlyTime = true;
                this.onlyDay = false;
                break;
            }
        }
        this.dateGrid = new DateGrid(this.onlyTime);
    }

    private void setNameForAutoTest() {
        this.yearSpinner.setName("ISMV1R2_framework_uiComponent_yearSpinner");
        this.monthComboBox.setName("ISMV1R2_framework_uiComponent_monthComboBox");
    }

    private void initMonthAndYearField() {
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_JANUARY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_FEBRUARY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_MARCH"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_APRIL"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_MAY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_JUNE"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_JULY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_AUGUST"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_SEPERTEMBER"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_OCTOBER"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_NOVEMBER"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_DECEMBER"));
        this.yearSpinner = new JSpinner(new SpinnerNumberModel(2008, 1970, 2038, 1));
        this.yearSpinner.setName("ISMV1R2_framework_uiComponentyearSpinner");
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.yearSpinner, "0");
        editor.setName("ISMV1R2_framework_uiComponenteditor");
        JFormattedTextField textField = editor.getTextField();
        textField.setBackground(Color.white);
        textField.setName("ISMV1R2_framework_uiComponenttextField");
        textField.setEditable(false);
        this.yearSpinner.setEditor(editor);
        this.yearSpinner.addChangeListener(this);
    }

    private void initTimeSpinner() {
        this.initPattern("([0-1]\\d|2[0-4]|\\d{0,1}):([0-5]\\d|\\d{0,1}):([0-5]\\d|\\d{0,1})");
        this.timeSpinner.setName("ISMV1R2_framework_uiComponenttimeSpinner");
        this.timeSpinner.setMaximumSize(TIME_SPINNER_DIMENSION);
        this.timeSpinner.setMinimumSize(TIME_SPINNER_DIMENSION);
        this.timeSpinner.setPreferredSize(TIME_SPINNER_DIMENSION);
        JSpinner.DateEditor timeSpinnerEditor = new JSpinner.DateEditor(this.timeSpinner, "HH:mm:ss");
        final JFormattedTextField textField = timeSpinnerEditor.getTextField();
        this.oldHHMMSS = textField.getText();
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String text = textField.getText();
                Matcher matcher = DateChooserPanel.this.pattern.matcher(text);
                if (!matcher.matches()) {
                    textField.setText(DateChooserPanel.this.oldHHMMSS);
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = textField.getText();
                Matcher matcher = DateChooserPanel.this.pattern.matcher(text);
                if (!matcher.matches()) {
                    textField.setText(DateChooserPanel.this.oldHHMMSS);
                    return;
                }
            }
        });
        textField.setEditable(true);
        timeSpinnerEditor.getTextField().setHorizontalAlignment(4);
        this.timeSpinner.setEditor(timeSpinnerEditor);
    }

    private void initPattern(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    private void initDateChooserPanel() {
        this.p1 = new JPanel();
        this.p1.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(" " + ResourceManager.getString("DATE_TITLE") + " "), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.p1.setLayout(new BorderLayout(10, 10));
        this.p11 = new JPanel(new GridLayout(1, 2, 10, 10));
        this.p11.add(this.monthComboBox);
        this.monthComboBox.addItemListener(this);
        this.p11.add(this.yearSpinner);
        this.p1.add((Component)this.p11, "North");
        this.p1.add(this.dateGrid);
        this.p1.setPreferredSize(new Dimension(245, 200));
        this.p1.setMaximumSize(new Dimension(245, 200));
        this.p1.setMinimumSize(new Dimension(245, 200));
        this.add(this.p1);
        this.add(Box.createHorizontalStrut(2));
        this.p2 = new JPanel(new BorderLayout(10, 10));
        this.p2.setBorder(new TitledBorder(" " + ResourceManager.getString("TIME_TITLE") + " "));
        this.panel = new JPanel();
        this.panel.add(this.timeSpinner);
        this.p2.add((Component)this.panel, "South");
        this.p2.add(new Clock(this.timeSpinner));
        this.p2.setPreferredSize(new Dimension(150, 200));
        this.p2.setMaximumSize(new Dimension(150, 200));
        this.p2.setMinimumSize(new Dimension(150, 200));
        this.add(this.p2);
        this.setGrayed();
    }

    private void setGrayed() {
        if (this.onlyTime) {
            this.yearSpinner.setEnabled(false);
            this.monthComboBox.setEnabled(false);
            this.p1.setEnabled(false);
        }
        if (this.onlyDay) {
            this.timeSpinner.setEnabled(false);
            this.p2.setEnabled(false);
        }
    }

    public void setCalendar(Calendar calendar) {
        SpinnerNumberModel snModel;
        Comparable<?> maxYear;
        Calendar validCalendar = calendar;
        if (validCalendar == null) {
            validCalendar = new GregorianCalendar();
            if (this.dateTimeZone != null) {
                validCalendar.setTimeZone(this.dateTimeZone);
            }
        }
        this.monthComboBox.setSelectedIndex(validCalendar.get(2));
        int year = validCalendar.get(1);
        if (this.onlyTime) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            year = cal.get(1);
        }
        if ((maxYear = (snModel = (SpinnerNumberModel)this.yearSpinner.getModel()).getMaximum()).compareTo(year) < 0) {
            year = (Integer)snModel.getMinimum();
        }
        this.yearSpinner.setValue(year);
        int month = this.monthComboBox.getSelectedIndex() + 1;
        this.dateGrid.set(year, month);
        this.dateGrid.setDay(validCalendar.get(5));
        if (null != this.deviceID) {
            ((JSpinner.DateEditor)this.getTimeSpinner().getEditor()).getFormat().setTimeZone(CommonUtil.getLauncher(this.deviceID).getDeviceTimeZone());
        }
        if (this.onlyDay) {
            validCalendar.set(11, 0);
            validCalendar.set(12, 0);
            validCalendar.set(13, 0);
        }
        this.timeSpinner.setValue(validCalendar.getTime());
    }

    public Calendar getCalendar() {
        int year = (Integer)this.yearSpinner.getValue();
        int month = this.monthComboBox.getSelectedIndex();
        int day = this.dateGrid.getDay();
        Calendar instance = Calendar.getInstance();
        if (this.dateTimeZone != null) {
            instance.setTimeZone(this.dateTimeZone);
        }
        try {
            this.timeSpinner.commitEdit();
        }
        catch (ParseException e) {
            LOGGER.error("", (Throwable)e);
        }
        Date date = (Date)this.timeSpinner.getValue();
        instance.setTime(date);
        instance.set(year, month, day);
        if (instance.getTime().getTime() < 0L) {
            instance.setTime(new Date(0L));
        }
        return instance;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.dateGrid.set((Integer)this.yearSpinner.getValue(), this.monthComboBox.getSelectedIndex() + 1);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.dateGrid.set((Integer)this.yearSpinner.getValue(), this.monthComboBox.getSelectedIndex() + 1);
    }

    public JSpinner getTimeSpinner() {
        return this.timeSpinner;
    }

    public JSpinner getYearSpinner() {
        return this.yearSpinner;
    }

    public void setYearSpinner(JSpinner yearSpinner) {
        this.yearSpinner = yearSpinner;
    }

    public JComboBox getMonthComboBox() {
        return this.monthComboBox;
    }

    public void setMonthComboBox(JComboBox monthComboBox) {
        this.monthComboBox = monthComboBox;
    }

    public DateGrid getDateGrid() {
        return this.dateGrid;
    }

    public void setDateGrid(DateGrid dateGrid) {
        this.dateGrid = dateGrid;
    }

    public void setTimeSpinner(JSpinner timeSpinner) {
        this.timeSpinner = timeSpinner;
    }

    private static class Clock
    extends JComponent
    implements ChangeListener {
        private Calendar calendar1;
        private int[] xLabel = new int[4];
        private int[] yLabel = new int[4];

        public Clock(JSpinner time) {
            time.addChangeListener(this);
            this.stateChanged(new ChangeEvent(time));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner sp = (JSpinner)e.getSource();
            Date date = (Date)sp.getValue();
            if (this.calendar1 == null) {
                this.calendar1 = Calendar.getInstance();
            }
            this.calendar1.setTime(date);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float ox = (float)this.getWidth() / 2.0f;
            float oy = (float)this.getHeight() / 2.0f;
            float rr = 60.0f;
            Ellipse2D.Float oval = new Ellipse2D.Float();
            float a = 0.0f;
            float dx = 0.0f;
            float dy = 0.0f;
            for (int i = 0; i < 360; i += 6) {
                a = (float)i / 360.0f * (float)Math.PI * 2.0f;
                dx = (float)Math.sin(a) * 60.0f;
                dy = (float)Math.cos(a) * 60.0f;
                g2d.setColor(i % 30 == 0 ? Color.black : Color.lightGray);
                BigDecimal bd1 = new BigDecimal(ox);
                BigDecimal bd2 = new BigDecimal(dx);
                BigDecimal bd3 = new BigDecimal(1.0);
                BigDecimal bd4 = new BigDecimal(oy);
                BigDecimal bd5 = new BigDecimal(dy);
                oval.setFrame(bd1.subtract(bd2).subtract(bd3).floatValue(), bd4.subtract(bd5).subtract(bd3).floatValue(), 2.0f, 2.0f);
                g2d.fill(oval);
                if (i % 30 != 0) continue;
                g2d.setColor(UIManager.getColor("IsmOEMTheme.dateGridSelectColor"));
                BigDecimal bd7 = new BigDecimal(oy);
                BigDecimal bd8 = new BigDecimal(dy);
                BigDecimal bd9 = new BigDecimal(1.0);
                oval.setFrame(ox + dx - 2.0f, bd7.add(bd8).subtract(bd9).floatValue(), 2.0f, 2.0f);
                g2d.fill(oval);
            }
            this.drawHands(g2d, ox, oy);
        }

        private void drawHands(Graphics2D g2d, float ox, float oy) {
            int hour = this.calendar1.get(10);
            int minute = this.calendar1.get(12);
            int second = this.calendar1.get(13);
            float ha = 0.5235988f * ((float)hour + (float)minute / 60.0f);
            float ma = 0.10471976f * ((float)minute + (float)second / 60.0f);
            float sa = 0.10471976f * (float)second;
            g2d.setColor(Color.lightGray);
            g2d.translate(1, 1);
            this.drawHand(g2d, ox, oy, ha, 40.0f);
            g2d.translate(1, 1);
            this.drawHand(g2d, ox, oy, ma, 48.0f);
            g2d.translate(1, 1);
            this.drawHand(g2d, ox, oy, sa, 50.0f, false);
            g2d.translate(-3, -3);
            g2d.setColor(UIManager.getColor("IsmOEMTheme.dateGridSelectColor"));
            this.drawHand(g2d, ox, oy, ha, 40.0f);
            this.drawHand(g2d, ox, oy, ma, 48.0f);
            g2d.setColor(Color.black);
            this.drawHand(g2d, ox, oy, sa, 50.0f, false);
        }

        private void drawHand(Graphics2D g2, float ox, float oy, float flo, float len, boolean what) {
            this.xLabel[2] = (int)(ox + (float)Math.sin(flo) * len);
            this.yLabel[2] = (int)(oy - (float)Math.cos(flo) * len);
            this.xLabel[0] = (int)(ox + (float)Math.sin((double)flo + Math.PI) * 10.0f);
            this.yLabel[0] = (int)(oy - (float)Math.cos((double)flo + Math.PI) * 10.0f);
            if (what) {
                this.xLabel[1] = (int)(ox + (float)Math.sin((double)flo + 1.5707963267948966) * 3.0f);
                this.yLabel[1] = (int)(oy - (float)Math.cos((double)flo + 1.5707963267948966) * 3.0f);
                this.xLabel[3] = (int)(ox + (float)Math.sin((double)flo + 4.71238898038469) * 3.0f);
                this.yLabel[3] = (int)(oy - (float)Math.cos((double)flo + 4.71238898038469) * 3.0f);
                g2.fillPolygon(this.xLabel, this.yLabel, 4);
            } else {
                Line2D.Float line = new Line2D.Float(this.xLabel[0], this.yLabel[0], this.xLabel[2], this.yLabel[2]);
                g2.draw(line);
            }
        }

        private void drawHand(Graphics2D g2, float ox, float oy, float a, float len) {
            this.drawHand(g2, ox, oy, a, len, true);
        }
    }

    public static class DateGrid
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private JLabel[][] dayJLabel = new JLabel[7][7];
        private int year = 1;
        private int month = 1;
        private int day = 1;
        private boolean onlyDay = false;

        public DateGrid() {
            super(new GridLayout(7, 7));
            this.initDayGridPanel();
        }

        public DateGrid(boolean model) {
            super(new GridLayout(7, 7));
            this.onlyDay = model;
            this.initDayGridPanel();
        }

        private void initDayGridPanel() {
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 7; ++j) {
                    JLabel jLabel = new JLabel((String)null);
                    this.dayJLabel[i][j] = jLabel;
                    this.add(jLabel);
                    this.dayJLabel[i][j].setName("ISMV1R2_framework_uiComponent_dayLabel[" + i + "][" + j + "]");
                    this.dayJLabel[i][j].setOpaque(true);
                    this.dayJLabel[i][j].setHorizontalAlignment(0);
                    this.dayJLabel[i][j].setBackground(Color.white);
                    if (this.onlyDay) {
                        this.dayJLabel[i][j].setEnabled(false);
                        continue;
                    }
                    if (i <= 0) continue;
                    this.dayJLabel[i][j].addMouseListener(this);
                }
            }
            this.dayJLabel[0][0].setText(ResourceManager.getString("WEEK_SUNDAY"));
            this.dayJLabel[0][1].setText(ResourceManager.getString("WEEK_MONDAY"));
            this.dayJLabel[0][2].setText(ResourceManager.getString("WEEK_TUESDAY"));
            this.dayJLabel[0][3].setText(ResourceManager.getString("WEEK_WEDNESDAY"));
            this.dayJLabel[0][4].setText(ResourceManager.getString("WEEK_THURSDAY"));
            this.dayJLabel[0][5].setText(ResourceManager.getString("WEEK_FRIDAY"));
            this.dayJLabel[0][6].setText(ResourceManager.getString("WEEK_SATURDAY"));
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.setBackground(Color.white);
        }

        public void setDay(int day) {
            int maxDay;
            int actualDay = Math.max(1, day);
            if (actualDay > (maxDay = this.maxDay(this.year, this.month))) {
                actualDay = maxDay;
            }
            this.day = actualDay;
            int d = 0;
            for (int i = 1; i < 7; ++i) {
                for (int j = 0; j < 7; ++j) {
                    if (this.dayJLabel[i][j].getText() != null && ++d == actualDay) {
                        this.dayJLabel[i][j].setBackground(UIManager.getColor("IsmOEMTheme.dateGridSelectColor"));
                        this.dayJLabel[i][j].setForeground(Color.white);
                        continue;
                    }
                    this.dayJLabel[i][j].setBackground(Color.white);
                    this.dayJLabel[i][j].setForeground(Color.black);
                }
            }
            this.repaint();
        }

        public int getDay() {
            return this.day;
        }

        public void set(int targetYear, int targetMonth) {
            int validTargetYear = targetYear < 1 ? 1 : Math.min(targetYear, 9999);
            int validTargetMonth = targetMonth < 1 ? 1 : Math.min(targetMonth, 12);
            int pastdays = (validTargetYear - 1) * 365 + (validTargetYear - 1) / 4 - (validTargetYear - 1) / 100;
            pastdays += (validTargetMonth - 1) * 31;
            pastdays -= (validTargetMonth - 1) / 2;
            if (9 <= validTargetMonth && 1 == validTargetMonth % 2) {
                ++pastdays;
            }
            if (validTargetMonth > 2) {
                pastdays -= 2;
                if (validTargetYear % 4 == 0 && validTargetYear % 400 != 0) {
                    ++pastdays;
                }
            }
            int dayInWeak = pastdays % 7 - 1;
            this.setDegrad(dayInWeak, validTargetYear, validTargetMonth);
        }

        private void setDegrad(int dayInWeak, int targetYear, int targetMonth) {
            int validDayInWeek = dayInWeak == -1 ? 6 : dayInWeak;
            for (int i = 1; i < 7; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.dayJLabel[i][j].setText(null);
                }
            }
            int days = this.maxDay(targetYear, targetMonth);
            for (int i = 1; i <= days; ++i) {
                this.dayJLabel[1 + (validDayInWeek + i - 1) / 7][(validDayInWeek + i - 1) % 7].setText(String.valueOf(i));
            }
            this.year = targetYear;
            this.month = targetMonth;
            this.setDay(this.day);
        }

        private int maxDay(int targetYear, int targetMonth) {
            int days;
            int n = days = targetMonth % 2 == (targetMonth > 7 ? 0 : 1) ? 31 : 30;
            if (targetMonth == 2) {
                days = targetYear % 4 == 0 && targetYear % 400 != 0 ? 29 : 28;
            }
            return days;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object source = mouseEvent.getSource();
            JLabel lb = null;
            JLabel jLabel = null;
            block0: for (int ii = 1; ii < 7; ++ii) {
                for (int jj = 0; jj < 7; ++jj) {
                    jLabel = this.dayJLabel[ii][jj];
                    if (jLabel != source || jLabel.getText() == null) continue;
                    lb = jLabel;
                    continue block0;
                }
            }
            int counter = 0;
            JLabel dayLabel = null;
            for (int ii = 1; ii < 7; ++ii) {
                for (int jj = 0; jj < 7; ++jj) {
                    dayLabel = this.dayJLabel[ii][jj];
                    if (dayLabel.getText() == null) continue;
                    ++counter;
                    if (dayLabel != lb) continue;
                    this.setDay(counter);
                    return;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private static class TimeSpinner
    extends JSpinner
    implements AdjustmentListener {
        private static final long serialVersionUID = 1L;

        public TimeSpinner() {
        }

        public TimeSpinner(SpinnerModel model) {
            super(model);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
        }
    }
}

