/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class InfoDialog
extends JDialog
implements DialogsConstants,
IAutoProcess {
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int GRIDY_1 = 1;
    private static final int INSETS_EMPTY = 0;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private static final int DISPLAY_PROMPT_DEFAULT_COLUMN = 31;
    private int textColumn = 0;
    private boolean focusYes = false;
    private JButton cancelButton;
    private JButton continueButton;
    private JPanel displayPanel;
    private IsmTextArea displayPrompt;
    private JScrollPane scroll = null;
    private JLabel imageLabel;
    private JPanel wholePanel;
    private Box buttonPanel;
    private int dialogValue = -1;
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    public InfoDialog(Window parent, String message, Dimension dimension, boolean wrapStyleWord) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.layoutUI(message, dimension, wrapStyleWord);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    private void layoutUI(String message, Dimension dimension, boolean wrapStyleWord) {
        this.toFront();
        this.init(message, dimension, wrapStyleWord);
    }

    private void init(String message, Dimension dimension, boolean wrapStyleWord) {
        super.setTitle(ResourceManager.getString("INFORMATION_DIALOG_TITLE"));
        this.initButton();
        this.iniView(dimension, wrapStyleWord);
        this.initComponent();
        this.initButtonEvent();
        this.initMessage(message);
        SwingUtil.putScreenCenter(this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter(this, this.getOwner());
        SwingUtil.setName(this);
        this.setCompName();
        this.getRootPane().setDefaultButton(this.focusYes ? this.cancelButton : this.continueButton);
    }

    private void initMessage(String message) {
        ImageIcon imageIcon = ResourceManager.getImage("Information.png");
        this.imageLabel.setIcon(imageIcon);
        this.displayPrompt.setText(message);
        this.displayPrompt.setCaretPosition(0);
        this.pack();
    }

    private void iniView(Dimension dimension, boolean wrapStyleWord) {
        this.wholePanel = new JPanel();
        this.displayPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_framework_WarningDialog_imageLabel");
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setEditable(false);
        this.displayPrompt.setColumns(31);
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.displayPrompt.setWrapStyleWord(wrapStyleWord);
        this.scroll = new JScrollPane(this.displayPrompt);
        this.scroll.setPreferredSize(dimension);
    }

    private void initButton() {
        String cancelInfo = ResourceManager.getString("DATECHOOSER_CANCEL");
        this.cancelButton = this.creatButton(cancelInfo, 'C');
        String okInfo = ResourceManager.getString("CREATEHOSTDIALOG_CONTINUE");
        this.continueButton = this.creatButton(okInfo, 'O');
    }

    private JButton creatButton(String info, char mnemonic) {
        JButton button = UCD.createButton(info, mnemonic);
        button.setToolTipText(info);
        button.setPreferredSize(new Dimension(100, BUTTON_HTGHT));
        button.setMaximumSize(new Dimension(100, BUTTON_HTGHT));
        button.setMinimumSize(new Dimension(100, BUTTON_HTGHT));
        return button;
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                if (this.focusYes) {
                    this.continueButton.requestFocus();
                    break;
                }
                this.cancelButton.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    private void setCompName() {
        this.cancelButton.setName("_Button_cancelButton");
        this.continueButton.setName("_Button_confirmButton");
        this.displayPrompt.setName("_TextArea_displayPrompt");
    }

    protected void initComponent() {
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        this.wholePanel.add((Component)this.displayPanel, this.getDisplayPanelConstraints());
        this.wholePanel.add((Component)this.buildSeparator(), this.getSeparatorConstraints());
        this.wholePanel.add((Component)this.buildButtonPanel(), this.getButtonConstraints());
        this.displayPanel.setLayout(new GridBagLayout());
        this.displayPanel.add((Component)this.imageLabel, this.getImageLabelConstraints());
        this.initScroll();
        this.displayPanel.add((Component)this.scroll, this.getScrollConstraints());
    }

    private void initScroll() {
        this.displayPrompt.setBorder(UCD.createEmptyBorder());
        this.displayPrompt.setMargin(new Insets(0, 0, 0, 0));
        this.scroll.setBorder(UCD.createEmptyBorder());
        this.displayPrompt.setOpaque(true);
        this.displayPrompt.setBackground(this.displayPanel.getBackground());
        this.scroll.setOpaque(true);
        this.scroll.setBackground(this.displayPanel.getBackground());
    }

    private GridBagConstraints getScrollConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        return gridBagConstraints;
    }

    private GridBagConstraints getImageLabelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        return gridBagConstraints;
    }

    private Box buildButtonPanel() {
        this.buttonPanel = UCD.buildHBoxCentert(this.continueButton, this.cancelButton);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        return bottomPanel;
    }

    private GridBagConstraints getButtonConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        return gridBagConstraints;
    }

    private Box buildSeparator() {
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new WarningDialog.ArmorSeparator();
        }
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(8);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        return innerBox;
    }

    private GridBagConstraints getSeparatorConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        return gridBagConstraints;
    }

    private GridBagConstraints getDisplayPanelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 9, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        return gridBagConstraints;
    }

    private void initButtonEvent() {
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.this.cannelButtonAction(actionEvent);
            }
        });
        new AutoProcessObserver(this);
        this.addComponentListener(new AutoProcessListener(this));
    }

    private void cannelButtonAction(ActionEvent e) {
        this.dialogValue = 1;
        this.dispose();
    }

    private void confimButtonAction(ActionEvent e) {
        this.dialogValue = 0;
        this.dispose();
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.continueButton.doClick();
    }

    @Override
    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    public void setValue(int value) {
        if (Utils.isJunitTest()) {
            this.dialogValue = value;
        }
    }

    public int getValue() {
        return this.dialogValue;
    }
}

