/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.listener;

import java.util.function.Consumer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldDocumentListener
implements DocumentListener {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentListener.class);
    private final Consumer<String> actionFunc;

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doAction(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doAction(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.doAction(e);
    }

    private void doAction(DocumentEvent e) {
        Document document = e.getDocument();
        try {
            String text = document.getText(0, document.getLength());
            this.actionFunc.accept(text);
        }
        catch (BadLocationException badLocationException) {
            log.error("input field action error");
        }
    }

    public FieldDocumentListener(Consumer<String> actionFunc) {
        this.actionFunc = actionFunc;
    }
}

