/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmNormTheme;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.PopupFactory;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class IsmLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 5685982499689642828L;

    @Override
    public void initialize() {
        super.initialize();
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        PopupFactory.setSharedInstance(new PopupFactory());
    }

    @Override
    public String getName() {
        return "Ism";
    }

    @Override
    public String getID() {
        return "ISM";
    }

    @Override
    public String getDescription() {
        return "The ISM Look and Feel";
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            MyRGBGilter filter = new MyRGBGilter();
            FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
            Image progressedImage = Toolkit.getDefaultToolkit().createImage(prod);
            return new IconUIResource(new ImageIcon(progressedImage));
        }
        return icon;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String ismPackageName = "com.huawei.ism.ui.swing.plaf.";
        table.put("ImagePanelUI", "com.huawei.ism.ui.swing.plaf.IsmImagePanelUI");
        table.put("ToolBarSeparatorUI", "com.huawei.ism.ui.swing.plaf.IsmToolBarSeparatorUI");
        table.put("ToolTipUI", "com.huawei.ism.ui.swing.plaf.IsmToolTipUI");
        table.put("LabelUI", "com.huawei.ism.ui.swing.plaf.IsmLabelUI");
        table.put("TextFieldUI", "com.huawei.ism.ui.swing.plaf.IsmTextFieldUI");
        table.put("FormattedTextFieldUI", "com.huawei.ism.ui.swing.plaf.IsmFormattedTextFieldUI");
        table.put("TreeUI", "com.huawei.ism.ui.swing.plaf.IsmTreeUI");
        table.put("CheckBoxUI", "com.huawei.ism.ui.swing.plaf.IsmCheckBoxUI");
        table.put("RadioButtonUI", "com.huawei.ism.ui.swing.plaf.IsmRadioButtonUI");
        table.put("ButtonUI", "com.huawei.ism.ui.swing.plaf.IsmButtonUI");
        table.put("RolloverButtonUI", "com.huawei.ism.ui.swing.plaf.IsmRolloverButtonUI");
        table.put("ToggleButtonUI", "com.huawei.ism.ui.swing.plaf.IsmToggleButtonUI");
        table.put("ToolBarUI", "com.huawei.ism.ui.swing.plaf.IsmToolBarUI");
        table.put("TabbedPaneUI", "com.huawei.ism.ui.swing.plaf.IsmTabbedPaneUI");
        table.put("RootPaneUI", "com.huawei.ism.ui.swing.plaf.IsmRootPaneUI");
        table.put("ScrollBarUI", "com.huawei.ism.ui.swing.plaf.IsmScrollBarUI");
        table.put("MenuBarUI", "com.huawei.ism.ui.swing.plaf.IsmMenuBarUI");
        table.put("MenuUI", "com.huawei.ism.ui.swing.plaf.IsmMenuUI");
        table.put("MenuItemUI", "com.huawei.ism.ui.swing.plaf.IsmMenuItemUI");
        table.put("CheckBoxMenuItemUI", "com.huawei.ism.ui.swing.plaf.IsmCheckBoxMenuItemUI");
        table.put("RadioButtonMenuItemUI", "com.huawei.ism.ui.swing.plaf.IsmRadioButtonMenuItemUI");
        table.put("PopupMenuUI", "com.huawei.ism.ui.swing.plaf.IsmPopupMenuUI");
        table.put("PopupMenuSeparatorUI", "com.huawei.ism.ui.swing.plaf.IsmPopupMenuSeparatorUI");
        table.put("ListUI", "com.huawei.ism.ui.swing.plaf.IsmListUI");
        table.put("ProgressBarUI", "com.huawei.ism.ui.swing.plaf.IsmProgressBarUI");
        table.put("SliderUI", "com.huawei.ism.ui.swing.plaf.IsmSliderUI");
        table.put("TableHeaderUI", "com.huawei.ism.ui.swing.plaf.IsmTableHeaderUI");
        table.put("SpinnerUI", "com.huawei.ism.ui.swing.plaf.IsmSpinnerUI");
        table.put("SplitPaneUI", "com.huawei.ism.ui.swing.plaf.IsmSplitPaneUI");
        table.put("TableUI", "com.huawei.ism.ui.swing.plaf.IsmTableUI");
        table.put("ComboBoxUI", "com.huawei.ism.ui.swing.plaf.IsmComboBoxUI");
        table.put("FileChooserUI", "com.huawei.ism.ui.swing.plaf.IsmFileChooserUI");
        table.put("GradientPanelUI", "com.huawei.ism.ui.swing.plaf.IsmGradientPanelUI");
        table.put("IsmToolBarButtonUI", "com.huawei.ism.ui.swing.plaf.IsmToolBarButtonUI");
        table.put("IsmComboBoxButtonUI", "com.huawei.ism.ui.swing.plaf.IsmComboBoxButtonUI");
        table.put("AboutPopupUI", "com.huawei.ism.ui.swing.plaf.AboutPopupUI");
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        MetalTheme cueentTheme = IsmLookAndFeel.getCurrentTheme();
        ColorUIResource control = cueentTheme.getControl();
        Object[] systemColors = new Object[]{"desktop", cueentTheme.getDesktopColor(), "activeCaption", cueentTheme.getWindowTitleBackground(), "activeCaptionText", cueentTheme.getWindowTitleForeground(), "activeCaptionBorder", cueentTheme.getPrimaryControlShadow(), "inactiveCaption", cueentTheme.getWindowTitleInactiveBackground(), "inactiveCaptionText", cueentTheme.getWindowTitleInactiveForeground(), "inactiveCaptionBorder", cueentTheme.getControlShadow(), "window", cueentTheme.getWindowBackground(), "windowBorder", control, "windowText", cueentTheme.getUserTextColor(), "menu", cueentTheme.getMenuBackground(), "menuText", cueentTheme.getMenuForeground(), "text", cueentTheme.getWindowBackground(), "textText", cueentTheme.getUserTextColor(), "textHighlight", cueentTheme.getTextHighlightColor(), "textHighlightText", cueentTheme.getHighlightedTextColor(), "textInactiveText", cueentTheme.getInactiveSystemTextColor(), "control", control, "controlText", cueentTheme.getControlTextColor(), "controlHighlight", cueentTheme.getControlHighlight(), "controlLtHighlight", cueentTheme.getControlHighlight(), "controlShadow", cueentTheme.getControlShadow(), "controlDkShadow", cueentTheme.getControlDarkShadow(), "scrollbar", control, "info", cueentTheme.getPrimaryControl(), "infoText", cueentTheme.getPrimaryControlInfo()};
        table.putDefaults(systemColors);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.setDefaultLocale(IsmPlafUtils.getLocale());
        table.addResourceBundle("com.huawei.ism.ui.swing.plaf.resource.laf");
        this.putBasicInfo(table);
        CompoundBorder tooltipBorder = new CompoundBorder(new BorderUIResource.LineBorderUIResource(new ColorUIResource(11315353)), new BorderUIResource.EmptyBorderUIResource(0, 2, 2, 2));
        this.putSecondaryInfo(table, tooltipBorder);
        table.put("MenuItem.borderPainted", Boolean.FALSE);
        table.put("RadioButtonMenuItem.borderPainted", Boolean.FALSE);
        table.put("CheckBoxMenuItem.borderPainted", Boolean.FALSE);
        table.put("MenuItem.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("RadioButtonMenuItem.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("CheckBoxMenuItem.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("ProgressBar.border", new BorderUIResource.LineBorderUIResource(new ColorUIResource(4619935)));
        table.put("ScrollPane.border", IsmBorders.getScrollPaneBorder());
        table.put("Button.defaultButtonFollowsFocus", (Object)true);
        table.put("FileChooser.saveButtonMnemonic", (Object)83);
        table.put("FileChooser.openButtonMnemonic", (Object)79);
        table.put("FileChooser.cancelButtonMnemonic", (Object)67);
        table.put("FileChooser.updateButtonMnemonic", (Object)85);
        table.put("FileChooser.helpButtonMnemonic", (Object)72);
        table.put("FileChooser.directoryOpenButtonMnemonic", (Object)79);
    }

    private void putSecondaryInfo(UIDefaults table, Border tooltipBorder) {
        table.put("ToolTip.border", tooltipBorder);
        table.put("ToolTip.borderInactive", tooltipBorder);
        table.put("TextField.border", IsmBorders.getTextFieldBorder());
        table.put("PasswordField.border", IsmBorders.getTextFieldBorder());
        table.put("FormattedTextField.border", IsmBorders.getTextFieldBorder());
        table.put("Button.border", IsmBorders.getButtonBorder(true));
        table.put("RolloverButton.border", IsmBorders.getRolloverButtonButton(true));
        table.put("ToggleButton.border", IsmBorders.getButtonBorder(true));
        table.put("ToolBar.border", IsmBorders.getToolBarBorder());
        table.put("ToolBar.separatorSize", new DimensionUIResource(20, 11));
        table.put("ToolTip.hideAccelerator", Boolean.TRUE);
        table.put("MenuBar.border", IsmBorders.getMenuBarBorder());
        table.put("Menu.borderPainted", Boolean.FALSE);
        table.put("PopupMenu.border", IsmBorders.getPopupMenuBorder());
        table.put("TableHeader.cellBorder", IsmBorders.getTableHeaderBorder());
        table.put("TitledBorder.border", new BorderUIResource.LineBorderUIResource(new Color(10859197)));
        table.put("Spinner.arrowButtonBorder", IsmBorders.getButtonBorder(false));
        table.put("Spinner.arrowButtonInsets", new InsetsUIResource(2, 2, 2, 2));
        table.put("SplitPane.centerOneTouchButtons", Boolean.TRUE);
        table.put("SplitPane.oneTouchButtonOffset", (Object)0);
        table.put("SplitPane.border", IsmBorders.getSplitPaneBorder());
        table.put("Spinner.border", IsmBorders.getComboBoxBorder());
        table.put("ComboBox.border", IsmBorders.getComboBoxBorder());
        table.put("SplitPaneDivider.border", IsmBorders.getSplitPaneDividerBorder());
        InsetsUIResource tabbedPaneTabInsets = new InsetsUIResource(0, 10, 1, 10);
        InsetsUIResource tabbedPaneTabPadInsets = new InsetsUIResource(2, 2, 2, 1);
        InsetsUIResource tabbedPaneTabAreaInsets = new InsetsUIResource(3, 2, 0, 2);
        InsetsUIResource tabbedPaneContentBorderInsets = new InsetsUIResource(2, 2, 3, 3);
        table.put("TabbedPane.tabInsets", tabbedPaneTabInsets);
        table.put("TabbedPane.selectedTabPadInsets", tabbedPaneTabPadInsets);
        table.put("TabbedPane.tabAreaInsets", tabbedPaneTabAreaInsets);
        table.put("TabbedPane.contentBorderInsets", tabbedPaneContentBorderInsets);
    }

    private void putBasicInfo(UIDefaults table) {
        table.put("RootPane.defaultButtonWindowKeyBindings", new Object[]{"ESCAPE", "quit", "ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"});
        table.put("swing.boldMetal", Boolean.FALSE);
        table.put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "ENTER", "pressed", "released SPACE", "released", "released ENTER", "released"}));
        table.put("TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl TAB", "navigateNext", "ctrl shift TAB", "navigatePrevious", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}));
        table.put("Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{KeyStroke.getKeyStroke(106, 0), "expandAll", "ADD", "expand", "SUBTRACT", "collapse", "ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "ctrl shift UP", "selectPreviousExtendSelection", "ctrl shift KP_UP", "selectPreviousExtendSelection", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "ctrl shift DOWN", "selectNextExtendSelection", "ctrl shift KP_DOWN", "selectNextExtendSelection", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "ctrl shift HOME", "selectFirstExtendSelection", "ctrl HOME", "selectFirstChangeLead", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl shift END", "selectLastExtendSelection", "ctrl END", "selectLastChangeLead", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}));
    }

    @Override
    protected void createDefaultTheme() {
        super.createDefaultTheme();
        MetalLookAndFeel.setCurrentTheme(new IsmNormTheme());
    }

    private static final class MyRGBGilter
    extends RGBImageFilter {
        private MyRGBGilter() {
        }

        @Override
        public int filterRGB(int xAxis, int yAxis, int rgb) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            float[] hsb = new float[3];
            Color.RGBtoHSB(red, green, blue, hsb);
            hsb[1] = hsb[1] * 0.1f;
            hsb[2] = hsb[2] * 0.9f;
            int srgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            return rgb & 0xFF000000 | srgb & 0xFFFFFF;
        }
    }
}

