/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.splitpane.IsmSplitPane;
import com.huawei.ism.util.CommonUtil;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewIsmSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewIsmSplitPaneDivider.class);
    private static final long serialVersionUID = 27196358545831131L;
    private IsmSplitPane splitPane = null;
    private DividerButton rightBtn;
    private DividerButton leftBtn;

    public NewIsmSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.splitPane = CommonUtil.convertObject(ui.getSplitPane(), IsmSplitPane.class);
        this.init();
    }

    private void init() {
        this.leftBtn = new DividerButton(this);
        this.rightBtn = new DividerButton(this);
        if (this.splitPane.getOrientation() == 0) {
            this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_downArrow_normal.png"));
            this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_upArrow_normal.png"));
        } else {
            this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_rightArrow_normal.png"));
            this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_leftArrow_normal.png"));
        }
        this.leftBtn.addMouseListener(new LeftBtnMouseAdapter());
        this.rightBtn.addMouseListener(new RightBtnMouseAdapter());
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        if (this.splitPane.isOneSideExpand()) {
            if (!this.splitPane.isExpanded() && this.splitPane.isExpandDown() || this.splitPane.isExpanded() && !this.splitPane.isExpandDown()) {
                this.rightBtn.setVisible(false);
                this.leftBtn.setVisible(true);
                int iconWidth = this.leftBtn.getIcon().getIconWidth();
                int iconHeight = this.leftBtn.getIcon().getIconHeight();
                int ww = this.getWidth() - iconWidth + 1 >> 1;
                int hh = this.getHeight() - iconHeight >> 1;
                this.leftBtn.setLocation(ww, hh);
                this.leftBtn.setSize(iconWidth, iconHeight);
                this.leftBtn.paint(graphics, ww, hh);
            } else {
                this.leftBtn.setVisible(false);
                this.rightBtn.setVisible(true);
                int iconWidth = this.rightBtn.getIcon().getIconWidth();
                int iconHeight = this.rightBtn.getIcon().getIconHeight();
                int ww = this.getWidth() - iconWidth + 1 >> 1;
                int hh = this.getHeight() - iconHeight >> 1;
                this.rightBtn.setLocation(ww, hh);
                this.rightBtn.setSize(iconWidth, iconHeight);
                this.rightBtn.paint(graphics, ww, hh);
            }
        }
    }

    protected void paintBackground(Graphics grap) {
        boolean isHorizonal;
        boolean bl = isHorizonal = this.orientation == 1;
        if (!isHorizonal) {
            ImageIcon leftIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.HorizonalLeftBG");
            ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.HorizonalCenterBG");
            ImageIcon rightIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.HorizonalRightBG");
            int width = this.getWidth();
            grap.drawImage(leftIcon.getImage(), 0, 0, leftIcon.getIconWidth(), leftIcon.getIconHeight(), this);
            grap.drawImage(centerIcon.getImage(), leftIcon.getIconWidth(), 0, width - leftIcon.getIconWidth() - rightIcon.getIconWidth(), centerIcon.getIconHeight(), this);
            grap.drawImage(rightIcon.getImage(), width - rightIcon.getIconWidth(), 0, rightIcon.getIconWidth(), rightIcon.getIconHeight(), this);
        } else {
            ImageIcon upIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.VerticalUpBG");
            ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.VerticalCenterBG");
            ImageIcon downIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.VerticalDownBG");
            int height = this.getHeight();
            grap.drawImage(upIcon.getImage(), 0, 0, upIcon.getIconWidth(), upIcon.getIconHeight(), this);
            grap.drawImage(centerIcon.getImage(), 0, upIcon.getIconHeight(), centerIcon.getIconWidth(), height - upIcon.getIconHeight() - downIcon.getIconHeight(), this);
            grap.drawImage(downIcon.getImage(), 0, height - downIcon.getIconHeight(), downIcon.getIconWidth(), downIcon.getIconHeight(), this);
        }
    }

    @Override
    protected void setMouseOver(boolean mouseOver) {
        super.setMouseOver(mouseOver);
        this.repaint();
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        this.leftBtn.setCursor(Cursor.getPredefinedCursor(0));
        this.leftBtn.setFocusPainted(false);
        this.leftBtn.setBorderPainted(false);
        this.leftBtn.setRequestFocusEnabled(false);
        return this.leftBtn;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        this.rightBtn.setCursor(Cursor.getPredefinedCursor(0));
        this.rightBtn.setFocusPainted(false);
        this.rightBtn.setBorderPainted(false);
        this.rightBtn.setRequestFocusEnabled(false);
        return this.rightBtn;
    }

    private class RightBtnMouseAdapter
    extends MouseAdapter {
        private RightBtnMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NewIsmSplitPaneDivider.this.rightBtn.setCursor(Cursor.getPredefinedCursor(12));
            if (NewIsmSplitPaneDivider.this.splitPane.getOrientation() == 0) {
                NewIsmSplitPaneDivider.this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_downArrow_rollover.png"));
            } else {
                NewIsmSplitPaneDivider.this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_rightArrow_rollover.png"));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NewIsmSplitPaneDivider.this.rightBtn.setCursor(Cursor.getDefaultCursor());
            if (NewIsmSplitPaneDivider.this.splitPane.getOrientation() == 0) {
                NewIsmSplitPaneDivider.this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_downArrow_normal.png"));
            } else {
                NewIsmSplitPaneDivider.this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_rightArrow_normal.png"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (NewIsmSplitPaneDivider.this.splitPane.getOrientation() == 0) {
                NewIsmSplitPaneDivider.this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_downArrow_normal.png"));
            } else {
                NewIsmSplitPaneDivider.this.rightBtn.setIcon(ResourceManager.getImage("deviceFigure_rightArrow_normal.png"));
            }
        }
    }

    private class LeftBtnMouseAdapter
    extends MouseAdapter {
        private LeftBtnMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NewIsmSplitPaneDivider.this.leftBtn.setCursor(Cursor.getPredefinedCursor(12));
            if (NewIsmSplitPaneDivider.this.splitPane.getOrientation() == 0) {
                NewIsmSplitPaneDivider.this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_upArrow_rollover.png"));
            } else {
                NewIsmSplitPaneDivider.this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_leftArrow_rollover.png"));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NewIsmSplitPaneDivider.this.leftBtn.setCursor(Cursor.getDefaultCursor());
            if (NewIsmSplitPaneDivider.this.splitPane.getOrientation() == 0) {
                NewIsmSplitPaneDivider.this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_upArrow_normal.png"));
            } else {
                NewIsmSplitPaneDivider.this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_leftArrow_normal.png"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (NewIsmSplitPaneDivider.this.splitPane.getOrientation() == 1) {
                NewIsmSplitPaneDivider.this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_upArrow_normal.png"));
            } else {
                NewIsmSplitPaneDivider.this.leftBtn.setIcon(ResourceManager.getImage("deviceFigure_leftArrow_normal.png"));
            }
        }
    }

    private static class DividerButton
    extends JButton {
        private static final long serialVersionUID = 1188423916025904692L;
        private NewIsmSplitPaneDivider divider;

        public DividerButton(NewIsmSplitPaneDivider divider) {
            this.divider = divider;
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics, int ww, int hh) {
            ImageIcon icon = (ImageIcon)this.getIcon();
            graphics.drawImage(icon.getImage(), ww, hh, icon.getIconWidth(), icon.getIconHeight(), this.divider);
        }

        @Override
        public void paint(Graphics g) {
            LOGGER.info("The method is null");
        }
    }
}

