/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorScrollButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class ArmorScrollBarUI
extends MetalScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new ArmorScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setBlockIncrement(58);
        this.scrollbar.setUnitIncrement(29);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new ArmorScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new ArmorScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle thumbBounds) {
        boolean isHorizontal = this.scrollbar.getOrientation() == 0;
        graphics.translate((int)thumbBounds.getX(), (int)thumbBounds.getY());
        graphics.setColor(UIManager.getColor("ScrollBar.thumbHighlight"));
        graphics.drawLine(0, 0, thumbBounds.width - 1, 0);
        graphics.drawLine(0, 1, 0, thumbBounds.height - 2);
        graphics.setColor(this.thumbLightShadowColor);
        if (!jComponent.isEnabled()) {
            graphics.setColor(UIManager.getColor("IsmScrollBar.thumbBorderDisableColor"));
        }
        if (isHorizontal) {
            graphics.drawLine(thumbBounds.width - 1, 0, thumbBounds.width - 1, thumbBounds.height - 1);
        } else {
            graphics.drawLine(0, thumbBounds.height - 1, thumbBounds.width, thumbBounds.height - 1);
        }
        if (!jComponent.isEnabled()) {
            graphics.setColor(UIManager.getColor("ScrollBar.thumb"));
            graphics.fillRect(1, 1, thumbBounds.width - 2, thumbBounds.height - 2);
        } else if (this.isDragging) {
            IsmPlafUtils.drawGradient((Component)jComponent, graphics, "IsmScrollBar.selectedGradient", new Rectangle(1, 1, thumbBounds.width - 2, thumbBounds.height - 2), isHorizontal);
        } else if (this.isThumbRollover()) {
            IsmPlafUtils.drawGradient((Component)jComponent, graphics, "IsmScrollBar.rolloverGradient", new Rectangle(1, 1, thumbBounds.width - 2, thumbBounds.height - 2), isHorizontal);
        } else {
            graphics.setColor(UIManager.getColor("ScrollBar.thumb"));
            graphics.fillRect(1, 1, thumbBounds.width - 2, thumbBounds.height - 2);
        }
        graphics.translate(-((int)thumbBounds.getX()), -((int)thumbBounds.getY()));
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle trackBounds) {
        graphics.setColor(new Color(0xD2D2D3));
        graphics.fillRect((int)trackBounds.getX(), (int)trackBounds.getY(), trackBounds.width, trackBounds.height);
    }
}

