/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArmorTabbedPaneUI.class);
    private static final int MIN_TABHEADER_WIDTH = 50;
    private static final int TAB_TEXT_HEIGHT = 29;
    private static final int TABHEADER_HEIGHT = 37;
    private static Set<KeyStroke> managingFocusForwardTraversalKeys1;
    private static Set<KeyStroke> managingFocusBackwardTraversalKeys1;

    public ArmorTabbedPaneUI() {
        this.maxTabHeight = 37;
    }

    public static ComponentUI createUI(JComponent c) {
        return new ArmorTabbedPaneUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabInsets = new Insets(0, 10, 0, 10);
        this.tabAreaInsets = new Insets(0, 0, 0, 0);
        Class<ArmorTabbedPaneUI> clazz = ArmorTabbedPaneUI.class;
        synchronized (ArmorTabbedPaneUI.class) {
            if (managingFocusForwardTraversalKeys1 == null) {
                managingFocusForwardTraversalKeys1 = new HashSet<KeyStroke>(0);
                managingFocusForwardTraversalKeys1.add(KeyStroke.getKeyStroke(9, 0));
            }
            if (managingFocusBackwardTraversalKeys1 == null) {
                managingFocusBackwardTraversalKeys1 = new HashSet<KeyStroke>(0);
                managingFocusBackwardTraversalKeys1.add(KeyStroke.getKeyStroke(9, 1));
            }
            this.tabPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys1);
            this.tabPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return 37;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return 37;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int calculateTabWidth = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return Math.max(calculateTabWidth, 50);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return -4;
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldRolloverTab = this.getRolloverTab();
        super.setRolloverTab(index);
        Rectangle r1 = null;
        Rectangle r2 = null;
        if (oldRolloverTab >= 0 && oldRolloverTab < this.tabPane.getTabCount()) {
            r1 = this.getTabBounds(this.tabPane, oldRolloverTab);
        }
        if (index >= 0) {
            r2 = this.getTabBounds(this.tabPane, index);
        }
        if (null != r1) {
            if (null != r2) {
                this.tabPane.repaint(r1.union(r2));
            } else {
                this.tabPane.repaint(r1);
            }
        } else if (null != r2) {
            this.tabPane.repaint(r2);
        }
    }

    @Override
    protected void paintContentBorder(Graphics grap, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int left = insets.left;
        int top = insets.top;
        int ww = width - insets.right - insets.left;
        int hh = height - insets.top - insets.bottom;
        if (this.tabPane.getTabCount() == 0) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            grap.setColor(color);
            grap.fillRect(left, top, ww, hh);
        }
        super.paintContentBorder(grap, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics grap, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        grap.setColor(this.lightHighlight);
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 2 || selectedIndex < 0 || (int)selRect.getX() + selRect.width + 1 < xx || (int)selRect.getY() < yy || (int)selRect.getY() > yy + hh) {
            grap.drawLine(xx, yy, xx, yy + hh - 2);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 1 || selectedIndex < 0 || (int)selRect.getY() + selRect.height + 1 < yy || (int)selRect.getX() < xx || (int)selRect.getX() > xx + ww) {
            graphics.drawLine(xx, yy, xx + ww - 2, yy);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 3 || selectedIndex < 0 || (int)selRect.getY() - 1 > hh || (int)selRect.getX() < xx || (int)selRect.getX() > xx + ww) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(xx, yy + hh - 1, xx + ww - 1, yy + hh - 1);
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect;
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 4 || selectedIndex < 0 || (int)selRect.getX() - 1 > ww || (int)selRect.getY() < yy || (int)selRect.getY() > yy + hh) {
            graphics.setColor(this.lightHighlight);
            graphics.drawLine(xx + ww - 1, yy, xx + ww - 1, yy + hh - 1);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabArea(Graphics graphics, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        Insets insets = this.tabPane.getInsets();
        int left = insets.left;
        int top = insets.top;
        int ww = width - insets.right - insets.left;
        graphics.setColor(UIManager.getColor("TabbedPane.background"));
        graphics.fillRect(left, top, ww, 29);
        Icon icon = UIManager.getIcon("TabbedPaneUI.tabBottomIcon");
        if (icon instanceof ImageIcon) {
            graphics.drawImage(((ImageIcon)icon).getImage(), left, top + 29, ww, icon.getIconHeight(), null);
        }
        super.paintTabArea(graphics, tabPlacement, selectedIndex);
        if (-1 != selectedIndex) {
            graphics.setColor(UIManager.getColor("TabbedPane.highlight"));
            Rectangle rect = this.getTabBounds(this.tabPane, selectedIndex);
            graphics.drawLine(left, top, left + ww - 1, top);
            graphics.drawLine(left, top + 1, left, top + rect.height);
            graphics.drawLine(left + ww - 1, top + 1, left + ww - 1, top + rect.height);
        }
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int tabPlacement, int tabIndex, int xxx, int yy, int ww, int hh, boolean isSelected) {
        if (1 != tabPlacement || -1 == tabIndex) {
            return;
        }
        if (isSelected || this.getRolloverTab() == tabIndex) {
            graphics.setColor(Color.WHITE);
            if (tabIndex == 0) {
                graphics.fillRect(xxx + 1, yy + 1, ww - 1, 28);
            } else {
                graphics.fillRect(xxx, yy + 1, ww, 28);
            }
            Icon icon = UIManager.getIcon("TabbedPaneUI.selectedArrowIcon");
            if (icon instanceof ImageIcon) {
                graphics.drawImage(((ImageIcon)icon).getImage(), xxx + (ww - icon.getIconWidth()) / 2, yy + 29, this.tabPane);
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics grap, int tabPlacement, int tabIdx, int xx, int yy, int ww, int hh, boolean isSelected) {
        if (tabPlacement != 1) {
            super.paintTabBorder(grap, tabPlacement, tabIdx, xx, yy, ww, hh, isSelected);
        } else if (tabIdx + 1 < this.rects.length) {
            grap.setColor(UIManager.getColor("TabbedPane.highlight"));
            grap.drawLine(xx + ww - 1, yy, xx + ww - 1, yy + 29);
        }
    }

    @Override
    protected void paintText(Graphics grap, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        boolean isRolloverTab = tabIndex == this.getRolloverTab();
        Font actualFont = font;
        FontMetrics actualMetrics = metrics;
        if (isSelected || isRolloverTab) {
            actualFont = UIManager.getFont("TabbedPane.selectedFont");
            actualMetrics = SwingUIUtil.getFontMetrics(this.tabPane, grap, actualFont);
        }
        grap.setFont(actualFont);
        View textViewForTab = this.getTextViewForTab(tabIndex);
        if (textViewForTab != null) {
            textViewForTab.paint(grap, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if ((isSelected || isRolloverTab) && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                grap.setColor(fg);
                SwingUIUtil.drawStringUnderlineCharAt(this.tabPane, grap, title, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + actualMetrics.getAscent());
            } else {
                grap.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                SwingUIUtil.drawStringUnderlineCharAt(this.tabPane, grap, title, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + actualMetrics.getAscent());
                grap.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                SwingUIUtil.drawStringUnderlineCharAt(this.tabPane, grap, title, mnemIndex, (int)textRect.getX() - 1, (int)textRect.getY() + actualMetrics.getAscent() - 1);
            }
        }
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String titleStr, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        FontMetrics actualMetrics = metrics;
        if (isSelected || tabIndex == this.getRolloverTab()) {
            Font font = UIManager.getFont("TabbedPane.selectedFont");
            actualMetrics = SwingUIUtil.getFontMetrics(this.tabPane, this.tabPane.getGraphics(), font);
        }
        super.layoutLabel(tabPlacement, actualMetrics, tabIndex, titleStr, icon, tabRect, iconRect, textRect, isSelected);
    }
}

