/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmMenuItemUI;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class UnifyMenuItemUI
extends IsmMenuItemUI {
    private static final int MENU_ITEM_HEIGHT = 30;

    public static ComponentUI createUI(JComponent c) {
        return new UnifyMenuItemUI();
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem menuItem1, Color bgColor) {
        int menuWidth = menuItem1.getWidth();
        int menuHeight = menuItem1.getHeight();
        ButtonModel model = menuItem1.getModel();
        Insets margin1 = menuItem1.getMargin();
        if (model.isArmed() || menuItem1 instanceof JMenu && model.isSelected()) {
            graphics.setColor(UIManager.getColor("IsmTopMenu.selectedColor"));
            graphics.fillRect(margin1.left, margin1.top, menuWidth - margin1.left - margin1.right, menuHeight - margin1.top - margin1.bottom);
        } else {
            graphics.setColor(IsmPlafUtils.modifyAlpha(UIManager.getColor("MenuItem.background"), 80));
            graphics.fillRect(margin1.left, margin1.top, menuWidth - margin1.left - margin1.right, menuHeight - margin1.top - margin1.bottom);
        }
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = SwingUIUtil.getFontMetrics(menuItem, graphics);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        super.paintText(graphics, menuItem, textRect, text);
        if (menuItem.isEnabled()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                graphics.setColor(this.selectionForeground);
            } else {
                graphics.setColor(UIManager.getColor("MenuItem.foreground"));
            }
            SwingUIUtil.drawStringUnderlineCharAt(menuItem, graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
        }
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension preferredMenuItemSize = super.getPreferredMenuItemSize(jComponent, checkIcon, arrowIcon, defaultTextIconGap);
        preferredMenuItemSize.height = 30;
        return preferredMenuItemSize;
    }
}

