/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmMenuUI;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class UnifyMenuUI
extends IsmMenuUI {
    private static final int MENU_ITEM_HEIGHT = 30;

    public static ComponentUI createUI(JComponent c) {
        return new UnifyMenuUI();
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        if (!model.isEnabled() || !(menuItem instanceof JMenu)) {
            return;
        }
        int menuW = menuItem.getWidth();
        int menuH = menuItem.getHeight();
        JMenu menu = (JMenu)menuItem;
        Insets margin = this.getMenuItemMargin(menuItem, model, menu);
        int xx = margin.left;
        int top = margin.top;
        int ww = menuW - margin.left - margin.right;
        int hh = menuH - margin.top - margin.bottom;
        if (menu.isTopLevelMenu()) {
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("ArmorToolBarButton.style");
            Color borderColor = style.getBorderColor(IsmButtonStyle.ButtonState.NORMAL);
            if (model.isRollover()) {
                IsmPlafUtils.drawBorderStyle(graphics, borderColor, borderColor, new Rectangle(xx, top, ww, hh), true);
                graphics.setColor(UIManager.getColor("IsmTopMenu.rolloverBackground"));
                graphics.fillRect(xx + 1, top + 1, ww - 2, hh - 2);
            } else if (model.isArmed() || model.isSelected()) {
                graphics.setColor(borderColor);
                graphics.fillRect(xx + 2, top, ww - 4, 1);
                graphics.fillRect(xx, top + 2, 1, hh - 1);
                graphics.fillRect(xx + ww - 1, top + 2, 1, hh - 1);
                graphics.fillRect(xx, top + 1, 2, 1);
                graphics.fillRect(xx + 1, top, 1, 2);
                graphics.fillRect(xx + ww - 2, top + 1, 2, 1);
                graphics.fillRect(xx + ww - 2, top, 1, 2);
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setColor(IsmPlafUtils.mixAlpha(UIManager.getColor("MenuItem.background"), UIManager.getInt("PopupMenu.alpha")));
                g2d.fillRect(xx + 2, top + 1, ww - 4, 1);
                g2d.fillRect(xx + 1, top + 2, 1, hh - 1);
                g2d.fillRect(xx + ww - 2, top + 2, 1, hh - 1);
                g2d.fillRect(xx + 2, top + 2, ww - 4, hh - 1);
            }
        } else {
            graphics.setColor(UIManager.getColor("MenuItem.background"));
            graphics.fillRect(0, 0, menuW, menuH);
            if (model.isArmed() || model.isSelected() || model.isPressed() || model.isRollover()) {
                graphics.setColor(UIManager.getColor("IsmTopMenu.selectedColor"));
                graphics.fillRect(0, 0, menuW, menuH);
            }
        }
    }

    private Insets getMenuItemMargin(JMenuItem menuItem, ButtonModel model, JMenu menu) {
        Insets margin = menuItem.getMargin();
        if (menu.isTopLevelMenu()) {
            if (model.isRollover()) {
                margin = UIManager.getInsets("IsmTopMenu.rolloverInset");
            } else if (model.isArmed() || model.isSelected()) {
                margin = UIManager.getInsets("IsmMenu.SelectedInsets");
            }
        }
        return margin;
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = IsmPlafUtils.getFontMetrics(menuItem, graphics);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            super.paintText(graphics, menuItem, textRect, text);
            return;
        }
        if (menuItem instanceof JMenu && !((JMenu)menuItem).isTopLevelMenu()) {
            graphics.setColor(UIManager.getColor("MenuItem.foreground"));
        }
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected() || model.isRollover()) {
            graphics.setColor(this.selectionForeground);
        }
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu() && menuItem.isSelected()) {
            graphics.setColor(UIManager.getColor("MenuItem.foreground"));
        }
        SwingUIUtil.drawStringUnderlineCharAt(menuItem, graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenu menu;
        Dimension preferredMenuItemSize = super.getPreferredMenuItemSize(jComponent, checkIcon, arrowIcon, defaultTextIconGap);
        if (jComponent instanceof JMenu && !(menu = (JMenu)jComponent).isTopLevelMenu()) {
            preferredMenuItemSize.height = 30;
        }
        return preferredMenuItemSize;
    }
}

