/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.plaf.armor.ArmorBorders;
import com.huawei.ism.ui.swing.plaf.armor.ArmorLookAndFeel;
import com.huawei.ism.ui.swing.plaf.unify.UnifyLookAndFeel;
import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import com.huawei.ism.ui.swing.table.MutliHyperLink;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.slf4j.Logger;

public class IsmTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(IsmTable.class);
    private int curRolloverRow = -1;
    private int curRolloverColumn = -1;
    private boolean structureAdjusting;
    private static final Comparator<?> ISMTABLE_COMPARATOR = new ComparableComparator();

    public IsmTable(TableModel model) {
        this(model, false);
    }

    public IsmTable(TableModel model, boolean isSimpleTable) {
        super(model);
        if (!isSimpleTable) {
            this.addMouseMotionListener(new TableMouseMotion());
            this.addMouseListener(new TableMouse());
            this.initTableProperties();
            this.getSelectionModel().setSelectionMode(0);
        }
        this.addKeyListener(new IsmTableKeyListener());
        IsmTableRowSorter sorter = new IsmTableRowSorter(this.dataModel);
        this.setRowSorter(sorter);
        sorter.setSortsOnUpdates(true);
        this.setRowHeight(UIManager.getInt("IsmTable.rowHeight"));
        this.setFillsViewportHeight(true);
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof ArmorLookAndFeel || laf instanceof UnifyLookAndFeel) {
            this.setShowVerticalLines(false);
            this.setIntercellSpacing(new Dimension(0, 1));
        }
        this.fitTableColumns(this);
    }

    @Override
    public boolean isCellEditable(int rowInt, int colInt) {
        Object value = this.getValueAt(rowInt, colInt);
        if (value instanceof MutliHyperLink) {
            return true;
        }
        return super.isCellEditable(rowInt, colInt);
    }

    public void fitTableColumns(JTable myTable) {
        JTableHeader header = myTable.getTableHeader();
        if (null == header) {
            return;
        }
        Enumeration<TableColumn> columns = myTable.getColumnModel().getColumns();
        if (null == columns) {
            return;
        }
        TableColumn column = null;
        int col = 0;
        Component tableCellRendererComponent = null;
        int colPrefWidth = 0;
        int colWidth = 0;
        while (columns.hasMoreElements()) {
            column = columns.nextElement();
            col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            tableCellRendererComponent = myTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(myTable, column.getIdentifier(), false, false, -1, col);
            if (null == tableCellRendererComponent) {
                throw new NullPointerException();
            }
            colPrefWidth = (int)tableCellRendererComponent.getPreferredSize().getWidth();
            if (colPrefWidth <= (colWidth = column.getWidth())) continue;
            column.setPreferredWidth(colPrefWidth);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    protected void fireFilterChanged() {
    }

    protected void initTableProperties() {
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        IsmTableCellRenderer tooltipRender = new IsmTableCellRenderer();
        for (int i = 0; i < columnCount; ++i) {
            columnModel.getColumn(i).setCellRenderer(tooltipRender);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        Object cell = this.getValueAt(row, col);
        if (cell instanceof IsmTableCell) {
            return ((IsmTableCell)cell).getRender();
        }
        return super.getCellRenderer(row, col);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        Object cell = this.getValueAt(row, col);
        TableCellEditor editor = null;
        if (cell instanceof IsmTableCell) {
            editor = ((IsmTableCell)cell).getEditor();
        }
        if (cell instanceof MutliHyperLink) {
            return ((MutliHyperLink)cell).getMutliHyperLinkCellEditor();
        }
        if (null == editor) {
            return super.getCellEditor(row, col);
        }
        return editor;
    }

    public void setModel(IsmAbstractTableModel dataModel) {
        super.setModel(dataModel);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.initTableProperties();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTableHeader().setEnabled(enabled);
        this.getTableHeader().repaint();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        JTableHeader tableHeader = super.createDefaultTableHeader();
        int headerHeight = UIManager.getInt("IsmTableHeader.rowHeight");
        tableHeader.setPreferredSize(new Dimension(headerHeight, headerHeight));
        return tableHeader;
    }

    public List<TableRow> getMarkedRows() {
        int[] selectedRowIndics = this.getSelectedRows();
        ArrayList<TableRow> rows = new ArrayList<TableRow>(selectedRowIndics.length);
        TableModel model = this.getModel();
        if (model instanceof IsmAbstractTableModel) {
            IsmAbstractTableModel ismAbstractTableModel = (IsmAbstractTableModel)model;
            TableRow row = null;
            for (int selectedRowIndic : selectedRowIndics) {
                row = ismAbstractTableModel.getRow(this.convertRowIndexToModel(selectedRowIndic));
                rows.add(row);
            }
        }
        return rows;
    }

    public TableRow getMarkedRow() {
        TableRow tableRow = null;
        int index = super.getSelectedRow();
        if (index < 0) {
            return tableRow;
        }
        TableModel model = this.getModel();
        if (model instanceof IsmAbstractTableModel) {
            IsmAbstractTableModel tableModel = (IsmAbstractTableModel)model;
            int modelIndex = this.convertRowIndexToModel(index);
            tableRow = tableModel.getRow(modelIndex);
        }
        return tableRow;
    }

    public List<TableRow> getAllRows() {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(0);
        TableModel model = this.getModel();
        if (model instanceof IsmAbstractTableModel) {
            IsmAbstractTableModel ismAbstractTableModel = (IsmAbstractTableModel)model;
            tableRows.addAll(ismAbstractTableModel.getAllRows());
        }
        return tableRows;
    }

    public void markTableRow(TableRow ... tableRows) {
        TableModel model = this.getModel();
        if (null == tableRows || !(model instanceof IsmAbstractTableModel)) {
            return;
        }
        IsmAbstractTableModel tableModel = (IsmAbstractTableModel)model;
        int modelIdx = 0;
        int viewIdx = 0;
        ArrayList<Integer> viewIndexList = new ArrayList<Integer>();
        for (TableRow row : tableRows) {
            modelIdx = tableModel.getRowIndex(row.getIdentifier());
            if (-1 == modelIdx || -1 == (viewIdx = this.convertRowIndexToView(modelIdx))) continue;
            viewIndexList.add(viewIdx);
        }
        if (viewIndexList.isEmpty()) {
            return;
        }
        IsmTable.getStartAndIndexList(viewIndexList).forEach(start2EndIndex -> this.addRowSelectionInterval(start2EndIndex[0], start2EndIndex[1]));
    }

    private static List<Integer[]> getStartAndIndexList(List<Integer> indexList) {
        int startIndex = indexList.get(0);
        ArrayList<Integer[]> ret = new ArrayList<Integer[]>();
        for (int index = 1; index < indexList.size(); ++index) {
            if (indexList.get(index) - indexList.get(index - 1) == 1) continue;
            ret.add(new Integer[]{startIndex, indexList.get(index - 1)});
            startIndex = indexList.get(index);
        }
        ret.add(new Integer[]{startIndex, indexList.get(indexList.size() - 1)});
        return ret;
    }

    public void markTableRows(Object ... rowIdentifiers) {
        TableModel model = this.getModel();
        if (!(model instanceof IsmAbstractTableModel)) {
            return;
        }
        IsmAbstractTableModel ismTableMode = (IsmAbstractTableModel)model;
        ArrayList rows = new ArrayList(0);
        TableRow<?, ?> tableRow = null;
        for (Object object : rowIdentifiers) {
            tableRow = ismTableMode.getTableRowBy(object);
            if (null == tableRow) continue;
            rows.add(tableRow);
        }
        this.markTableRow(rows.toArray(new TableRow[rows.size()]));
    }

    public void selectFirstRow() {
        if (this.getRowCount() > 0) {
            this.addRowSelectionInterval(0, 0);
        }
    }

    public void unmarkTableRow(TableRow ... tableRows) {
        TableModel model = this.getModel();
        if (null == tableRows || !(model instanceof IsmAbstractTableModel)) {
            return;
        }
        IsmAbstractTableModel tableModel = (IsmAbstractTableModel)model;
        int modelIndex = 0;
        int viewIndex = 0;
        ArrayList<Integer> viewIndexList = new ArrayList<Integer>();
        for (TableRow row : tableRows) {
            modelIndex = tableModel.getRowIndex(row.getIdentifier());
            if (-1 == modelIndex || -1 == (viewIndex = this.convertRowIndexToView(modelIndex))) continue;
            viewIndexList.add(viewIndex);
        }
        if (viewIndexList.isEmpty()) {
            return;
        }
        IsmTable.getStartAndIndexList(viewIndexList).forEach(start2EndIndex -> this.removeRowSelectionInterval(start2EndIndex[0], start2EndIndex[1]));
    }

    public void unmarkTableRows(Object ... rowIdentifiers) {
        TableModel model = this.getModel();
        if (!(model instanceof IsmAbstractTableModel)) {
            return;
        }
        IsmAbstractTableModel ismTableMode = (IsmAbstractTableModel)model;
        ArrayList tableRows = new ArrayList(0);
        TableRow<?, ?> tableRow = null;
        for (Object object : rowIdentifiers) {
            tableRow = ismTableMode.getTableRowBy(object);
            if (null == tableRow) continue;
            tableRows.add(tableRow);
        }
        this.unmarkTableRow(tableRows.toArray(new TableRow[tableRows.size()]));
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int rowIndex = this.rowAtPoint(event.getPoint());
        if (rowIndex < 0) {
            return null;
        }
        String tooltip = super.getToolTipText(event);
        if (null == tooltip) {
            return null;
        }
        if ((rowIndex + 1) % 2 == 0) {
            tooltip = tooltip + ' ';
        }
        return tooltip;
    }

    final void adjustStructure(boolean adjusting) {
        this.structureAdjusting = adjusting;
    }

    public final boolean isStructureChanged() {
        return this.structureAdjusting;
    }

    public void setCurRolloverRow(int tableCurRolloverRow) {
        this.curRolloverRow = tableCurRolloverRow;
    }

    public int getCurRolloverRow() {
        return this.curRolloverRow;
    }

    public void setCurRolloverColumn(int tableCurRolloverColumn) {
        this.curRolloverColumn = tableCurRolloverColumn;
    }

    public int getCurRolloverColumn() {
        return this.curRolloverColumn;
    }

    public void unableSorter() {
        this.setRowSorter(null);
    }

    public void setTableHeader(JLabel label, int herderIdx) {
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn column = columnModel.getColumn(herderIdx);
        JComponentTableCellRenderer renderer = new JComponentTableCellRenderer();
        label.setFont(new Font(label.getFont().getName(), 1, label.getFont().getSize()));
        column.setHeaderRenderer(renderer);
        column.setHeaderValue(label);
        Border bor = ArmorBorders.getTableHeaderBorder(new Insets(0, 4, 0, 0));
        label.setBorder(bor);
    }

    public class JComponentTableCellRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }

    private class TableMouse
    extends MouseAdapter {
        private TableMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (IsmTable.this.getCurRolloverRow() < 0 || IsmTable.this.getCurRolloverColumn() < 0) {
                return;
            }
            Object cell = IsmTable.this.getValueAt(IsmTable.this.getCurRolloverRow(), IsmTable.this.getCurRolloverColumn());
            if (cell instanceof IsmTableCell) {
                ActionListener action = ((IsmTableCell)cell).getAction();
                Rectangle rect = IsmTable.this.getCellRect(IsmTable.this.getCurRolloverRow(), IsmTable.this.getCurRolloverColumn(), true);
                if (null != action && ((IsmTableCell)cell).isMouseInBounds(e, rect)) {
                    ActionEvent actionEvent = new ActionEvent(IsmTable.this, 0, null);
                    action.actionPerformed(actionEvent);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IsmTable.this.setCurRolloverRow(-1);
            IsmTable.this.setCurRolloverColumn(-1);
            IsmTable.this.repaint();
        }
    }

    private class TableMouseMotion
    extends MouseAdapter {
        private TableMouseMotion() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int tableCurRolloverColumn;
            int tableCurRolloverRow = IsmTable.this.rowAtPoint(e.getPoint());
            if (tableCurRolloverRow != IsmTable.this.getCurRolloverRow()) {
                IsmTable.this.setCurRolloverRow(tableCurRolloverRow);
                IsmTable.this.repaint();
            }
            if ((tableCurRolloverColumn = IsmTable.this.columnAtPoint(e.getPoint())) != IsmTable.this.getCurRolloverColumn()) {
                IsmTable.this.setCurRolloverColumn(tableCurRolloverColumn);
                IsmTable.this.repaint();
            }
            if (tableCurRolloverRow < 0 || IsmTable.this.getCurRolloverColumn() < 0) {
                return;
            }
            Object cell = IsmTable.this.getValueAt(tableCurRolloverRow, IsmTable.this.getCurRolloverColumn());
            boolean isActionValid = false;
            Rectangle rect = IsmTable.this.getCellRect(tableCurRolloverRow, tableCurRolloverColumn, true);
            if (cell instanceof IsmTableCell) {
                IsmTableCell ismTableCell = (IsmTableCell)cell;
                boolean flag = ismTableCell.isMouseInBounds(e, rect);
                isActionValid = null != ismTableCell.getAction() && flag;
            }
            IsmTable.this.setCursor(new Cursor(isActionValid ? 12 : 0));
        }
    }

    private final class IsmTableRowSorter
    extends TableRowSorter<TableModel> {
        private IsmTableRowSorter(TableModel model) {
            super(model);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            return ISMTABLE_COMPARATOR;
        }

        @Override
        public void setRowFilter(RowFilter<? super TableModel, ? super Integer> filter) {
            super.setRowFilter(filter);
            IsmTable.this.fireFilterChanged();
        }

        @Override
        public void toggleSortOrder(int column) {
            try {
                int[] selRows = IsmTable.this.getSelectedRows();
                for (int i = 0; i < selRows.length; ++i) {
                    selRows[i] = IsmTable.this.convertRowIndexToModel(selRows[i]);
                }
                IsmTable.this.clearSelection();
                super.toggleSortOrder(column);
                int startIndex = -1;
                int endIndex = -1;
                for (int i = 0; i < selRows.length; ++i) {
                    selRows[i] = IsmTable.this.convertRowIndexToView(selRows[i]);
                }
                Arrays.sort(selRows);
                int rowIndexToView = 0;
                for (int i = 0; i < selRows.length; ++i) {
                    rowIndexToView = selRows[i];
                    if (rowIndexToView < 0) continue;
                    if (startIndex == -1) {
                        startIndex = rowIndexToView;
                        endIndex = rowIndexToView;
                        continue;
                    }
                    if (rowIndexToView - 1 == endIndex) {
                        endIndex = rowIndexToView;
                        continue;
                    }
                    IsmTable.this.addRowSelectionInterval(startIndex, endIndex);
                    startIndex = rowIndexToView;
                    endIndex = rowIndexToView;
                }
                if (startIndex != -1 && endIndex != -1) {
                    IsmTable.this.addRowSelectionInterval(startIndex, endIndex);
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to SortOrder. ", (Throwable)e);
            }
        }
    }

    private static class ComparableComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -5317298981889001720L;
        private static final String IP_VERSION_REGEX = "^(\\d+\\.)*\\d+$";

        private ComparableComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.getClass().equals(o2.getClass())) {
                return this.compareSameClassObjects(o1, o2);
            }
            return o1.toString().compareTo(o2.toString());
        }

        private int compareSameClassObjects(Object o1, Object o2) {
            if (o1.toString().matches(IP_VERSION_REGEX) && o2.toString().matches(IP_VERSION_REGEX)) {
                return this.compareIpOrVersionNumbers(o1.toString(), o2.toString());
            }
            return ((Comparable)o1).compareTo(o2);
        }

        private int compareIpOrVersionNumbers(String s1, String s2) {
            String[] parts1 = s1.split("\\.");
            String[] parts2 = s2.split("\\.");
            for (int i = 0; i < Math.min(parts1.length, parts2.length); ++i) {
                int comparison = Integer.parseInt(parts1[i]) - Integer.parseInt(parts2[i]);
                if (comparison == 0) continue;
                return comparison;
            }
            return parts1.length - parts2.length;
        }
    }

    private static final class IsmTableKeyListener
    extends KeyAdapter {
        private IsmTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                IsmTable ismTable = (IsmTable)e.getSource();
                ismTable.transferFocus();
                e.consume();
            }
        }
    }
}

