/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.forms.help.HelpKeyGetter;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.ui.module.command.CommandUtils;
import com.huawei.ism.ui.swing.control.RefreshButton;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.IsmVirtualTable;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableCountPane;
import com.huawei.ism.ui.swing.table.VirtualTableScrollPane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableScrollPane
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableScrollPane.class);
    private static final long serialVersionUID = 1L;
    private static final Color COUNT_AREA_BG = new Color(0xDDDDDD);
    private KeywordFilterField filterFiled = null;
    private JPanel filterAreaPane = null;
    private IsmTableScrollPane tablePane = null;
    private TableCountPane countPane = null;
    private Box buttonPane = Box.createHorizontalBox();
    private RefreshButton refreshButton;
    private JPanel northPane;

    public TableScrollPane(IsmTable table) {
        this(table, true, false);
    }

    public TableScrollPane(IsmTable table, boolean showFilter, boolean multiSelection) {
        this(table, true, showFilter, multiSelection);
    }

    public TableScrollPane(boolean multiSelection, boolean needBtnArea, IsmTable table) {
        this(table, multiSelection, CountArea.TABLE_LEFT_UP, FilterArea.TABLE_RIGHT_UP, ButtonArea.TABLE_LEFT_UP);
    }

    public TableScrollPane(IsmTable table, boolean showCount, boolean showFilter, boolean multiSelection) {
        this(table, multiSelection, CountArea.TABLE_LEFT_UP, FilterArea.TABLE_RIGHT_UP, ButtonArea.NONE);
    }

    public TableScrollPane(IsmTable table, boolean multiSelection, TableCountPane countPane) {
        this.countPane = countPane;
        JPanel tableAndCountPane = UCD.createTransparentPane(new BorderLayout());
        this.initTablePane(table, multiSelection, false, tableAndCountPane);
        this.initCountPane(table, CountArea.TABLE_LEFT_UP, ButtonArea.NONE, tableAndCountPane);
        this.initFilterArea(table, FilterArea.TABLE_RIGHT_UP);
        this.initLayOut(tableAndCountPane);
    }

    public TableScrollPane(boolean showCount, boolean showFilter, boolean multiSelection, IsmTable table) {
        this(table, multiSelection, showCount ? CountArea.TABLE_LEFT_UP : CountArea.NONE, showFilter ? FilterArea.TABLE_RIGHT_UP : FilterArea.NONE, ButtonArea.NONE);
    }

    @Deprecated
    public TableScrollPane(IsmTable table, boolean enableColumnSel) {
        this(table, false, enableColumnSel, false);
    }

    @Deprecated
    public TableScrollPane(IsmTable table, boolean enableColumnSel, boolean showFilter, boolean multiSelection, boolean showCount) {
        this(table, false, enableColumnSel, true);
    }

    TableScrollPane(IsmTable table, boolean multiSelection, CountArea countPos, FilterArea filterArea, ButtonArea btnPos) {
        this(table, multiSelection, countPos, filterArea, btnPos, false);
    }

    private TableScrollPane(IsmTable table, boolean multiSelection, CountArea countPos, FilterArea filterArea, ButtonArea btnPos, boolean isVirtual) {
        JPanel tableAndCountPane = UCD.createTransparentPane(new BorderLayout());
        this.initTablePane(table, multiSelection, isVirtual, tableAndCountPane);
        this.initCountPane(table, countPos, btnPos, tableAndCountPane);
        this.initFilterArea(table, filterArea);
        this.initLayOut(tableAndCountPane);
    }

    private TableScrollPane(IsmTable table, boolean multiSelection, boolean isVirtual, ListSelectionListener listSelectionListener) {
        CountArea countPos = CountArea.TABLE_LEFT_DOWN;
        FilterArea filterArea = FilterArea.TABLE_RIGHT_UP;
        ButtonArea btnPos = ButtonArea.TABLE_LEFT_UP;
        JPanel tableAndCountPane = UCD.createTransparentPane(new BorderLayout());
        this.initTablePane(table, multiSelection, isVirtual, tableAndCountPane);
        this.initCountPane(table, countPos, btnPos, tableAndCountPane);
        this.initFilterArea(table, filterArea, listSelectionListener);
        this.initLayOut(tableAndCountPane);
    }

    private void initLayOut(JPanel tableAndCountPane) {
        if (IsmPlafUtils.isUnifyStyle()) {
            this.tablePane.setBorder(BorderFactory.createEmptyBorder());
            tableAndCountPane.setBorder(UnifyBorders.getScrollPaneBorder());
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPane, "North");
        this.add((Component)tableAndCountPane, "Center");
        this.setOpaque(false);
        this.setCompName();
    }

    private void initTablePane(IsmTable table, boolean multiSelection, boolean isVirtual, JPanel tableAndCountPane) {
        this.tablePane = isVirtual ? new VirtualTableScrollPane(CommonUtil.convertObject(table, IsmVirtualTable.class), multiSelection) : new IsmTableScrollPane(table, multiSelection);
        tableAndCountPane.add((Component)this.tablePane, "Center");
    }

    private void initCountPane(IsmTable table, CountArea countPos, ButtonArea btnPos, JPanel tableAndCountPane) {
        ButtonArea actualBtnPos = this.changeNullProperties(btnPos);
        CountArea actualCountPos = this.changeNullProperties(countPos);
        this.northPane = UCD.createBoxLayoutPane(0);
        JPanel southPane = new JPanel();
        southPane.setLayout(new BoxLayout(southPane, 0));
        if (this.countPane == null) {
            this.countPane = new TableCountPane(table);
        }
        switch (actualCountPos) {
            case TABLE_LEFT_UP: {
                this.northPane.add(this.countPane);
                this.northPane.add(Box.createHorizontalStrut(12));
                this.northPane.add(Box.createRigidArea(new Dimension(0, 25)));
                break;
            }
            case TABLE_LEFT_DOWN: {
                southPane.add(this.countPane);
                southPane.add(Box.createHorizontalStrut(10));
                southPane.add(Box.createRigidArea(new Dimension(0, 21)));
                southPane.add(Box.createHorizontalGlue());
                southPane.setBackground(COUNT_AREA_BG);
                break;
            }
        }
        switch (actualBtnPos) {
            case TABLE_LEFT_UP: {
                this.northPane.add(this.buttonPane);
                break;
            }
            case TABLE_RIGHT_DOWN: {
                southPane.add(this.buttonPane);
                southPane.add(Box.createHorizontalStrut(2));
                break;
            }
        }
        tableAndCountPane.add((Component)southPane, "South");
    }

    private void initFilterArea(IsmTable table, FilterArea filterArea) {
        if (this.changeNullProperties(filterArea) != FilterArea.NONE) {
            this.filterAreaPane = UCD.createBoxLayoutPane(0);
            this.filterFiled = new KeywordFilterField(table);
            this.filterAreaPane.add(this.filterFiled);
            this.northPane.add(Box.createRigidArea(new Dimension(0, 33)));
            this.northPane.add(Box.createHorizontalGlue());
            this.northPane.add(this.filterAreaPane);
            this.northPane.add(Box.createHorizontalStrut(2));
        }
    }

    private void initFilterArea(IsmTable table, FilterArea filterArea, ListSelectionListener listSelectionListener) {
        FilterArea filter = this.changeNullProperties(filterArea);
        if (filter != FilterArea.NONE) {
            this.filterAreaPane = UCD.createBoxLayoutPane(0);
            this.filterFiled = new KeywordFilterField(table, listSelectionListener);
            this.filterAreaPane.add(this.filterFiled);
            this.northPane.add(Box.createRigidArea(new Dimension(0, 33)));
            this.northPane.add(Box.createHorizontalGlue());
            this.northPane.add(this.filterAreaPane);
            this.northPane.add(Box.createHorizontalStrut(2));
        }
    }

    public void addCompToNorthPane(JComponent comp) {
        if (this.northPane != null) {
            this.northPane.remove(0);
            this.northPane.add((Component)comp, 0);
        }
    }

    public void addSelCountToNorthPane() {
        if (this.northPane != null) {
            this.northPane.remove(0);
            this.northPane.add((Component)this.countPane, 0);
        }
    }

    public void disableTableExceptColumns(int[] exceptColumns) {
        if (this.tablePane != null) {
            this.tablePane.disableTableExceptColumns(exceptColumns);
        }
    }

    private FilterArea changeNullProperties(FilterArea filterArea) {
        if (null == filterArea) {
            return FilterArea.NONE;
        }
        return filterArea;
    }

    private CountArea changeNullProperties(CountArea countPos) {
        if (null == countPos) {
            return CountArea.NONE;
        }
        return countPos;
    }

    private ButtonArea changeNullProperties(ButtonArea btnPos) {
        if (null == btnPos) {
            return ButtonArea.NONE;
        }
        return btnPos;
    }

    public void setCompName() {
        if (this.filterFiled != null) {
            this.filterFiled.setName("_KeywordFilterField_filterFiled");
        }
    }

    @Deprecated
    public void setViewportView(IsmTable table) {
        this.tablePane.setViewportView(table);
        this.tablePane.initMultiSelection();
    }

    public void setTablePane(IsmTableScrollPane tablePane) {
        this.tablePane = tablePane;
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.tablePane.setVerticalScrollBarPolicy(policy);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tablePane.setEnabled(enabled);
        if (null != this.filterFiled) {
            this.filterFiled.setEnabled(enabled);
        }
    }

    public void setKeyword(String keyword) {
        if (null != this.filterFiled) {
            this.filterFiled.setKeyword(keyword);
        }
    }

    public void addComponent2ButtonArea(JComponent ... components) {
        for (JComponent component : components) {
            this.buttonPane.add(component);
            this.buttonPane.add(Box.createHorizontalStrut(8));
        }
    }

    public void addComponent2CheckBoxArea(int horizontalStrutWidth, JComponent ... components) {
        this.buttonPane.add(Box.createHorizontalStrut(horizontalStrutWidth));
        for (JComponent component : components) {
            this.buttonPane.add(component);
            this.buttonPane.add(Box.createHorizontalStrut(8));
        }
    }

    public static TableScrollPane createTablePane(IsmTable table, boolean multSelection, CountArea countArea, FilterArea filterArea, ButtonArea buttonArea) {
        return new TableScrollPane(table, multSelection, countArea, filterArea, buttonArea);
    }

    public static TableScrollPane createTablePane(IsmTable table, boolean multSelection) {
        return new TableScrollPane(table, multSelection, CountArea.TABLE_LEFT_DOWN, FilterArea.TABLE_RIGHT_UP, ButtonArea.TABLE_LEFT_UP);
    }

    public static TableScrollPane createTablePane(IsmTable table, boolean multSelection, ListSelectionListener selectListener) {
        return new TableScrollPane(table, multSelection, false, selectListener);
    }

    public static TableScrollPane createTablePaneWithOutFilter(IsmTable table, boolean multSelection) {
        return new TableScrollPane(table, multSelection, CountArea.TABLE_LEFT_UP, FilterArea.NONE, ButtonArea.NONE);
    }

    public static TableScrollPane createTablePaneForDialog(IsmTable table, boolean multSelection, FilterArea filterArea) {
        return new TableScrollPane(table, multSelection, CountArea.TABLE_LEFT_DOWN, filterArea, ButtonArea.TABLE_RIGHT_DOWN);
    }

    @Deprecated
    public void addRefreshButton(Command command) {
        Assert.notNull(command);
        JButton button = UCD.createIconButton("table_refresh.png");
        button.addActionListener(new MyTbFreshListner(command, button));
        this.filterAreaPane.add(Box.createHorizontalStrut(15));
        this.filterAreaPane.add(button);
    }

    public void addRefreshButton2(Command command) {
        Assert.notNull(command);
        this.refreshButton = new RefreshButton(new RefreshAction(command));
        this.refreshButton.setNormalIcon();
        this.filterAreaPane.add(Box.createHorizontalStrut(15));
        this.filterAreaPane.add(this.refreshButton);
    }

    public void addHelpButton(HelpKeyGetter keyGetter) {
        Assert.notNull(keyGetter);
        JButton button = UCD.createIconButton("table_help.png");
        HelpManager.getInstance().linkHelp((AbstractButton)button, keyGetter);
        this.filterAreaPane.add(Box.createHorizontalStrut(4));
        this.filterAreaPane.add(button);
    }

    public void updateRowCount() {
    }

    public KeywordFilterField getFilterFiled() {
        return this.filterFiled;
    }

    public void setFilterFiled(KeywordFilterField filterFiled) {
        this.filterFiled = filterFiled;
    }

    public static TableScrollPane createVirtualTablePane(IsmVirtualTable table, boolean multSelection) {
        return new TableScrollPane(table, multSelection, CountArea.TABLE_LEFT_DOWN, FilterArea.TABLE_RIGHT_UP, ButtonArea.TABLE_LEFT_UP, true);
    }

    public RefreshButton getRefreshButton() {
        return this.refreshButton;
    }

    public TableCountPane getCountPane() {
        return this.countPane;
    }

    public void setCountPane(TableCountPane countPane) {
        this.countPane = countPane;
    }

    public IsmTableScrollPane getTablePane() {
        return this.tablePane;
    }

    private final class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1553117073035761984L;
        private Command command;

        public RefreshAction(Command command) {
            this.command = command;
        }

        @Override
        public void actionPerformed(final ActionEvent actionEvent) {
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean result = RefreshAction.this.command.execute();
                    if (CommandExcutor.CommandState.FAILED == RefreshAction.this.command.getCommandState()) {
                        RefreshAction.this.showErrorDialog(actionEvent);
                    } else {
                        Launcher launcher = LauncherManager.getInstance().getActivedLauncher();
                        TimeZone zone = launcher == null ? TimeZone.getDefault() : launcher.getDeviceTimeZone();
                        String dateNowStr = TimeUtil.gmtToString(new Date().getTime(), zone);
                        String head = ResourceManager.getStringWithColon("LAST_REFRESH_TIME") + " ";
                        TableScrollPane.this.refreshButton.setToolTipText(head + dateNowStr);
                    }
                    TableScrollPane.this.refreshButton.setNormalIcon();
                    return result;
                }
            };
            AsyncExcutor.submit(task);
            TableScrollPane.this.refreshButton.setLoadingIcon();
        }

        private void showErrorDialog(final ActionEvent actionEvent) {
            SwingUtil.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    Window parent = SwingUtilities.getWindowAncestor((Component)actionEvent.getSource());
                    DialogUtils.showErrorDialog(parent, RefreshAction.this.command.getResult());
                }
            });
        }
    }

    public static enum FilterArea {
        NONE,
        TABLE_RIGHT_UP;

    }

    public static enum CountArea {
        NONE,
        TABLE_LEFT_UP,
        TABLE_LEFT_DOWN;

    }

    public static enum ButtonArea {
        NONE,
        TABLE_LEFT_UP,
        TABLE_RIGHT_DOWN;

    }

    private static final class MyTbFreshListner
    implements ActionListener {
        private final Command command;
        private final JButton button;

        private MyTbFreshListner(Command command, JButton button) {
            this.command = command;
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Window parent = SwingUtilities.getWindowAncestor((Component)actionEvent.getSource());
            List<Callable<Boolean>> tasks = CommandUtils.getAsyncTasksWith(Arrays.asList(this.command));
            AsyncExcutor.execute(parent, tasks.toArray(new Callable[tasks.size()]));
            if (CommandExcutor.CommandState.FAILED == this.command.getCommandState()) {
                DialogUtils.showErrorDialog(parent, this.command.getResult());
            } else {
                Launcher launcher = LauncherManager.getInstance().getActivedLauncher();
                if (launcher == null) {
                    LOGGER.error("laucher is null. ");
                    return;
                }
                String dateNowStr = TimeUtil.gmtToString(new Date().getTime(), launcher.getDeviceTimeZone());
                String head = ResourceManager.getStringWithColon("LAST_REFRESH_TIME") + " ";
                this.button.setToolTipText(head + dateNowStr);
            }
        }
    }
}

