/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text.validator;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import java.text.MessageFormat;

public class LengthRangeInputValidator
implements InputValidator {
    private static final long serialVersionUID = 1979991850414551598L;
    private String validatetipPattern = null;
    private String tooltipPattern = null;
    private long min = 0L;
    private long max = 0L;

    public LengthRangeInputValidator(long minLen, long maxLen) {
        this.min = minLen;
        this.max = maxLen;
        if (minLen == maxLen) {
            this.tooltipPattern = ResourceManager.getString("textfield.length.equal.tooltip");
            this.validatetipPattern = ResourceManager.getString("textfield.length.equal.validatetip");
        } else if (maxLen >= Integer.MAX_VALUE) {
            this.tooltipPattern = ResourceManager.getString("textfield.length.morethan.tooltip");
            this.validatetipPattern = ResourceManager.getString("textfield.length.morethan.validatetip");
        } else if (this.min <= Long.MIN_VALUE) {
            this.tooltipPattern = ResourceManager.getString("textfield.length.lessthan.tooltipt");
            this.validatetipPattern = ResourceManager.getString("textfield.length.lessthan.validatetip");
        } else {
            this.tooltipPattern = ResourceManager.getString("textfield.length.range.tooltip");
            this.validatetipPattern = ResourceManager.getString("textfield.length.range.validatetip");
        }
    }

    @Override
    public String validateInput(String input, String inputValueName) {
        if ((long)input.length() <= this.max && (long)input.length() >= this.min) {
            return null;
        }
        if (this.min == this.max) {
            return MessageFormat.format(this.validatetipPattern, inputValueName, this.max);
        }
        if (this.max >= Integer.MAX_VALUE) {
            return MessageFormat.format(this.validatetipPattern, inputValueName, this.min);
        }
        if (this.min <= Long.MIN_VALUE) {
            return MessageFormat.format(this.validatetipPattern, inputValueName, this.max);
        }
        return MessageFormat.format(this.validatetipPattern, inputValueName, this.min, this.max);
    }

    @Override
    public String getToolTip() {
        if (this.min == this.max) {
            return MessageFormat.format(this.tooltipPattern, this.max);
        }
        if (this.max >= Integer.MAX_VALUE) {
            return MessageFormat.format(this.tooltipPattern, this.min);
        }
        if (this.min <= Long.MIN_VALUE) {
            return MessageFormat.format(this.tooltipPattern, this.max);
        }
        return MessageFormat.format(this.tooltipPattern, this.min, this.max);
    }
}

