/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.help.HelpKeyGetter;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.swing.dialog.RegisterDialog;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class IsmDialog
extends RegisterDialog {
    private static final long serialVersionUID = 1L;
    private JPanel dialogContentPane = new JPanel(new BorderLayout());
    private Box southBox = Box.createHorizontalBox();
    private Map<ECommonButton, JButton> btnMap = new EnumMap<ECommonButton, JButton>(ECommonButton.class);
    private List<IsmTextField> needValidateTextField = new ArrayList<IsmTextField>(0);

    public IsmDialog(Window parent) {
        super(parent);
        this.initLayout();
    }

    public IsmDialog(Window parent, String title, ECommonButton ... buttons) {
        super(parent, title);
        this.initLayout();
        this.customBtnPane(buttons);
    }

    private void initLayout() {
        int margin = 8;
        Box navigationBar = Box.createHorizontalBox();
        navigationBar.add(Box.createRigidArea(new Dimension(margin, 20)));
        navigationBar.add(Box.createGlue());
        navigationBar.add(this.southBox);
        navigationBar.add(Box.createHorizontalStrut(margin));
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new MyCustoJseparator();
        }
        Box dialogSouthBox = Box.createVerticalBox();
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        innerBox.add(Box.createVerticalStrut(margin));
        innerBox.add(navigationBar);
        innerBox.add(Box.createVerticalStrut(margin));
        innerBox.setOpaque(true);
        innerBox.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        dialogSouthBox.add(innerBox);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            JPanel panel = new JPanel();
            panel.add(Box.createVerticalStrut(4));
            panel.setPreferredSize(new Dimension(panel.getPreferredSize().width, 4));
            panel.setBackground(new Color(0xD9D9D9));
            dialogSouthBox.add(panel);
        }
        this.add((Component)this.dialogContentPane, "Center");
        this.add((Component)dialogSouthBox, "South");
        this.setDefaultCloseOperation(2);
    }

    private void customBtnPane(ECommonButton ... buttons) {
        ECommonButton[] defaultBtnE;
        ECommonButton[] validButtons = buttons;
        if (null == validButtons || validButtons.length == 0) {
            validButtons = new ECommonButton[]{ECommonButton.Confirm, ECommonButton.Apply, ECommonButton.Cancel, ECommonButton.Help};
        }
        ArrayList<JButton> sameBtns = new ArrayList<JButton>(0);
        JButton helpBtn = null;
        JButton button = null;
        for (ECommonButton buttonE : validButtons) {
            button = UCD.createButton(buttonE.getBtnText(), buttonE.getMnemonic());
            button.addActionListener(new ButtonAction(buttonE));
            this.btnMap.put(buttonE, button);
            if (buttonE == ECommonButton.Help) {
                helpBtn = button;
                continue;
            }
            sameBtns.add(button);
        }
        JComponent btnBox = null;
        if (null != helpBtn) {
            this.linkHelpButton(helpBtn);
            btnBox = UCD.buildButtonBox(sameBtns.toArray(new JButton[sameBtns.size()]), {helpBtn});
        } else {
            btnBox = UCD.buildButtonBox(new JButton[][]{sameBtns.toArray(new JButton[sameBtns.size()])});
        }
        this.southBox.add(UCD.buildHBoxRight(btnBox));
        JRootPane rootPane = this.getRootPane();
        for (ECommonButton buttonE : defaultBtnE = new ECommonButton[]{ECommonButton.Confirm, ECommonButton.Apply, ECommonButton.Close}) {
            button = this.getButtonBy(buttonE);
            if (null == button) continue;
            rootPane.setDefaultButton(button);
            break;
        }
    }

    private void linkHelpButton(JButton helpBtn) {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.linkHelp((AbstractButton)helpBtn, new HelpKeyGetter(){

            @Override
            public String getHelpKey() {
                return IsmDialog.this.getHelpKey();
            }
        });
    }

    public void setButtonState(ECommonButton button, boolean status) {
        this.btnMap.get((Object)button).setEnabled(status);
    }

    public JButton getButtonBy(ECommonButton button) {
        return this.btnMap.get((Object)button);
    }

    protected final void beforeShow() {
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.pack();
        this.toFront();
    }

    @Override
    public void setVisible(boolean bool) {
        if (bool) {
            SwingUtil.putParentCenter(this, this.getOwner());
            SwingUtil.setName(this);
        }
        super.setVisible(bool);
    }

    protected void doConfirmTask() {
    }

    protected void doApplyTask() {
    }

    protected void doCloseTask() {
        this.setVisible(false);
        this.dispose();
    }

    protected String getHelpKey() {
        return "default";
    }

    public void addContentPane(Component contentPane) {
        this.dialogContentPane.add(contentPane);
    }

    public void addNeedValidateTextField(IsmTextField textFiled) {
        this.needValidateTextField.add(textFiled);
    }

    public void removeValidateTextField(IsmTextField textFiled) {
        this.needValidateTextField.remove(textFiled);
    }

    public void disposeOnException() {
        this.dispose();
    }

    @Override
    public void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent(window);
    }

    private boolean isValidateInput() {
        if (this.isNeedValidateInput()) {
            if (IsmPlafUtils.isUnifyStyle()) {
                return SwingUtil.validateInput(this.needValidateTextField);
            }
            return SwingUtil.validateInput(this.needValidateTextField, this);
        }
        return true;
    }

    protected boolean isNeedValidateInput() {
        return true;
    }

    private void requestDefaultFocus(JButton button) {
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(button);
    }

    public void setDialogContentPane(JPanel contentPane) {
        this.dialogContentPane = contentPane;
    }

    public JPanel getDialogContentPane() {
        return this.dialogContentPane;
    }

    public void setSouthBox(Box dialogSouthBox) {
        this.southBox = dialogSouthBox;
    }

    public Box getSouthBox() {
        return this.southBox;
    }

    private final class ButtonAction
    implements ActionListener {
        private ECommonButton eCommonButton = null;

        public ButtonAction(ECommonButton button) {
            this.eCommonButton = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.eCommonButton) {
                case Confirm: {
                    if (!IsmDialog.this.isValidateInput()) break;
                    IsmDialog.this.doConfirmTask();
                    break;
                }
                case Apply: {
                    IsmDialog.this.requestDefaultFocus(null);
                    if (IsmDialog.this.isValidateInput()) {
                        IsmDialog.this.doApplyTask();
                    }
                    IsmDialog.this.requestDefaultFocus((JButton)IsmDialog.this.btnMap.get((Object)ECommonButton.Confirm));
                    break;
                }
                case Cancel: 
                case Close: {
                    IsmDialog.this.doCloseTask();
                    break;
                }
                case Help: {
                    break;
                }
            }
        }
    }

    public static enum ECommonButton {
        Confirm('O'),
        Apply('A'),
        Cancel('C'),
        Close('L'),
        Help('H'),
        Save('S');

        private char mnemonic;

        private ECommonButton(char mnemonicChar) {
            this.mnemonic = mnemonicChar;
        }

        public char getMnemonic() {
            return this.mnemonic;
        }

        public String getBtnText() {
            String prefix = "COMMON.TXT.";
            return ResourceManager.getString(prefix + this.name().toUpperCase(ResourceManager.getLocale()), this.name());
        }
    }

    private static final class MyCustoJseparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        private MyCustoJseparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

