/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public final class TableMenuHandler {
    public static void popMenu(MouseEvent mouseEvent, Collection<PropertyPaneAction> currentActions) {
        IsmTable table = (IsmTable)mouseEvent.getSource();
        if (!table.isEnabled()) {
            return;
        }
        int rowIndex = table.rowAtPoint(mouseEvent.getPoint());
        if (rowIndex >= 0 && SwingUtilities.isRightMouseButton(mouseEvent)) {
            mouseEvent.consume();
            if (!table.getSelectionModel().isSelectedIndex(rowIndex)) {
                table.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
            }
            DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
            int[] selectedRowIndics = table.getSelectedRows();
            ArrayList<Object> rowData = new ArrayList<Object>(0);
            TableRow row = null;
            for (int selectedRowIndic : selectedRowIndics) {
                row = tableModel.getRow(table.convertRowIndexToModel(selectedRowIndic));
                rowData.add(row.getUserObject());
            }
            List<JComponent> menuItems = TableMenuHandler.createMenuItems(rowData, currentActions);
            if (menuItems.isEmpty()) {
                return;
            }
            JPopupMenu menu = new JPopupMenu();
            for (JComponent menuItem : menuItems) {
                menu.add(menuItem);
            }
            menu.show(table, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static List<JComponent> createMenuItems(List<Object> rowData, Collection<PropertyPaneAction> currentActions) {
        LinkedList<JComponent> menuItems = new LinkedList<JComponent>();
        ArrayList<PropertyPaneAction> validActions = new ArrayList<PropertyPaneAction>(0);
        for (PropertyPaneAction action : currentActions) {
            if (!action.menuInfoWithDefault().isValid()) continue;
            validActions.add(action);
        }
        String groupName = null;
        String subMenuName = null;
        JMenu subMenu = null;
        for (PropertyPaneAction action : currentActions) {
            if (!action.menuInfoWithDefault().isValid() || !validActions.contains(action)) continue;
            groupName = action.menuInfoWithDefault().getMenuGroupName();
            subMenuName = action.menuInfoWithDefault().getSubMenuName();
            if (null != subMenuName) {
                subMenu = TableMenuHandler.getSubMenu(rowData, currentActions, validActions, subMenuName);
                subMenu.setSize(subMenu.getPreferredSize().width, 25);
                menuItems.add(subMenu);
                continue;
            }
            if (null != groupName) {
                TableMenuHandler.getGroupMenuItem(rowData, currentActions, menuItems, validActions, groupName);
                continue;
            }
            validActions.remove(action);
            PropertyPaneAction clonedAction = (PropertyPaneAction)action.clone();
            String menuItemName = clonedAction.menuInfoWithDefault().getMenuName();
            if (null != menuItemName) {
                clonedAction.setName(menuItemName);
            }
            clonedAction.setUserObject(rowData);
            clonedAction.update();
            JMenuItem menuItem = new JMenuItem(clonedAction);
            menuItem.setPreferredSize(new Dimension(menuItem.getPreferredSize().width, 25));
            menuItems.add(new JMenuItem(clonedAction));
        }
        return menuItems;
    }

    private static void getGroupMenuItem(List<Object> rowData, Collection<PropertyPaneAction> currentActions, List<JComponent> menuItems, List<PropertyPaneAction> validActions, String groupName) {
        if (!menuItems.isEmpty() && menuItems instanceof LinkedList && !(((LinkedList)menuItems).getLast() instanceof JSeparator)) {
            menuItems.add(new JPopupMenu.Separator());
        }
        List<PropertyPaneAction> groupMenuActions = TableMenuHandler.getActionByGroupName(groupName, currentActions);
        PropertyPaneAction clonedGroupMenuAction = null;
        String menuItemName = null;
        JMenuItem menuitem = null;
        for (PropertyPaneAction groupMenuAction : groupMenuActions) {
            validActions.remove(groupMenuAction);
            clonedGroupMenuAction = (PropertyPaneAction)groupMenuAction.clone();
            menuItemName = clonedGroupMenuAction.menuInfoWithDefault().getMenuName();
            if (null != menuItemName) {
                clonedGroupMenuAction.setName(menuItemName);
            }
            clonedGroupMenuAction.setUserObject(rowData);
            clonedGroupMenuAction.update();
            menuitem = new JMenuItem(clonedGroupMenuAction);
            menuitem.setPreferredSize(new Dimension(menuitem.getPreferredSize().width, 25));
            menuItems.add(menuitem);
        }
        if (!validActions.isEmpty()) {
            menuItems.add(new JPopupMenu.Separator());
        }
    }

    private static JMenu getSubMenu(List<Object> rowData, Collection<PropertyPaneAction> currentActions, List<PropertyPaneAction> validActions, String subMenuName) {
        JMenu subMenu = new JMenu(subMenuName + "     ");
        subMenu.setPreferredSize(new Dimension(subMenu.getPreferredSize().width, 25));
        List<PropertyPaneAction> subMenuActions = TableMenuHandler.getActionBySubMenuName(subMenuName, currentActions);
        PropertyPaneAction clonedSubMenuAction = null;
        String menuItemName = null;
        for (PropertyPaneAction subMenuAction : subMenuActions) {
            validActions.remove(subMenuAction);
            clonedSubMenuAction = (PropertyPaneAction)subMenuAction.clone();
            menuItemName = clonedSubMenuAction.menuInfoWithDefault().getMenuName();
            if (null != menuItemName) {
                clonedSubMenuAction.setName(menuItemName);
            }
            clonedSubMenuAction.setUserObject(rowData);
            clonedSubMenuAction.update();
            subMenu.add(clonedSubMenuAction);
        }
        return subMenu;
    }

    private static List<PropertyPaneAction> getActionByGroupName(String groupName, Collection<PropertyPaneAction> currentActions) {
        ArrayList<PropertyPaneAction> actions = new ArrayList<PropertyPaneAction>(0);
        String tmpGroupName = null;
        for (PropertyPaneAction action : currentActions) {
            tmpGroupName = action.menuInfoWithDefault().getMenuGroupName();
            if (!action.menuInfoWithDefault().isValid() || null == tmpGroupName || !tmpGroupName.equals(groupName)) continue;
            actions.add(action);
        }
        return actions;
    }

    private static List<PropertyPaneAction> getActionBySubMenuName(String subMenuName, Collection<PropertyPaneAction> currentActions) {
        ArrayList<PropertyPaneAction> actions = new ArrayList<PropertyPaneAction>(0);
        String tmpSubMenuName = null;
        for (PropertyPaneAction action : currentActions) {
            tmpSubMenuName = action.menuInfoWithDefault().getSubMenuName();
            if (!action.menuInfoWithDefault().isValid() || null == tmpSubMenuName || !tmpSubMenuName.equals(subMenuName)) continue;
            actions.add(action);
        }
        return actions;
    }
}

