/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.settingpane;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandUtils;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.ui.templets.ValueChangeHandler;
import com.huawei.ism.ui.templets.settingpane.SettingsRightPane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.ValueMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplySettingsRightPane<T extends JComponent, M>
extends SettingsRightPane<T, M>
implements ValueChangeHandler.IValueChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplySettingsRightPane.class);
    private ValueMonitor valueMonitor = new ValueMonitor();
    private ValueChangeHandler handler = new ValueChangeHandler();
    private List<JComponent> needCheckComponents = new ArrayList<JComponent>(0);
    private boolean valueChangeEnable = true;
    private Map<IsmDialog.ECommonButton, JButton> btnMap = new EnumMap<IsmDialog.ECommonButton, JButton>(IsmDialog.ECommonButton.class);

    public ApplySettingsRightPane(boolean batchCommands) {
        this.doInitTask(batchCommands);
    }

    public ApplySettingsRightPane(boolean batchCommands, String deviceID) {
        super(deviceID);
        this.doInitTask(batchCommands);
    }

    private void doInitTask(boolean batchCommands) {
        this.installButtons();
        this.handler.addValueChangeListener(this);
        this.setButtonState(IsmDialog.ECommonButton.Save, false);
        this.setButtonState(IsmDialog.ECommonButton.Cancel, false);
        if (batchCommands) {
            LOGGER.info("command will be execute by batch mode.");
        } else {
            LOGGER.info("command will be execute by single mode.");
        }
    }

    protected abstract List<Command> getCommands();

    protected abstract boolean passPreCheck();

    public void setButtonState(IsmDialog.ECommonButton button, boolean status) {
        this.btnMap.get((Object)button).setEnabled(status);
    }

    public JButton getButton(IsmDialog.ECommonButton button) {
        return this.btnMap.get((Object)button);
    }

    @Override
    boolean onInitCommand() {
        this.valueMonitor.removeAllCheckpoints();
        return super.onInitCommand();
    }

    public void removeAllCheckpoints() {
        this.valueMonitor.removeAllCheckpoints();
    }

    @Override
    protected void afterShow() {
        this.getRootPane().setDefaultButton(this.btnMap.get((Object)IsmDialog.ECommonButton.Save));
    }

    protected final void monitorEventSource(JComponent eventSource, ValueMonitor.IValueParser<JComponent, ?> parser) {
        Assert.notNull(eventSource);
        this.valueMonitor.addCheckpoint(eventSource, parser);
        this.handler.addEventSource(eventSource);
    }

    protected final void monitorEventSource(JComponent ... eventSources) {
        Assert.notNull(eventSources);
        for (JComponent source : eventSources) {
            this.handler.addEventSource(source);
            this.valueMonitor.addCheckpoint(source);
        }
    }

    @Override
    public void valueChanged() {
        boolean changed = this.isChanged();
        this.setButtonState(IsmDialog.ECommonButton.Save, changed);
        this.setButtonState(IsmDialog.ECommonButton.Cancel, changed);
        for (JComponent component : this.needCheckComponents) {
            component.setEnabled(this.valueChangeEnable && !changed);
        }
    }

    public final void flushValue() {
        this.valueMonitor.flushValue();
    }

    @Override
    protected boolean isChanged() {
        return this.valueMonitor.isValueChanged();
    }

    protected final void doApplyTask() {
        if (!this.passPreCheck()) {
            return;
        }
        boolean succeeded = this.doSendTask();
        if (succeeded) {
            this.setButtonState(IsmDialog.ECommonButton.Save, false);
            this.setButtonState(IsmDialog.ECommonButton.Cancel, false);
            this.valueMonitor.flushValue();
            this.refreshMemo(this.createMemo());
        }
    }

    protected boolean doSendTask() {
        List<Command> commands = this.getCommands();
        if (null == commands || commands.isEmpty()) {
            return false;
        }
        AsyncExcutor.execute(this.getParentWindow(), commands.toArray(new Command[commands.size()]));
        return CommandUtils.isSucceededWith(commands);
    }

    private void installButtons() {
        IsmDialog.ECommonButton[] buttons = new IsmDialog.ECommonButton[]{IsmDialog.ECommonButton.Save, IsmDialog.ECommonButton.Cancel};
        JButton button = null;
        for (IsmDialog.ECommonButton buttonE : buttons) {
            button = UCD.createButton(buttonE.getBtnText(), buttonE.getMnemonic());
            button.addActionListener(new ButtonAction(buttonE));
            this.btnMap.put(buttonE, button);
            this.addButton(button);
        }
    }

    public void clearNeedCheckComponents() {
        this.needCheckComponents.clear();
    }

    public void addNeedCheckComponents(JComponent component) {
        this.needCheckComponents.add(component);
    }

    public void setValueChangeEnable(boolean changeEnable) {
        this.valueChangeEnable = changeEnable;
    }

    private final class ButtonAction
    implements ActionListener {
        private IsmDialog.ECommonButton button = null;

        public ButtonAction(IsmDialog.ECommonButton button) {
            Assert.notNull((Object)button);
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.button == IsmDialog.ECommonButton.Save) {
                ApplySettingsRightPane.this.doApplyTask();
            } else if (this.button == IsmDialog.ECommonButton.Cancel) {
                boolean confirm = ConfirmDialog.showDialog(ApplySettingsRightPane.this.getParentWindow(), ConfirmDialog.Level.INFO, ResourceManager.getString("SETTINGSPANE.CHANGE.LEAVEOFF_DESC"), ResourceManager.getString("SETTINGSPANE.CANCEL.RESULT"), "", "", "");
                if (!confirm) {
                    return;
                }
                ApplySettingsRightPane.this.doCancelTask();
            }
        }
    }
}

