/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.settingpane;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.templets.settingpane.SettingsPane;
import com.huawei.ism.ui.templets.settingpane.SettingsRightPane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

class NavigationLabel
extends JPanel
implements MouseListener {
    private static final int COLUMN_MARGIN = 10;
    private static final int ROW_MARGIN = 10;
    private static final long serialVersionUID = 1509950008789836846L;
    private static final int NAVIGATION_LABEL_HEIGHT = 34;
    private static final ImageIcon LEFT_ICON = ResourceManager.getImage("settings_nav_leftbg.png");
    private static final ImageIcon CENTER_ICON = ResourceManager.getImage("settings_nav_centerbg.png");
    private static final ImageIcon RIGHT_ICON = ResourceManager.getImage("settings_nav_rightbg.png");
    private transient SettingsPane.SettingItem settingItem;
    private boolean rollover = false;
    private boolean selected = false;
    private JLabel arrowIconLabel;
    private JLabel nameLabel;

    public NavigationLabel(SettingsPane.SettingItem settingItem) {
        Assert.notNull(settingItem);
        this.settingItem = settingItem;
        this.nameLabel = new JLabel(settingItem.getName());
        this.nameLabel.setFont(IsmFontFactory.getBold13Font());
        this.arrowIconLabel = new JLabel();
        JPanel contentPane = UCD.createTransparentPane(new BorderLayout(10, 10));
        contentPane.add((Component)this.nameLabel, "West");
        contentPane.add((Component)this.arrowIconLabel, "East");
        contentPane.setBorder(new EmptyBorder(0, 15, 0, 20));
        this.setLayout(new BorderLayout());
        this.add((Component)contentPane, "Center");
        this.setOpaque(false);
        UCD.setJComponentSize(this, new Dimension(this.getPreferredSize().width, 34));
        this.addMouseListener(this);
    }

    public SettingsPane.SettingItem getSettingItem() {
        return this.settingItem;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        SettingsPane settingsPane = (SettingsPane)SwingUtilities.getAncestorOfClass(SettingsPane.class, this);
        SettingsPane.SettingItem oldSettingItem = settingsPane.getCurrentSettingItem();
        if (oldSettingItem == this.getSettingItem()) {
            return;
        }
        Window parent = SwingUtilities.getWindowAncestor(this);
        SettingsRightPane oldRightPane = oldSettingItem.getContentPane();
        if (oldRightPane.isChanged()) {
            boolean confirm = ConfirmDialog.showDialog(parent, ConfirmDialog.Level.INFO, ResourceManager.getString("SETTINGSPANE.CHANGE.LEAVEOFF_DESC"), ResourceManager.getString("SETTINGSPANE.CHANGE.LEAVEOFF_RESULT"), "", "");
            if (!confirm) {
                return;
            }
            oldRightPane.doCancelTask();
        }
        settingsPane.aboutToShow(this.getSettingItem());
        settingsPane.updateNavigation();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setRollover(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
        this.setRollover(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setSelected(boolean selected) {
        if (this.isRollover()) {
            this.setRollover(false);
        }
        this.selected = selected;
        this.setStyle(selected);
        this.repaint();
    }

    private void setStyle(boolean selectedOrRollover) {
        if (selectedOrRollover) {
            this.arrowIconLabel.setIcon(UIManager.getIcon("navigation.arrow.orienteast"));
            this.nameLabel.setForeground(UIManager.getColor("IsmOEMTheme.renderColor"));
        } else {
            this.arrowIconLabel.setIcon(null);
            this.nameLabel.setForeground(UIManager.getColor("TableHeader.foreground"));
        }
    }

    private void setRollover(boolean isRollover) {
        if (this.isSelected()) {
            return;
        }
        this.rollover = isRollover;
        this.setStyle(isRollover);
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isRollover() || this.isSelected()) {
            int width = this.getWidth();
            graphics.drawImage(LEFT_ICON.getImage(), 0, 0, LEFT_ICON.getIconWidth(), LEFT_ICON.getIconHeight(), this);
            graphics.drawImage(CENTER_ICON.getImage(), LEFT_ICON.getIconWidth(), 0, width - LEFT_ICON.getIconWidth() - LEFT_ICON.getIconWidth(), CENTER_ICON.getIconHeight(), this);
            graphics.drawImage(RIGHT_ICON.getImage(), width - RIGHT_ICON.getIconWidth(), 0, RIGHT_ICON.getIconWidth(), RIGHT_ICON.getIconHeight(), this);
            return;
        }
        super.paintComponent(graphics);
    }
}

