/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.templets.wizard.Card;
import com.huawei.ism.ui.templets.wizard.DefaultFinishedCard;
import com.huawei.ism.ui.templets.wizard.WizardHandler;
import com.huawei.ism.ui.templets.wizard.WizardModel;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public final class Wizard
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 847520613043597065L;
    private CardLayout cardLayout;
    private NavigationBar buttonPane;
    private transient WizardHandler wizardHandler;
    private transient WizardModel wizardModel;
    private transient Icon cardHeadIcon;
    private String successResultText = "";
    private String failureResultText = "";
    private String finishCardHelpKey;
    private transient Runnable exceptionTask;
    private JPanel cardContentPane;
    private CardHeadPane cardHeadPane;
    private String wizardTitle;
    private boolean showFinishedCard = true;

    public Wizard(Window parent, String title, Icon icon) {
        super(parent);
        this.wizardTitle = title;
        this.cardHeadIcon = icon;
        this.wizardHandler = new WizardHandler(this);
        this.wizardModel = new WizardModel();
        this.wizardModel.addPropertyChangeListener(this);
        this.doLayoutUI();
    }

    public String getWizardTitle() {
        return this.wizardTitle;
    }

    public boolean isShowFinishedCard() {
        return this.showFinishedCard;
    }

    private void doLayoutUI() {
        this.cardLayout = new CardLayout();
        this.cardContentPane = new JPanel(this.cardLayout);
        this.cardContentPane.setBackground(Color.WHITE);
        this.cardContentPane.setBorder(UCD.createEmptyBorder());
        this.cardHeadPane = new CardHeadPane();
        this.buttonPane = new NavigationBar(this.wizardHandler);
        JPanel topPane = new JPanel(new BorderLayout());
        topPane.setBackground(Color.WHITE);
        topPane.add((Component)this.cardHeadPane, "Center");
        topPane.add((Component)new ImgsAssembledPane.HorizonalSeparator(ResourceManager.getImage("wizard_separator_left.png"), ResourceManager.getImage("wizard_separator_center.png"), ResourceManager.getImage("wizard_separator_right.png")), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)topPane, "North");
        this.add((Component)this.cardContentPane, "Center");
        this.add((Component)this.buttonPane, "South");
        this.setBackground(Color.WHITE);
    }

    public void showWizard(int width, int height) {
        this.beforeShow();
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(new Dimension(width, height));
        this.setVisible(true);
    }

    public void showWizard() {
        this.showWizard(true);
    }

    public void showWizard(boolean showNoShow) {
        this.beforeShow();
        this.pack();
        this.setVisible(showNoShow);
    }

    @Override
    public void setVisible(boolean VisiNoVisi) {
        SwingUtil.putParentCenter(this, this.getOwner());
        SwingUtil.setName(this);
        super.setVisible(VisiNoVisi);
    }

    public void setHelpKeyForFinishCard(String helpKey) {
        this.finishCardHelpKey = helpKey;
    }

    public void hideFinishCard() {
        this.showFinishedCard = false;
    }

    public void setSuccessResultText(String text) {
        this.successResultText = text;
    }

    public void setFailureResultText(String text) {
        this.failureResultText = text;
    }

    private void beforeShow() {
        Card card;
        Card finishCard = this.wizardModel.getCardBy(Card.StepID.FinishedCard);
        if (null == finishCard) {
            card = new DefaultFinishedCard();
            ((DefaultFinishedCard)card).setSuccessResultText(this.successResultText);
            ((DefaultFinishedCard)card).setFailureResultText(this.failureResultText);
            ((DefaultFinishedCard)card).setHelpKey(this.finishCardHelpKey);
            this.addCard(Card.StepID.FinishedCard, card);
        }
        if (null == (card = this.wizardModel.getCardBy(Card.StepID.FirstCard)) || !card.onInitCommand()) {
            return;
        }
        this.setCurrentCard(Card.StepID.FirstCard);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void setButtonEnable(EWizardButton buttonE, boolean enable) {
        Card currentCard = this.wizardModel.getCurrentCard();
        JButton button = this.buttonPane.getButtonBy(currentCard.getCurrentStepID(), buttonE);
        if (null != button) {
            button.setEnabled(enable);
        }
    }

    public void addCard(Card.StepID stepID, Card card) {
        card.setCurrentStepID(stepID);
        this.cardContentPane.add((Component)card.getCardView(), stepID.name());
        card.setWizard(this);
        this.wizardModel.addCard(stepID, card);
    }

    public void removeCard(Card.StepID stepID, Card card) {
        this.cardContentPane.remove(card.getCardView());
        this.wizardModel.removeCard(stepID);
    }

    public void updateCardView(Card.StepID stepID, JPanel cardView) {
        this.cardContentPane.add((Component)cardView, stepID.name());
    }

    void setCurrentCard(Card.StepID stepID) {
        if (null == stepID) {
            return;
        }
        this.wizardModel.setCurrentCard(stepID);
        this.cardLayout.show(this.cardContentPane, stepID.name());
        this.wizardModel.getCurrentCard().showing();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentCardIdentifierProperty".equals(evt.getPropertyName())) {
            Card oldCard = (Card)evt.getOldValue();
            Card card = this.wizardModel.getCurrentCard();
            Card.StepID stepID = card.getCurrentStepID();
            CardHead head = card.getCardHead();
            head.setIcon(this.cardHeadIcon);
            this.cardHeadPane.update(head);
            String title = this.wizardTitle + ":  " + this.getWizardTitleSuffix(card, oldCard);
            this.setTitle(title);
            EWizardButton defaultButtonE = null;
            if (this.wizardModel.arrivedFirstCard()) {
                this.buttonPane.update(stepID, EWizardButton.Previous, EWizardButton.Next, EWizardButton.Cancel);
                this.setButtonEnable(EWizardButton.Previous, false);
                defaultButtonE = EWizardButton.Next;
            } else if (this.wizardModel.arraivedSummaryCard()) {
                this.buttonPane.update(stepID, EWizardButton.Previous, EWizardButton.Complete, EWizardButton.Cancel);
                defaultButtonE = EWizardButton.Complete;
            } else if (this.wizardModel.arrivedFinishCard()) {
                this.buttonPane.update(stepID, EWizardButton.CLOSE);
                defaultButtonE = EWizardButton.CLOSE;
            } else {
                this.buttonPane.update(stepID, EWizardButton.Previous, EWizardButton.Next, EWizardButton.Cancel);
                defaultButtonE = EWizardButton.Next;
            }
            JButton defaultButton = this.buttonPane.getButtonBy(stepID, defaultButtonE);
            this.getRootPane().transferFocusUpCycle();
            this.getRootPane().setDefaultButton(defaultButton);
        }
    }

    private String getWizardTitleSuffix(Card currentCard, Card prevCard) {
        Card.Step step = null;
        step = null == currentCard.getCurrentCardStep() ? currentCard.getStep() : currentCard.getCurrentCardStep();
        int currentStep = step.getCurrentStep();
        int totalSteps = step.getTotalStep() + 1;
        if (!this.showFinishedCard) {
            totalSteps = step.getTotalStep();
        }
        if (Card.FINISH_STEP == currentCard.getStep()) {
            Card.Step prevStep = prevCard.getCurrentStep();
            currentStep = totalSteps = prevStep.getTotalStep() + 1;
        }
        return MessageFormat.format(ResourceManager.getString("wizard.titlebar.step"), currentStep, totalSteps);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        Card currentCard = this.getModel().getCurrentCard();
        if (null == currentCard || windowEvent.getID() != 201) {
            super.processWindowEvent(windowEvent);
            return;
        }
        Card.StepID stepID = currentCard.getCurrentStepID();
        if (this.getModel().arrivedFinishCard() ? !this.buttonPane.getButtonBy(stepID, EWizardButton.CLOSE).isEnabled() : !this.buttonPane.getButtonBy(stepID, EWizardButton.Cancel).isEnabled()) {
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    @Override
    public void dispose() {
        Window window = this.getOwner();
        if (this.isShowing()) {
            Card currentCard = this.getModel().getCurrentCard();
            if (!currentCard.doCloseTask()) {
                return;
            }
            super.dispose();
            currentCard.doAfterClosing();
        } else {
            super.dispose();
        }
        SwingUtil.postEvent(window);
    }

    public void disposeOnException() {
        if (null != this.exceptionTask) {
            AsyncExcutor.submit(this.exceptionTask);
        }
        super.dispose();
    }

    public void addExceptionTask(Runnable exceptionTaskTemp) {
        this.exceptionTask = exceptionTaskTemp;
    }

    private void readObject(ObjectInputStream in) {
    }

    static class NavigationBar
    extends JPanel {
        private static final long serialVersionUID = -6353833271412606367L;
        private transient Map<Card.StepID, EnumMap<EWizardButton, JButton>> stepBtns = new EnumMap<Card.StepID, EnumMap<EWizardButton, JButton>>(Card.StepID.class);
        private transient Box buttonPane;
        private transient JButton helpButton;
        private transient WizardHandler handler;

        public NavigationBar(WizardHandler handler) {
            this.handler = handler;
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.helpButton = this.createButton(EWizardButton.Help);
            this.buttonPane = Box.createHorizontalBox();
            Box buttonBox = Box.createHorizontalBox();
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(this.buttonPane);
            buttonBox.setBorder(UCD.createEmptyBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)new JSeparator(), "North");
            this.add((Component)buttonBox, "Center");
        }

        private JButton createButton(EWizardButton wizardButtonE) {
            JButton button = UCD.createButton(wizardButtonE.getText());
            button.setActionCommand(wizardButtonE.getCommand());
            button.addActionListener(this.handler);
            return button;
        }

        public void update(Card.StepID stepID, EWizardButton ... buttons) {
            EnumMap<EWizardButton, Object> buttonMap;
            Assert.notNullArray(buttons);
            this.buttonPane.removeAll();
            if (!this.stepBtns.containsKey((Object)stepID)) {
                buttonMap = new EnumMap(EWizardButton.class);
                this.stepBtns.put(stepID, buttonMap);
            }
            buttonMap = this.stepBtns.get((Object)stepID);
            ArrayList<Object> sameTypeButton = new ArrayList<Object>(0);
            JButton button = null;
            for (EWizardButton buttonE : buttons) {
                if (!buttonMap.containsKey((Object)buttonE)) {
                    button = this.createButton(buttonE);
                    buttonMap.put(buttonE, (Object)button);
                }
                sameTypeButton.add(buttonMap.get((Object)buttonE));
            }
            JComponent btnBox = UCD.buildButtonBox(sameTypeButton.toArray(new JButton[sameTypeButton.size()]), {this.helpButton});
            this.buttonPane.add(Box.createHorizontalGlue());
            this.buttonPane.add(btnBox);
            this.revalidate();
            this.repaint();
        }

        public JButton getButtonBy(Card.StepID stepID, EWizardButton buttonE) {
            if (!this.stepBtns.containsKey((Object)stepID)) {
                throw new IllegalArgumentException("The Step ID is not existed!");
            }
            EnumMap<EWizardButton, JButton> stepButtonMap = this.stepBtns.get((Object)stepID);
            if (!stepButtonMap.containsKey((Object)buttonE)) {
                throw new IllegalArgumentException("The button is not existed!");
            }
            return stepButtonMap.get((Object)buttonE);
        }

        private void readObject(ObjectInputStream in) {
        }
    }

    private static class CardHeadPane
    extends JPanel {
        private static final long serialVersionUID = -7173107387328821161L;
        private JLabel titleLabel;
        private JTextArea detailsArea;
        private JLabel iconLable;

        public CardHeadPane() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.titleLabel = new JLabel();
            this.titleLabel.setFont(new Font("Dialog", 1, 15));
            this.detailsArea = UCD.createTextArea("");
            this.iconLable = new JLabel();
            JPanel detailAreaPane = UCD.createTransparentPane(new BorderLayout(0, 2));
            detailAreaPane.add((Component)this.titleLabel, "North");
            detailAreaPane.add((Component)this.detailsArea, "Center");
            detailAreaPane.setOpaque(false);
            JPanel descPane = UCD.createTransparentPane(new BorderLayout(10, 0));
            descPane.add((Component)UCD.buildVBoxTop(this.iconLable), "West");
            descPane.add((Component)detailAreaPane, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)descPane, "Center");
            this.setBackground(Color.WHITE);
            this.setBorder(new EmptyBorder(8, 15, 8, 8));
            this.setMinimumSize(new Dimension(0, 75));
        }

        public void update(CardHead cardHead) {
            this.titleLabel.setText(cardHead.getTitle());
            this.iconLable.setIcon(cardHead.getIcon());
            this.detailsArea.setText(cardHead.getDetails());
            this.revalidate();
            this.repaint();
        }
    }

    public static class CardHead {
        private String stepTitle;
        private Icon icon;
        private String details;

        public CardHead(String title, String details) {
            this.stepTitle = title;
            this.details = details;
        }

        public CardHead(String title, String details, Icon icon) {
            this(title, details);
            this.icon = icon;
        }

        public String getDetails() {
            return this.details;
        }

        public Icon getIcon() {
            return this.icon;
        }

        void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getTitle() {
            return this.stepTitle;
        }
    }

    public static enum EWizardButton {
        Previous("PREVIOUS_COMMAND", 80),
        Next("NEXT_COMMAND", 78),
        Cancel("CANCEL_COMMAND", 67),
        Complete("FINISH_COMMAND", 70),
        Help("HELP_COMMAND", 72),
        CLOSE("CLOSE_COMMAND", 76);

        private String command;
        private int mnemonic;

        private EWizardButton(String command, int memonic) {
            this.command = command;
            this.mnemonic = memonic;
        }

        public String getCommand() {
            return this.command;
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        public String getText() {
            String prefix = "COMMON.TXT.";
            return ResourceManager.getString(prefix + this.name().toUpperCase(ResourceManager.getLocale()), this.name());
        }

        public static EWizardButton getEWizardButtonBy(String command) {
            for (EWizardButton buttonE : EWizardButton.values()) {
                if (!buttonE.getCommand().equals(command)) continue;
                return buttonE;
            }
            return null;
        }
    }
}

