/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.action;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.util.LicenseUtils;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAction<U>
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAction.class);
    public static final String DISABLED_ICON = "DisabledIcon";
    public static final String ACTION_ID = "action-id";
    private static final long serialVersionUID = 11L;
    private User.Level userType = null;
    private U userObject;
    private String baseActionDeviceID = null;

    public BaseAction() {
    }

    public BaseAction(String deviceID) {
        this.baseActionDeviceID = deviceID;
        this.checkLicense();
    }

    public String getID() {
        return (String)this.getValue(ACTION_ID);
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public void setDeviceID(String deviceID) {
        this.baseActionDeviceID = deviceID;
    }

    protected String getDeviceID() {
        return this.baseActionDeviceID;
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public void setUserType(User.Level user) {
        this.userType = user;
    }

    public List<Type.LicenseFuncFeatureType> getLicenseFuncFeatures() {
        return Collections.emptyList();
    }

    public void update() {
        this.setEnabled(this.isEnabledAction());
    }

    boolean isEnabledAction() {
        if (null == this.getDeviceID()) {
            return false;
        }
        Launcher launcher = LauncherManager.getInstance().getLauncher(this.getDeviceID());
        if (null == launcher) {
            return false;
        }
        if (!launcher.isReady()) {
            return false;
        }
        if (!this.checkLicense()) {
            return false;
        }
        try {
            return this.isAvailable();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isAvailable() {
        return true;
    }

    private boolean checkLicense() {
        List<Type.LicenseFuncFeatureType> types = this.getLicenseFuncFeatures();
        if (null == types || types.isEmpty()) {
            return true;
        }
        ActionType actionType = this.getType();
        String msg = LicenseUtils.partialExisted(this.getDeviceID(), types);
        if (null != msg) {
            this.putValue("ShortDescription", msg);
            return false;
        }
        if (ActionType.CREATE_OR_ADD != actionType) {
            this.putValue("ShortDescription", null);
            return true;
        }
        msg = LicenseUtils.overdue(this.getDeviceID(), types);
        if (null != msg) {
            this.putValue("ShortDescription", msg);
            return false;
        }
        this.putValue("ShortDescription", null);
        return true;
    }

    protected ActionType getType() {
        return ActionType.NON_ASSIGN;
    }

    public final U getUserObject() {
        return this.userObject;
    }

    public final void setUserObject(U obj) {
        this.userObject = obj;
    }

    protected User.Level getUserType() {
        return this.userType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BaseAction)) {
            return false;
        }
        BaseAction action = (BaseAction)object;
        return this.getID().equals(action.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    public BaseAction clone() {
        BaseAction obj = null;
        try {
            obj = (BaseAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("Action clone error");
        }
        return obj;
    }

    public boolean isVisible() {
        return true;
    }

    protected static enum ActionType {
        NON_ASSIGN,
        CREATE_OR_ADD,
        OTHER;

    }

    public static class DisabledAction
    extends BaseAction<Object> {
        private static final long serialVersionUID = 1L;

        public DisabledAction() {
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        protected boolean isAvailable() {
            return false;
        }
    }
}

