/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.action;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.DefaultTaskListener;
import com.huawei.ism.thread.TaskListener;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.ui.widgets.action.BaseAction;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class RefreshAllAction
extends BaseAction {
    private static final long serialVersionUID = 6174530970431434320L;

    @Override
    public void actionPerformed(ActionEvent e) {
        IsmTreeNode treeNode = Framework.getInstance().getSelectionNode();
        ArrayList<Launcher> launcherList = new ArrayList<Launcher>(0);
        LauncherManager instance = LauncherManager.getInstance();
        if (treeNode == null || treeNode.getName().equals("DevicesTreeNode")) {
            List<Launcher> launchers = instance.getAllLauncher();
            for (Launcher launcher : launchers) {
                if (null == launcher) continue;
                launcherList.add(launcher);
                launcherList.addAll(launcher.getSubLaunchers());
            }
        } else if (null != treeNode.getDeviceID()) {
            Launcher launcher = instance.getLauncher(treeNode.getDeviceID());
            if (null == launcher) {
                launcher = instance.findDeviceOwner(treeNode.getDeviceID());
            }
            launcherList.add(launcher);
            if (null == launcher) {
                throw new NullPointerException();
            }
            launcherList.addAll(launcher.getSubLaunchers());
        }
        if (!launcherList.isEmpty()) {
            if (treeNode == null) {
                throw new NullPointerException("treeNode is null.");
            }
            String deviceId = treeNode.getDeviceID();
            if (null != deviceId) {
                Launcher launcher = LauncherManager.getInstance().findDeviceOwner(deviceId);
                if (null == launcher) {
                    throw new NullPointerException();
                }
                deviceId = launcher.getDeviceID();
            }
            if (0 != this.getWarningResult(deviceId)) {
                return;
            }
            Frame mainFrame = Framework.getInstance().getMainFrame();
            RefreshTaskListener taskListener = new RefreshTaskListener(mainFrame);
            this.refreshAllDevice(launcherList, taskListener);
        }
    }

    private int getWarningResult(String deviceId) {
        String refreshWarning = null;
        if (null != deviceId) {
            Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
            refreshWarning = MessageFormat.format(ResourceManager.getString("REFRESH_ARRAY_WARING_DIALOG_MESSAGE"), launcher.getDeviceName());
        } else {
            refreshWarning = ResourceManager.getString("REFRESH_ACTION_WARING_DIALOG_MESSAGE");
        }
        InformationDialog infoDialog = new InformationDialog(this.getMainFrame(), refreshWarning);
        infoDialog.addCancelButton();
        infoDialog.setVisible(true);
        return infoDialog.getValue();
    }

    protected Frame getMainFrame() {
        Frame mainFrame = Framework.getInstance().getMainFrame();
        return mainFrame;
    }

    public void launcherStarted(Launcher launcher) {
        this.setEnabled(this.isAvailable());
    }

    public void launcherStop(Launcher launcher) {
        this.setEnabled(this.isAvailable());
    }

    public void refreshAllDevice(Collection<Launcher> launchers, TaskListener listener) {
        LaunchUpdateTask task = new LaunchUpdateTask(launchers);
        AsyncExcutor.submit((Callable)task, listener);
    }

    public void refreshSingeDevice(List<Launcher> launcherList, String deviceId) {
        if (0 != this.getWarningResult(deviceId)) {
            return;
        }
        Frame mainFrame = Framework.getInstance().getMainFrame();
        RefreshTaskListener taskListener = new RefreshTaskListener(mainFrame);
        this.refreshAllDevice(launcherList, taskListener);
    }

    class RefreshTaskListener
    extends DefaultTaskListener {
        public RefreshTaskListener(Frame mainFrame) {
            this.setParentDialog(mainFrame);
        }

        @Override
        public void taskCompleted(final Object result) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Map errorMsgs;
                    int failsize;
                    if (null != RefreshTaskListener.this.getProgressDialog()) {
                        RefreshTaskListener.this.getProgressDialog().dispose();
                    }
                    if ((failsize = (errorMsgs = (Map)result).size()) > 0) {
                        RefreshTaskListener.this.showErrorDialog(errorMsgs, failsize);
                    } else {
                        InformationDialog dialog = new InformationDialog(RefreshAllAction.this.getMainFrame(), ResourceManager.getString("REFRESH_ACTION_INFROMATION_DIALOG_MESSAGE"));
                        dialog.setVisible(true);
                    }
                }
            });
        }

        public void showErrorDialog(Map<String, String> errorMsg, int failsize) {
            String errinfo = ResourceManager.getString("REFRESH_ACTION_ERROR_DIALOG_MESSAGE");
            String deviceName = ResourceManager.getString("REFRESH_ACTION_ERROR_DIALOG_TITLE_ARRAY");
            String description = ResourceManager.getString("REFRESH_ACTION_ERROR_DIALOG_TITLE_REASON");
            String[] colString = new String[]{deviceName, description};
            MultiErrorDialog meDialog = new MultiErrorDialog((Window)RefreshAllAction.this.getMainFrame(), errinfo, colString);
            ArrayList<DefaultTableRow<String, String>> tableRows = new ArrayList<DefaultTableRow<String, String>>(0);
            DefaultTableRow<String, String> tableRow = null;
            for (Map.Entry<String, String> entry : errorMsg.entrySet()) {
                tableRow = new DefaultTableRow<String, String>(colString.length, entry.getKey(), entry.getKey());
                tableRow.setValueAt(0, entry.getKey());
                tableRow.setValueAt(1, entry.getValue());
                tableRows.add(tableRow);
            }
            meDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
            meDialog.setVisible(true);
        }
    }

    private static final class LaunchUpdateTask
    implements Callable<Object> {
        private final Collection<Launcher> launchers;

        private LaunchUpdateTask(Collection<Launcher> launchers) {
            this.launchers = launchers;
        }

        @Override
        public Object call() {
            HashMap<String, String> errMsgs = new HashMap<String, String>(0);
            if (null == this.launchers) {
                return errMsgs;
            }
            for (Launcher launcherInterface : this.launchers) {
                try {
                    launcherInterface.refresh();
                }
                catch (IsmException e) {
                    errMsgs.put(launcherInterface.getDeviceContext().getDeviceName(), e.getErrorMessage());
                }
            }
            return errMsgs;
        }
    }
}

