/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.devices;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui2.mainframe.device.DeviceFrame;
import com.huawei.ism.ui2.mainframe.devices.HomeModulePane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

class HomeDevicesPane
extends HomeModulePane.HomeModuleSubPane {
    private static final long serialVersionUID = 3971735485154795865L;
    private static final String DEVICE_ICON_STYLE_IDENTIFIER = "DEVICE_ICON_STYLE_IDENTIFIER";
    private static final String DEVICE_TABLE_STYLE_IDENTIFIER = "DEVICE_TABLE_STYLE_IDENTIFIER";
    private CardLayout cardLayout = null;
    private JPanel cardPane;
    private StylePane currentStylePane;
    private Map<String, StylePane> stylePanes = new HashMap<String, StylePane>(0);

    public HomeDevicesPane() {
        this.doLayoutUI();
    }

    @Override
    public void updateProperty(int updateMode) {
        this.currentStylePane.update();
    }

    private void doLayoutUI() {
        JPanel buttonPane = new JPanel(new BorderLayout());
        buttonPane.setOpaque(false);
        JButton button = new JButton("\u5207\u6362\u98ce\u683c");
        buttonPane.add((Component)button, "East");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HomeDevicesPane.this.currentStylePane instanceof IconStylePane) {
                    HomeDevicesPane.this.showStylePane(HomeDevicesPane.DEVICE_TABLE_STYLE_IDENTIFIER);
                } else {
                    HomeDevicesPane.this.showStylePane(HomeDevicesPane.DEVICE_ICON_STYLE_IDENTIFIER);
                }
            }
        });
        buttonPane.setBorder(new EmptyBorder(12, 0, 5, 20));
        this.cardLayout = new CardLayout();
        this.cardPane = new JPanel(this.cardLayout);
        IconStylePane iconStypePane = new IconStylePane();
        iconStypePane.setDevicesInfoPane(this);
        TableStylePane tableStylePane = new TableStylePane();
        tableStylePane.setDevicesInfoPane(this);
        this.cardPane.add((Component)iconStypePane, DEVICE_ICON_STYLE_IDENTIFIER);
        this.cardPane.add((Component)tableStylePane, DEVICE_TABLE_STYLE_IDENTIFIER);
        this.stylePanes.put(DEVICE_ICON_STYLE_IDENTIFIER, iconStypePane);
        this.stylePanes.put(DEVICE_TABLE_STYLE_IDENTIFIER, tableStylePane);
        this.cardLayout.show(this.cardPane, DEVICE_ICON_STYLE_IDENTIFIER);
        this.currentStylePane = iconStypePane;
        this.setLayout(new BorderLayout());
        this.add((Component)buttonPane, "North");
        this.add((Component)this.cardPane, "Center");
    }

    void showStylePane(String identifier) {
        this.currentStylePane = this.stylePanes.get(identifier);
        this.cardLayout.show(this.cardPane, identifier);
        this.autoUpdate();
    }

    private static class DeviceItem
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static final Icon N8000_DEVICE_ICON = ResourceManager.getImage("home_device_n8000_normal.png");
        private static final Icon ARRAY_DEVICE_ICON = ResourceManager.getImage("home_device_array_normal.png");
        private static final Icon VIS_DEVICE_ICON = ResourceManager.getImage("home_device_vis_normal.png");
        private static final Icon S8000_DEVICE_ICON = ResourceManager.getImage("home_device_s8000_normal.png");
        private JProgressBar progressBar = null;
        private JLabel deviceIconLabel = null;
        private DeviceContext deviceContext = null;

        public DeviceItem(DeviceContext context) {
            this.deviceContext = context;
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            Icon icon = this.getDeviceIcon();
            this.deviceIconLabel = new JLabel(icon);
            this.deviceIconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JFrame.setDefaultLookAndFeelDecorated(false);
                    DeviceFrame mainFrame = new DeviceFrame(deviceContext);
                    mainFrame.setVisible(true);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    deviceIconLabel.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    deviceIconLabel.setCursor(Cursor.getDefaultCursor());
                }
            });
            JLabel deviceTypeAndIP = new JLabel();
            deviceTypeAndIP.setText(this.deviceContext.getDeviceModelType().toString() + "_" + this.deviceContext.getPreferedIP());
            JLabel deviceCapacity = new JLabel(ResourceManager.getStringWithColon("CAPACITY_GB"));
            this.progressBar = this.createProgressBar(80, "");
            this.progressBar.setMaximumSize(new Dimension(0, 12));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.centerComponent(this.deviceIconLabel));
            this.add(Box.createVerticalStrut(5));
            this.add(this.centerComponent(deviceTypeAndIP));
            this.add(this.centerComponent(deviceCapacity, this.progressBar));
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(8, 8, 8, 8));
        }

        public JProgressBar createProgressBar(int progress, String desc) {
            JProgressBar bar = new JProgressBar(1, 100);
            bar.setValue(progress);
            bar.setStringPainted(true);
            String displayString = desc + progress + "%";
            bar.setString(displayString);
            bar.setIndeterminate(false);
            bar.setMaximumSize(new Dimension(30, 20));
            return bar;
        }

        private Box centerComponent(JComponent ... components) {
            Box centerBox = Box.createHorizontalBox();
            centerBox.add(Box.createHorizontalGlue());
            for (JComponent c : components) {
                centerBox.add(c);
                centerBox.add(Box.createHorizontalStrut(8));
            }
            centerBox.add(Box.createHorizontalGlue());
            return centerBox;
        }

        private Icon getDeviceIcon() {
            DeviceType deviceType = this.deviceContext.getDeviceType();
            Icon icon = ARRAY_DEVICE_ICON;
            switch (deviceType) {
                case N8000: {
                    icon = N8000_DEVICE_ICON;
                    break;
                }
                case S8000: {
                    icon = S8000_DEVICE_ICON;
                    break;
                }
                case VIS: {
                    icon = VIS_DEVICE_ICON;
                    break;
                }
            }
            return icon;
        }

        public void update(DeviceContext context) {
            this.progressBar.setValue(50);
            this.progressBar.setString("50%");
        }
    }

    private static class TableStylePane
    extends StylePane {
        private static final long serialVersionUID = 1L;
        private DefaultTableModel deviceTableModel = null;

        public TableStylePane() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.setOpaque(false);
            this.deviceTableModel = new DefaultTableModel(new String[]{"\u8bbe\u5907IP", "\u8bbe\u5907\u578b\u53f7", "\u8bbe\u5907\u5e8f\u5217\u53f7"}, new int[0]);
            IsmTable deviceTable = new IsmTable(this.deviceTableModel);
            TableScrollPane tableScrollPane = new TableScrollPane(deviceTable);
            this.setLayout(new BorderLayout());
            this.add(tableScrollPane);
        }

        @Override
        public void update() {
            ArrayList<TableRow> tableRows = new ArrayList<TableRow>(0);
            List<DeviceContext> deviceContexts = LauncherManager.getInstance().getDeviceContexts();
            DefaultTableRow<DeviceContext, String> tableRow = null;
            for (DeviceContext deviceContext : deviceContexts) {
                tableRow = new DefaultTableRow<DeviceContext, String>(3, deviceContext, deviceContext.getDeviceID());
                tableRow.setValueAt(0, deviceContext.getPreferedIP());
                tableRow.setValueAt(1, deviceContext.getDeviceModelType().toString());
                tableRow.setValueAt(2, deviceContext.getDeviceID());
                tableRows.add(tableRow);
            }
            this.deviceTableModel.setTableData(tableRows);
        }
    }

    private static class IconStylePane
    extends StylePane {
        private static final long serialVersionUID = 1L;
        private Map<String, DeviceItem> deviceItems = new HashMap<String, DeviceItem>(0);
        private JPanel deviceIconPane = null;

        public IconStylePane() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.deviceIconPane = new JPanel();
            this.deviceIconPane.setOpaque(false);
            this.deviceIconPane.setLayout(new FlowLayout(0, 30, 30));
            JScrollPane scrollPane = new JScrollPane(this.deviceIconPane);
            scrollPane.setBorder(null);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
        }

        @Override
        public void update() {
            List<DeviceContext> deviceContexts = LauncherManager.getInstance().getDeviceContexts();
            HashSet<String> existDeviceIDs = new HashSet<String>();
            boolean validate = false;
            String deviceID = null;
            DeviceItem deviceIt = null;
            DeviceItem deviceItem = null;
            for (DeviceContext deviceContext : deviceContexts) {
                deviceID = deviceContext.getDeviceID();
                existDeviceIDs.add(deviceID);
                if (this.deviceItems.containsKey(deviceID)) {
                    deviceIt = this.deviceItems.get(deviceID);
                    deviceIt.update(deviceContext);
                    continue;
                }
                deviceItem = new DeviceItem(deviceContext);
                this.deviceIconPane.add(deviceItem);
                this.deviceItems.put(deviceContext.getDeviceID(), deviceItem);
                validate = true;
            }
            HashSet<String> toBeRemoveDevices = new HashSet<String>(this.deviceItems.keySet());
            toBeRemoveDevices.removeAll(existDeviceIDs);
            if (!toBeRemoveDevices.isEmpty()) {
                DeviceItem deviceIte = null;
                for (String deviceIdentifer : toBeRemoveDevices) {
                    deviceIte = this.deviceItems.get(deviceIdentifer);
                    this.deviceIconPane.remove(deviceIte);
                    this.deviceItems.remove(deviceIdentifer);
                    validate = true;
                }
            }
            if (validate) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    private static abstract class StylePane
    extends JPanel {
        private HomeDevicesPane devicesInfoPane = null;

        public StylePane() {
            this.setOpaque(false);
        }

        void setDevicesInfoPane(HomeDevicesPane deviceInfosPane) {
            this.devicesInfoPane = deviceInfosPane;
        }

        protected HomeDevicesPane getDevicesInfoPane() {
            return this.devicesInfoPane;
        }

        public abstract void update();
    }
}

