/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractTabLayout
extends JPanel {
    protected static final int BUTTON_SHORT_GAP = 4;
    protected static final int BUTTON_LONG_GAP = 10;
    protected static final int BOX_GAP_TWELVE = 12;
    private static final long serialVersionUID = 1L;
    private static final Dimension ALARM_PANEL_DIMENSION = new Dimension(820, 520);
    private IsmTable tabTable;
    private JButton clearFilterButton;
    private JButton saveButton;
    private JButton clearButton;
    private JComboBox levelComboBox;
    private JComboBox deviceComboBox;
    private KeywordFilterField keywordFilter;

    public AbstractTabLayout(IsmTable tabTable) {
        this.tabTable = tabTable;
    }

    public AbstractTabLayout() {
    }

    protected void init(JButton refreshButton) {
        this.setOpaque(false);
        JComponent centerPane = this.createTablePane(refreshButton);
        JComponent contentBox = UCD.buildVerticalBox(UCD.createEmptyBorder(), Box.createVerticalStrut(12), centerPane, Box.createVerticalStrut(12));
        this.setLayout(new BorderLayout());
        this.add((Component)contentBox, "Center");
        this.setPreferredSize(ALARM_PANEL_DIMENSION);
        this.setMaximumSize(ALARM_PANEL_DIMENSION);
        this.setMinimumSize(ALARM_PANEL_DIMENSION);
    }

    protected Box initButtonPane() {
        this.saveButton = UCD.createButton(ResourceManager.getString("PER_HIS_23"));
        this.saveButton.setEnabled(false);
        this.clearButton = UCD.createButton(ResourceManager.getString("CLEAR"));
        this.clearButton.setEnabled(false);
        this.setFocusable(false);
        this.setOpaque(false);
        return this.createBtnBox();
    }

    protected Box createBtnBox() {
        Box box = Box.createHorizontalBox();
        box.add(this.saveButton);
        box.add(Box.createHorizontalStrut(4));
        box.add(this.clearButton);
        return box;
    }

    protected JComponent createTablePane(JButton refreshButton) {
        JPanel tablePanel = UCD.createBoxLayoutPane(0);
        tablePanel.setOpaque(false);
        tablePanel.setLayout(new BorderLayout());
        this.tabTable.setSelectionMode(2);
        TableScrollPane tableScrollPane = TableScrollPane.createTablePane(this.tabTable, true, TableScrollPane.CountArea.TABLE_LEFT_DOWN, TableScrollPane.FilterArea.NONE, TableScrollPane.ButtonArea.TABLE_LEFT_UP);
        JComponent hbox = UCD.buildHorizotalBox(null, this.initButtonPane(), Box.createHorizontalGlue(), this.initTopFilterPane(refreshButton));
        tableScrollPane.addComponent2ButtonArea(UCD.buildVBoxTop(5, hbox, Box.createVerticalStrut(1)));
        tablePanel.add((Component)tableScrollPane, "Center");
        return tablePanel;
    }

    protected Box initTopFilterPane(JButton refreshButton) {
        Box filterBox = Box.createHorizontalBox();
        this.deviceComboBox = new JComboBox();
        Dimension deviceDimension = new Dimension(100, 23);
        UCD.setJComponentSize(this.deviceComboBox, deviceDimension);
        this.levelComboBox = new JComboBox();
        Dimension levelDim = new Dimension(95, 23);
        this.levelComboBox.setPreferredSize(levelDim);
        this.levelComboBox.setMinimumSize(levelDim);
        this.levelComboBox.setMaximumSize(levelDim);
        this.clearFilterButton = UCD.createButton(ResourceManager.getString("EVENT_MANAGER_CLEAR_FILTER"));
        filterBox.add(this.deviceComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.levelComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        this.keywordFilter = new KeywordFilterField(this.tabTable);
        filterBox.add(this.keywordFilter);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.clearFilterButton);
        this.clearFilterButton.setEnabled(false);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(refreshButton);
        return filterBox;
    }

    public KeywordFilterField getKeywordFilter() {
        return this.keywordFilter;
    }

    public void setKeywordFilter(KeywordFilterField keywordFilter) {
        this.keywordFilter = keywordFilter;
    }

    public JComboBox getDeviceComboBox() {
        return this.deviceComboBox;
    }

    public void setDeviceComboBox(JComboBox deviceComboBox) {
        this.deviceComboBox = deviceComboBox;
    }

    public JComboBox getLevelComboBox() {
        return this.levelComboBox;
    }

    public void setLevelComboBox(JComboBox levelComboBox) {
        this.levelComboBox = levelComboBox;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public void setClearButton(JButton clearButton) {
        this.clearButton = clearButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public void setSaveButton(JButton saveButton) {
        this.saveButton = saveButton;
    }

    public JButton getClearFilterButton() {
        return this.clearFilterButton;
    }

    public void setClearFilterButton(JButton clearFilterButton) {
        this.clearFilterButton = clearFilterButton;
    }

    public IsmTable getTabTable() {
        return this.tabTable;
    }

    public void setTabTable(IsmTable tabTable) {
        this.tabTable = tabTable;
    }
}

