/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event.alarmbuzzer;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.event.EventBuzzHandle;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.ui2.module.event.alarmbuzzer.AlarmSoundManagerDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;

public class IsmAlarmBuzzerSwitchDialog
extends AlarmSoundManagerDialog {
    private static final long serialVersionUID = 1L;
    private Component focusRadio = null;

    public IsmAlarmBuzzerSwitchDialog(String tip, Component focusRadio) {
        super(tip);
        this.focusRadio = focusRadio;
    }

    public IsmAlarmBuzzerSwitchDialog() {
        super(ResourceManager.getString("ISM_ALARM_BUZZER_SWITCH_TIP"));
        this.setTitle(ResourceManager.getString("alarm.buzzer.setting.title"));
        this.pack();
        this.addComponentsEvent();
    }

    @Override
    protected void initDefaultProperty() {
        boolean initFlag = CustomResourceManager.getInstance().getBoolProperty("custom.ClientSoundSwitchStatus", false);
        if (initFlag) {
            this.getEnableBtn().setSelected(true);
            this.enableAlarmLevel(true);
        } else {
            this.getDisableBtn().setSelected(true);
            this.enableAlarmLevel(false);
        }
        int level = CustomResourceManager.getInstance().getIntProperty("custom.ClientSoundSwitchAlarmLevel", Event.Level.CRITICAL.getValue());
        if (level == Event.Level.CRITICAL.getValue()) {
            this.getCriticalCbx().setSelected(true);
            this.adjustAlarmLevelDisplay(level, true);
        } else if (level == Event.Level.MAJOR.getValue()) {
            this.getMajorCbx().setSelected(true);
            this.adjustAlarmLevelDisplay(level, true);
        } else if (level == Event.Level.WARNING.getValue()) {
            this.getWarningCbx().setSelected(true);
            this.adjustAlarmLevelDisplay(level, true);
        }
    }

    @Override
    protected String getHelpKey() {
        return "alarm_config_client_sound";
    }

    @Override
    protected void addComponentsEvent() {
        super.addComponentsEvent();
        this.getUiModifyChecker().addCheckpoint(this.getCriticalCbx());
        this.getUiModifyChecker().addCheckpoint(this.getMajorCbx());
        this.getUiModifyChecker().addCheckpoint(this.getWarningCbx());
        this.getCriticalCbx().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsmAlarmBuzzerSwitchDialog.this.adjustAlarmLevelDisplay(Event.Level.CRITICAL.getValue(), IsmAlarmBuzzerSwitchDialog.this.getCriticalCbx().isSelected());
                IsmAlarmBuzzerSwitchDialog.this.setApplyButtonEnabled(IsmAlarmBuzzerSwitchDialog.this.getUiModifyChecker().isValueChanged());
            }
        });
        this.getMajorCbx().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsmAlarmBuzzerSwitchDialog.this.adjustAlarmLevelDisplay(Event.Level.MAJOR.getValue(), IsmAlarmBuzzerSwitchDialog.this.getMajorCbx().isSelected());
                IsmAlarmBuzzerSwitchDialog.this.setApplyButtonEnabled(IsmAlarmBuzzerSwitchDialog.this.getUiModifyChecker().isValueChanged());
            }
        });
        this.getWarningCbx().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsmAlarmBuzzerSwitchDialog.this.adjustAlarmLevelDisplay(Event.Level.WARNING.getValue(), IsmAlarmBuzzerSwitchDialog.this.getWarningCbx().isSelected());
                IsmAlarmBuzzerSwitchDialog.this.setApplyButtonEnabled(IsmAlarmBuzzerSwitchDialog.this.getUiModifyChecker().isValueChanged());
            }
        });
    }

    private void setApplyButtonEnabled(boolean isEanbled) {
        this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(isEanbled);
    }

    private void adjustAlarmLevelDisplay(int level, boolean isSelected) {
        if (level == Event.Level.CRITICAL.getValue()) {
            if (!isSelected) {
                this.getMajorCbx().setSelected(false);
                this.getWarningCbx().setSelected(false);
            }
        } else if (level == Event.Level.MAJOR.getValue()) {
            if (isSelected) {
                this.getCriticalCbx().setSelected(true);
            } else {
                this.getWarningCbx().setSelected(false);
            }
        } else if (level == Event.Level.WARNING.getValue() && isSelected) {
            this.getCriticalCbx().setSelected(true);
            this.getMajorCbx().setSelected(true);
        }
    }

    @Override
    protected Box createFirstSettingRow() {
        this.getCriticalCbx().setText(ResourceManager.getString("ALARM_BUZZER_CRITICAL_LEVEL"));
        this.getMajorCbx().setText(ResourceManager.getString("ALARM_BUZZER_MAJOR_LEVEL"));
        this.getWarningCbx().setText(ResourceManager.getString("ALARM_BUZZER_WARNNING_LEVEL"));
        JLabel levelLabel = new JLabel();
        levelLabel.setText(ResourceManager.getString("ALARM_BUZZER_LEVEL"));
        Box faultLevelBox = Box.createHorizontalBox();
        faultLevelBox.add(levelLabel);
        faultLevelBox.add(Box.createHorizontalStrut(12));
        faultLevelBox.add(this.getCriticalCbx());
        faultLevelBox.add(Box.createHorizontalStrut(12));
        faultLevelBox.add(this.getMajorCbx());
        faultLevelBox.add(Box.createHorizontalStrut(12));
        faultLevelBox.add(this.getWarningCbx());
        faultLevelBox.add(Box.createHorizontalGlue());
        return faultLevelBox;
    }

    protected void enableAlarmLevel(boolean isEnable) {
        this.getCriticalCbx().setEnabled(isEnable);
        this.getMajorCbx().setEnabled(isEnable);
        this.getWarningCbx().setEnabled(isEnable);
    }

    @Override
    protected void enableAlarm() {
        if (!this.isInitFlag() && this.getDisableBtn().isSelected()) {
            this.setApplyButtonEnabled(false);
        } else {
            this.setApplyButtonEnabled(this.getUiModifyChecker().isValueChanged());
        }
        this.enableAlarmLevel(this.getEnableBtn().isSelected());
    }

    @Override
    protected void doConfirmTask() {
        if (this.getButtonBy(IsmDialog.ECommonButton.Apply).isEnabled()) {
            if (this.doTask()) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    @Override
    protected void doApplyTask() {
        if (this.getButtonBy(IsmDialog.ECommonButton.Apply).isEnabled() && this.doTask()) {
            this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(false);
            this.setInitFlag(this.getEnableBtn().isSelected());
            if (null != this.focusRadio) {
                this.focusRadio.requestFocus();
            }
        }
    }

    protected boolean doTask() {
        if (this.getEnableBtn().isSelected() && !this.getCriticalCbx().isSelected() && !this.getMajorCbx().isSelected() && !this.getWarningCbx().isSelected()) {
            DialogUtils.showErrorDialog(this, ResourceManager.getString("ALARM_CLIENT_SOUND_NOT_SELECT_LEVEL"));
            return false;
        }
        boolean enable = this.getEnableBtn().isSelected();
        int index = this.getAlarmLevel();
        CustomResourceManager.getInstance().setString("custom.ClientSoundSwitchStatus", String.valueOf(enable));
        CustomResourceManager.getInstance().setString("custom.ClientSoundSwitchAlarmLevel", String.valueOf(index));
        EventBuzzHandle.getInstance().setLevel(index);
        DialogUtils.showInfoDialog(this);
        this.getUiModifyChecker().flushValue();
        return true;
    }

    private int getAlarmLevel() {
        if (this.getWarningCbx().isSelected()) {
            return Event.Level.WARNING.getValue();
        }
        if (this.getMajorCbx().isSelected()) {
            return Event.Level.MAJOR.getValue();
        }
        return Event.Level.CRITICAL.getValue();
    }
}

