/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.IPerfStatData;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.common.bean.impl.IPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui2.perfstat.PerfStatRealTimeLayout;
import com.huawei.ism.ui2.perfstat.PerfStatRealTimePane;
import com.huawei.ism.ui2.perfstat.PerfStatStrategySettingDialog;
import com.huawei.ism.ui2.perfstat.util.ISftpTransfer;
import com.huawei.ism.ui2.perfstat.util.PerfStatFile;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class PerfStatDataSource {
    private String deivceID;
    private Window parentWindow;

    public PerfStatDataSource(String deviceID) {
        this.deivceID = deviceID;
    }

    public String getDeviceID() {
        return this.deivceID;
    }

    public TimeZone getTimeZone() {
        Launcher launcher = CommonUtil.getLauncher(this.deivceID);
        return launcher.getDeviceTimeZone();
    }

    public void setParentWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    public Window getParentWindow() {
        if (this.parentWindow == null) {
            return Framework.getInstance().getMainFrame();
        }
        return this.parentWindow;
    }

    public void initDeviceData(PerfStatRealTimePane panel) {
    }

    public List<IObjectTypeEnum> getObjectTypes(PerfStatRealTimePane panel) {
        Set<IPerfStatObjectType> objectTypes = panel.getPerfStatObjectTypeToMOMap().keySet();
        ArrayList<IObjectTypeEnum> objectTypesEnumList = new ArrayList<IObjectTypeEnum>(0);
        for (IPerfStatObjectType type : objectTypes) {
            objectTypesEnumList.add(type.getType());
        }
        return objectTypesEnumList;
    }

    public void objectTypeComboBoxChanged(PerfStatRealTimePane panel) {
    }

    public PerfStatStrategySettingDialog getPerfStatStrategySettingDialog() {
        PerfStatStrategySettingDialog perfStatStrategySettingDialog = new PerfStatStrategySettingDialog(this.getDeviceID(), this.getParentWindow(), this.getDeviceID());
        return perfStatStrategySettingDialog;
    }

    public List<Pair<String, String>> getDataTypeCategories(PerfStatRealTimeLayout layout) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        list.add(new Pair<String, String>("basicDataTypes", ResourceManager.getString("perf.his.ui.basic.datatype")));
        list.add(new Pair<String, String>("davancedDataTypes", ResourceManager.getString("perf.his.ui.advance.datatype")));
        list.add(new Pair<String, String>("ioDistributionDataTypes", ResourceManager.getString("perfstat.addLegend.ioDistribution")));
        list.add(new Pair<String, String>("allDataTypes", ResourceManager.getString("perfstat.addLegend.allDataType")));
        return list;
    }

    public IObjectTypeEnum[] getAllObjectType(IObjectTypeEnum objectType) {
        return new IObjectTypeEnum[]{objectType};
    }

    public abstract Map<IPerfStatObjectType, List<Object>> getPerfStatObjectTypes();

    public abstract Map<IObjectTypeEnum, DefaultMutableTreeNode> getObjectTypeToObjectsMap(Map<IPerfStatObjectType, List<Object>> var1);

    public abstract long getSamplingInterval();

    public abstract Map<Object, Object> getStrategyAndSwitchStatus();

    public abstract Map<Object, Object> syncGetStrategyAndSwitchStatus();

    public abstract List<IPerfStatData> getPerfStats(List<IPerfStatObject> var1);

    public abstract Map<Object, Object> setSwitchStatus(Map<Object, Object> var1);

    public abstract Map<Object, Object> setStatisticStrategyAndSwitchStatus(Map<Object, Object> var1);

    public abstract IPerfStatObject getPerfStatObject(IPerfStatObject var1);

    public abstract List<PerfStatFile> getAllPerfStateFile(JDialog var1);

    public abstract ISftpTransfer createSftp();

    public abstract void doDeleteArchiveFileTask(String var1);
}

