/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.util.Unit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class TimeUtil {
    private static final String YYYY_MM_DD_HH_MM_SS_UTC_Z = "yyyy-MM-dd HH:mm:ss 'UTC'Z";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    private TimeUtil() {
    }

    @Deprecated
    public static synchronized Date yYYYMMddmmssToDate(String dateString) {
        try {
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat("yyyy-MM-ddHHmmss");
            return yyyyMMddhhmmssSSDateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized Date timeStrToDate(String dateString) {
        try {
            int index = dateString.lastIndexOf(58);
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_UTC_Z);
            return yyyyMMddhhmmssSSDateFormate.parse(dateString.substring(0, index) + dateString.substring(index + 1));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized Date timeStrToDate(String dateString, TimeZone timezone) {
        try {
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            yyyyMMddhhmmssSSDateFormate.setTimeZone(timezone);
            return yyyyMMddhhmmssSSDateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized Date yYYYMMddmmssToDate2(String dateString) {
        try {
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            return yyyyMMddhhmmssSSDateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized String toLocalString(Date date) {
        if (null == date) {
            return "";
        }
        SimpleDateFormat yyyyMmDdDateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        String id = TimeZone.getDefault().getID();
        yyyyMmDdDateFormate.setTimeZone(TimeZone.getTimeZone(id));
        return yyyyMmDdDateFormate.format(date);
    }

    public static synchronized String toLocalString(long date) {
        if (0L >= date) {
            return "";
        }
        return TimeUtil.toLocalString(new Date(date));
    }

    public static synchronized String toUTCString(Date date) {
        if (null == date) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date) + " UTC";
    }

    public static synchronized String toUTCString(long date) {
        return TimeUtil.toUTCString(new Date(date));
    }

    public static synchronized String toGMTString(Date date, TimeZone tz) {
        if (null == date || null == tz) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static synchronized String toGMTString(long date, TimeZone tz) {
        return TimeUtil.toGMTString(new Date(date), tz);
    }

    public static synchronized String gmtToLocalDateString(String gmtString) {
        try {
            Date date = TimeUtil.gmtStr2Date(gmtString);
            if (null == date) {
                return "";
            }
            return TimeUtil.toLocalString(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static synchronized String gmtToString(String gmtString, TimeZone timeZone) {
        try {
            Date date = TimeUtil.gmtStr2Date(gmtString);
            if (null == date) {
                return "";
            }
            return TimeUtil.gmtToString(date, timeZone);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static synchronized String gmtToString(long gmtTimeInMS, TimeZone timeZone) {
        Date date = new Date(gmtTimeInMS);
        return TimeUtil.gmtToString(date, timeZone);
    }

    public static synchronized String gmtToString(Date gmtTime, TimeZone timeZone) {
        try {
            SimpleDateFormat yyyyMmDdDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_UTC_Z);
            yyyyMmDdDateFormate.setTimeZone(timeZone);
            String str = yyyyMmDdDateFormate.format(gmtTime);
            StringBuilder sb = new StringBuilder(str);
            sb.insert(str.length() - 2, ":");
            if (timeZone.useDaylightTime()) {
                sb.append(" DST");
            }
            return sb.toString();
        }
        catch (RuntimeException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static synchronized Date gmtStr2Date(String gmtString) {
        SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        yyyyMMddhhmmssSSDateFormate.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date retDate = null;
        try {
            retDate = yyyyMMddhhmmssSSDateFormate.parse(gmtString);
        }
        catch (ParseException e) {
            return null;
        }
        return retDate;
    }

    public static synchronized String localToGMT(String localString) {
        SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        Date retDate = null;
        try {
            retDate = yyyyMMddhhmmssSSDateFormate.parse(localString);
        }
        catch (ParseException e) {
            return "";
        }
        return TimeUtil.toGMTString(retDate, TimeZone.getTimeZone("GMT"));
    }

    public static synchronized int rowOffsetStr2MS(String rowOffsetStr) {
        int offset = 0;
        int tempInt = 3600000;
        offset += Integer.valueOf(rowOffsetStr.substring(4, 6)) * tempInt;
        offset += Integer.valueOf(rowOffsetStr.substring(7)) * 60 * 1000;
        if (rowOffsetStr.charAt(3) == '-') {
            offset = -offset;
        }
        return offset;
    }

    public static synchronized Date getGmtDate(String gmtString, TimeZone timeZone) {
        SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        yyyyMMddhhmmssSSDateFormate.setTimeZone(timeZone);
        Date retDate = null;
        try {
            retDate = yyyyMMddhhmmssSSDateFormate.parse(gmtString);
        }
        catch (ParseException e) {
            return null;
        }
        return retDate;
    }

    public static int getSecondNum(int ntpSchedule, Unit.TimeUnit unit) {
        int period = -1;
        switch (unit) {
            case DAY: {
                period = ntpSchedule * 24 * 60 * 60;
                break;
            }
            case HOUR: {
                period = ntpSchedule * 60 * 60;
                break;
            }
            case MINUTE: {
                period = ntpSchedule * 60;
                break;
            }
            case SECOND: {
                period = ntpSchedule;
                break;
            }
        }
        return period;
    }

    public static synchronized String gmtToString(String deviceID, long gmtTimeInMS) {
        Date date = new Date(gmtTimeInMS);
        TimeZone timeZone = TimeZone.getDefault();
        return TimeUtil.gmtToString(date, timeZone);
    }
}

