/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.border.NoTitleBorder;
import com.huawei.ism.ui.swing.border.TitleBorder;
import com.huawei.ism.ui.swing.control.RefreshButton;
import com.huawei.ism.ui.swing.control.RequiredHBox;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.swing.text.IsmTextPane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.Lexer;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class UCD {
    public static final int MAX_TOOL_TIP_WIDTH = 300;
    public static final int BUTTON_GAP_SAME_GROUP = 4;
    public static final int BUTTON_GAP_DIFF_GROUP = 10;
    public static final int BUTTON_MARGIN = 8;
    public static final int GAP_12 = 12;
    public static final Color HW_RED = new Color(153, 0, 0);
    public static final int TWO_LABEL_SPACE = 10;
    public static final int BUTTON_HEIGHT = UIManager.getInt("IsmButton.height");
    public static final String WINDOWS_LINE_SEPARATOR = "\n\r";
    public static final String TAG_BR = "<br>";
    public static final String STR_3_POINT = "...";
    public static final int NUM_7 = 7;
    public static final int NUM_4 = 4;
    public static final int NUM_NE_1 = -1;
    public static final int GRIDX_0 = 0;
    public static final int GRIDX_1 = 1;
    public static final int GRIDX_2 = 2;
    public static final int GRIDX_3 = 3;
    public static final int GRIDY_0 = 0;
    public static final int GRIDY_1 = 1;
    public static final int GRIDY_3 = 3;
    public static final int GRIDY_2 = 2;
    public static final int GRIDY_4 = 4;
    public static final int GRIDY_5 = 5;
    public static final int GRIDY_6 = 6;
    public static final int GRIDY_7 = 7;
    public static final int GRIDY_8 = 8;
    public static final int GRIDY_9 = 9;
    public static final int GRIDY_10 = 10;
    public static final int GRIDY_12 = 12;
    public static final int GRIDY_15 = 15;
    public static final int GRIDY_WIDTH_2 = 2;
    public static final int GRIDY_HIGH_1 = 1;
    public static final double WEIGHTX_1 = 1.0;
    public static final double WEIGHTY_1 = 1.0;
    public static final double WEIGHTX_0 = 0.0;
    public static final double WEIGHTY_0 = 0.0;
    public static final int INSETS_EMPTY = 0;
    public static final String BLANK_CONTENT = "--";
    public static final Font DIALOGFONT = new Font("Dialog", 0, 12);
    public static final int FONT_SIZE = 12;
    private static final int BUTTON_WIDTH_MULTIPLE = 10;
    private static Integer[] buttonWidthChoices = new Integer[]{60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190};

    public static void setJComponentSize(JComponent panel, Dimension dimension) {
        panel.setMaximumSize(dimension);
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
    }

    public static void setJComponentSize(JComponent panel, int width, int height) {
        Dimension dimension = new Dimension(width, height);
        UCD.setJComponentSize(panel, dimension);
    }

    public static void setJComponentWidth(JComponent panel, int width) {
        UCD.setJComponentSize(panel, width, panel.getPreferredSize().height);
    }

    public static Border createEtchedBorder() {
        EtchedBorder etchedBorder = new EtchedBorder();
        EmptyBorder emptyBorder = new EmptyBorder(8, 8, 8, 8);
        return new CompoundBorder(etchedBorder, emptyBorder);
    }

    public static Border createTitledBorder(String title) {
        EmptyBorder emptyBorder = new EmptyBorder(-2, 3, 3, 3);
        return UCD.createTitledBorder(title, emptyBorder);
    }

    public static Border createTitledBorder(String title, Border innerBorder) {
        TitledBorder titledborder = new TitledBorder(title);
        return new CompoundBorder(titledborder, innerBorder);
    }

    public static Border createTextTitleBorder(String title) {
        TitleBorder titledBorder = new TitleBorder(title, TitleBorder.Style.TEXT);
        return titledBorder;
    }

    public static Border createTableTitleBorder(String title) {
        TitleBorder titledBorder = new TitleBorder(title, TitleBorder.Style.TABLE);
        return titledBorder;
    }

    public static Border createEmptyBorder() {
        return UCD.createEmptyBorder(8);
    }

    public static Border createEmptyBorder(int gap) {
        return new EmptyBorder(gap, gap, gap, gap);
    }

    public static Border createWizardCardBorder() {
        return new EmptyBorder(12, 17, 12, 12);
    }

    public static Border createNoTitledBorder() {
        return new NoTitleBorder();
    }

    public static Border createNoTitledBorder(int inset) {
        return new NoTitleBorder(inset);
    }

    public static JPopupMenu createPopupMenu(Component ... items) {
        JPopupMenu popmenu = new JPopupMenu();
        if (null != items) {
            for (Component item : items) {
                popmenu.add(item);
            }
        }
        return popmenu;
    }

    public static IsmTextArea createTextArea(String infoText) {
        IsmTextArea infoArea = new IsmTextArea();
        infoArea.setLineWrap(true);
        infoArea.setWrapStyleWord(true);
        infoArea.setFocusable(false);
        infoArea.setEditable(false);
        infoArea.setOpaque(false);
        infoArea.setName("ISMV1R2_framework_newInformationPanel_infoArea");
        infoArea.setText(infoText);
        return infoArea;
    }

    public static JPanel newInformationPanel(String infoText) {
        return UCD.newInformationPanel(infoText, null);
    }

    public static JPanel newInformationPanel(String infoText, ImageIcon imageIcon) {
        return UCD.newInformationPanel(infoText, imageIcon, null);
    }

    public static JPanel newInformationPanel(String infoText, ImageIcon imageIcon, Font font) {
        IsmTextArea infoArea = UCD.createTextArea(infoText);
        if (null != font) {
            infoArea.setFont(font);
        }
        JPanel infoJPanel = new JPanel();
        infoJPanel.setLayout(new BoxLayout(infoJPanel, 0));
        if (null != imageIcon) {
            JLabel info = new JLabel(imageIcon);
            info.setName("ISMV1R2_framework_newInformationPanel_info");
            infoJPanel.add(info);
            infoJPanel.add(Box.createHorizontalStrut(12));
        }
        infoJPanel.add(infoArea);
        infoJPanel.setOpaque(false);
        return infoJPanel;
    }

    public static JPanel newInformationPanel(JTextArea infoArea, ImageIcon imageIcon, Font font) {
        infoArea.setLineWrap(true);
        infoArea.setWrapStyleWord(true);
        infoArea.setFocusable(false);
        infoArea.setEditable(false);
        infoArea.setOpaque(false);
        infoArea.setName("ISMV1R2_framework_newInformationPanel_infoArea");
        if (null != font) {
            infoArea.setFont(font);
        }
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        if (null != imageIcon) {
            JLabel info = new JLabel(imageIcon);
            info.setName("ISMV1R2_framework_newInformationPanel_info");
            infoPanel.add(info);
            infoPanel.add(Box.createHorizontalStrut(12));
        }
        infoPanel.add(infoArea);
        infoPanel.setOpaque(false);
        return infoPanel;
    }

    public static JComponent addVerticalFrame(Component component) {
        JPanel box = UCD.createBoxLayoutPane(1);
        box.add(Box.createVerticalStrut(12));
        box.add(component);
        box.add(Box.createVerticalStrut(12));
        return box;
    }

    public static JComponent addHorizontalFrame(Component component) {
        JPanel box = UCD.createBoxLayoutPane(0);
        box.add(Box.createHorizontalStrut(17));
        box.add(component);
        box.add(Box.createHorizontalStrut(12));
        return box;
    }

    public static JComponent buildHorizotalBox(Border border, int compMargin, Component ... components) {
        if (null == components || 0 == components.length) {
            throw new IllegalArgumentException("The components array cannot be empty!");
        }
        JPanel box = UCD.createBoxLayoutPane(0);
        Component component = null;
        for (int i = 0; i < components.length; ++i) {
            component = components[i];
            box.add(component);
            if (i >= components.length - 1) continue;
            box.add(Box.createHorizontalStrut(compMargin));
        }
        if (null != border) {
            box.setBorder(border);
        }
        return box;
    }

    public static JComponent buildHorizotalBox(Border border, Component ... components) {
        return UCD.buildHorizotalBox(border, 12, components);
    }

    public static JComponent buildVerticalBox(Border border, int compMargin, Component ... components) {
        if (null == components || 0 == components.length) {
            throw new IllegalArgumentException("The components array cannot be empty!");
        }
        JPanel box = UCD.createBoxLayoutPane(1);
        Component component = null;
        for (int i = 0; i < components.length; ++i) {
            component = components[i];
            box.add(component);
            if (i >= components.length - 1) continue;
            box.add(Box.createVerticalStrut(compMargin));
        }
        if (null != border) {
            box.setBorder(border);
        }
        return box;
    }

    public static JComponent buildVerticalBox(Border border, Component ... components) {
        return UCD.buildVerticalBox(border, 10, components);
    }

    public static Box buildVBoxTop(Component ... components) {
        Box vBox = Box.createVerticalBox();
        JComponent box = UCD.buildVerticalBox(null, 10, components);
        vBox.add(box);
        vBox.add(Box.createVerticalGlue());
        return vBox;
    }

    public static Box buildTopAlignVBox(Component ... components) {
        Box box = Box.createVerticalBox();
        for (Component component : components) {
            JPanel panel = new JPanel(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            panel.setAlignmentX(0.0f);
            panel.add(component);
            box.add(panel);
        }
        return box;
    }

    public static Box buildVBoxTop(int rowMargin, Component ... components) {
        Box vBox = Box.createVerticalBox();
        JComponent box = UCD.buildVerticalBox(null, rowMargin, components);
        vBox.add(box);
        vBox.add(Box.createVerticalGlue());
        return vBox;
    }

    public static JComponent buildVBoxBy(Border border, String ... labelNames) {
        Assert.notNullArray(labelNames);
        ArrayList<JLabel> labelKeys = new ArrayList<JLabel>(0);
        JLabel lable = null;
        for (String name : labelNames) {
            lable = new JLabel(name, 10);
            labelKeys.add(lable);
        }
        return UCD.buildVerticalBox(null, labelKeys.toArray(new Component[labelKeys.size()]));
    }

    public static JComponent addSourndFrame(Component component) {
        return UCD.addHorizontalFrame(UCD.addVerticalFrame(component));
    }

    public static JButton createButton(String text) {
        JButton button = new JButton(text);
        Dimension size = UCD.computeButtonPreferredSize(button);
        UCD.setJComponentSize(button, size);
        return button;
    }

    public static JButton createButton(String text, ImageIcon icon) {
        JButton button = new JButton(text, icon);
        Dimension size = UCD.computeButtonPreferredSize(button);
        UCD.setJComponentSize(button, size);
        return button;
    }

    public static JButton createButton(String text, Dimension size, char mnemonic) {
        JButton button = UCD.createButton(text, size);
        if (!IsmPlafUtils.isUnifyStyle()) {
            button.setMnemonic(mnemonic);
        }
        UCD.formatMnemonicDisplay(button);
        return button;
    }

    public static JButton createButton(String text, char mnemonic) {
        JButton tempButton = new JButton();
        tempButton.setText(text);
        if (!IsmPlafUtils.isUnifyStyle()) {
            tempButton.setMnemonic(mnemonic);
        }
        UCD.formatMnemonicDisplay(tempButton);
        Dimension size = UCD.computeButtonPreferredSize(tempButton);
        return UCD.createButton(text, size, mnemonic);
    }

    public static JButton createButton(String text, Dimension size) {
        JButton button = new JButton();
        button.setText(text);
        UCD.setJComponentSize(button, size);
        UCD.formatMnemonicDisplay(button);
        return button;
    }

    public static JButton createButton(ImageIcon icon, Dimension size) {
        JButton button = new JButton();
        UCD.setJComponentSize(button, size);
        button.setIcon(icon);
        return button;
    }

    public static JButton createIconButton(String imgName) {
        Assert.notNull(imgName);
        Icon imgIcon = ResourceManager.getImage(imgName);
        if (null == imgIcon || ResourceManager.DEFAULT_ICON == imgIcon) {
            imgIcon = UIManager.getIcon(imgName);
        }
        RefreshButton button = new RefreshButton(null);
        button.setIcon(imgIcon);
        return button;
    }

    public static JComponent buildButtonBox(JButton[] ... sameGroups) {
        Box buttonbox = Box.createHorizontalBox();
        JButton[] sameGroup = null;
        Dimension preferredSize = null;
        JButton button = null;
        for (int i = 0; i < sameGroups.length; ++i) {
            sameGroup = sameGroups[i];
            if (null == sameGroup) continue;
            preferredSize = UCD.giveMePreferredSizeInGroup(sameGroup);
            for (int j = 0; j < sameGroup.length; ++j) {
                button = sameGroup[j];
                button.setMaximumSize(preferredSize);
                button.setMinimumSize(preferredSize);
                button.setPreferredSize(preferredSize);
                buttonbox.add(button);
                if (j >= sameGroup.length - 1) continue;
                buttonbox.add(Box.createHorizontalStrut(4));
            }
            if (i >= sameGroups.length - 1) continue;
            buttonbox.add(Box.createHorizontalStrut(10));
        }
        return buttonbox;
    }

    public static Dimension giveMePreferredSizeInGroup(JButton[] sameGroup) {
        int buttonWidth = 0;
        int btnPreWidth = 0;
        for (JButton button : sameGroup) {
            btnPreWidth = button.getPreferredSize().width;
            if (btnPreWidth <= buttonWidth) continue;
            buttonWidth = btnPreWidth;
        }
        return new Dimension(buttonWidth, BUTTON_HEIGHT);
    }

    public static void setTipText(JToolTip toolTip, String tipText) {
        if (null == tipText) {
            return;
        }
        FontMetrics fm = IsmPlafUtils.getFontMetrics(toolTip, null, IsmFontFactory.getDialogPlain());
        toolTip.setTipText(UCD.wrapTextWithHTML(fm, tipText, 300));
    }

    public static String createToolTipText(Component source, String text) {
        Font font = source.getFont();
        FontMetrics fm = source.getFontMetrics(font);
        return UCD.wrapTextWithHTML(fm, text, 300);
    }

    private static String wrapTextWithoutBlank(FontMetrics fm, String text, int width, int line) {
        StringBuilder str = new StringBuilder();
        char[] chrs = text.toCharArray();
        StringBuilder subStr = new StringBuilder();
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (fm.stringWidth(subStr.toString()) >= width) {
                str.append((CharSequence)subStr).append(TAG_BR);
                if (++count == line) break;
                subStr = new StringBuilder();
            }
            subStr.append(chrs[i]);
        }
        if (count == line) {
            if (str.length() > 7) {
                str.delete(str.length() - 7, str.length() - 4);
                str.insert(str.length() - 4, STR_3_POINT);
            }
        } else {
            str.append((CharSequence)subStr);
        }
        return str.toString();
    }

    public static String wrapTextWithHTML(FontMetrics fm, String tipText, int width) {
        return UCD.wrapTextWithHTML(fm, tipText, width, -1);
    }

    public static String wrapTextWithHTML(FontMetrics fm, String tipText, int width, int line) {
        if (null == tipText) {
            return null;
        }
        String tip = tipText;
        if (0 < tip.length() && tip.charAt(0) == '/') {
            tip = '\b' + tip;
        }
        String html = tip;
        String htmlHeader = "<html>";
        String htmlHeaderPair = "</html>";
        String htmlWrap = TAG_BR;
        if (html.indexOf("<html>") < 0) {
            html = html.indexOf(WINDOWS_LINE_SEPARATOR) >= 0 ? html.replaceAll(WINDOWS_LINE_SEPARATOR, TAG_BR) : (!html.contains(" ") ? UCD.wrapTextWithoutBlank(fm, tip, width, line) : UCD.wrapText(tip, fm, width, line));
        }
        html = "<html>" + html;
        html = html + "</html>";
        return html;
    }

    public static String wrapTextWithBr(FontMetrics fm, String tipText, int width) {
        if (null == tipText) {
            return null;
        }
        String tip = tipText;
        if (0 < tip.length() && tip.charAt(0) == '/') {
            tip = '\b' + tip;
        }
        String html = tip;
        String htmlWrap = TAG_BR;
        if (html.indexOf("<html>") < 0) {
            html = html.indexOf(WINDOWS_LINE_SEPARATOR) >= 0 ? html.replaceAll(WINDOWS_LINE_SEPARATOR, TAG_BR) : UCD.wrapText(tip, fm, width);
        }
        return html;
    }

    private static String wrapText(String tipText, FontMetrics fm, int width) {
        return UCD.wrapText(tipText, fm, width, -1);
    }

    private static String wrapText(String tipText, FontMetrics fm, int width, int line) {
        StringBuffer sb = new StringBuffer();
        List<String> words = Lexer.parse(tipText, width, fm);
        int count = 0;
        String sentence = null;
        int sentenceW = 0;
        String prefWord = null;
        String currentWord = null;
        int start = 0;
        for (int end = 0; end < words.size(); ++end) {
            sentence = UCD.getSentence(words, start, end);
            sentenceW = SwingUtilities.computeStringWidth(fm, sentence);
            if (sentenceW <= width && end < words.size() - 1) continue;
            if (sentenceW > width && end - start > 0) {
                prefWord = words.get(end - 1);
                currentWord = words.get(end);
                sentence = UCD.isPrefQuotation(prefWord) ? UCD.getSentence(words, start, end -= 2) : (UCD.isPunctuation(currentWord) ? UCD.getSentence(words, start, end) : UCD.getSentence(words, start, --end));
            }
            start = end + 1;
            sb.append(sentence);
            if (start < words.size()) {
                sb.append(TAG_BR);
            }
            if (++count == line) break;
        }
        if (sb.length() > 7 && count == line && sb.toString().endsWith(TAG_BR)) {
            sb.delete(sb.length() - 7, sb.length() - 4);
            sb.insert(sb.length() - 4, STR_3_POINT);
        }
        return sb.toString();
    }

    private static boolean isPunctuation(String word) {
        return ",".equals(word) || ".".equals(word) || "\uff0c".equals(word) || "\u3002".equals(word);
    }

    private static boolean isPrefQuotation(String word) {
        return "\u201c".equals(word);
    }

    private static String getSentence(List<String> words, int start, int end) {
        StringBuffer sb = new StringBuffer();
        if (start < 0 || end < 0 || start > end) {
            return sb.toString();
        }
        List<String> subList = words.subList(start, end + 1);
        for (String word : subList) {
            sb.append(word);
        }
        return sb.toString();
    }

    @Deprecated
    public static JComponent buildTableScrollPane(IsmTable table) {
        TableScrollPane pane = new TableScrollPane(table, true, false, false);
        table.setFocusable(false);
        return pane;
    }

    @Deprecated
    public static JComponent buildTableScrollPane(IsmTable table, boolean enableColumnSel, boolean showRowIndex, boolean showCheckBox) {
        TableScrollPane pane = new TableScrollPane(table, showRowIndex, showCheckBox);
        table.setFocusable(false);
        return pane;
    }

    public static GridBagConstraints getGridBagConstraint(int gridx, Insets inset) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridx = gridx;
        constraints.weightx = 0.1;
        if (null != inset) {
            constraints.insets = inset;
        }
        return constraints;
    }

    public static JPanel createKVPropertyPane(List<Pair<String, JComponent>> pairs, int rowMargin, Border border) {
        ArrayList<JLabel> keyLabels = new ArrayList<JLabel>(0);
        JPanel valuePane = new JPanel();
        valuePane.setOpaque(false);
        valuePane.setLayout(new GridLayout(0, 1, 12, rowMargin));
        JLabel keyL = null;
        JComponent component = null;
        for (Pair<String, JComponent> p : pairs) {
            keyL = new JLabel(p.getKey(), 10);
            component = p.getValue();
            if (0 != component.getPreferredSize().height) {
                keyL.setPreferredSize(new Dimension(keyL.getPreferredSize().width, component.getPreferredSize().height));
            }
            keyLabels.add(keyL);
            valuePane.add(component);
        }
        return UCD.createKVPane(rowMargin, border, keyLabels, valuePane);
    }

    public static JPanel createKVPropertyPaneForCopy(List<Pair<String, JComponent>> pairs, int rowMargin, Border border) {
        ArrayList<IsmTextPane> keyLabels = new ArrayList<IsmTextPane>(0);
        JPanel valuePane = new JPanel();
        valuePane.setOpaque(false);
        valuePane.setLayout(new GridLayout(0, 1, 12, rowMargin));
        JComponent component = null;
        IsmTextPane keyL = null;
        for (Pair<String, JComponent> p : pairs) {
            keyL = new IsmTextPane(p.getKey());
            component = p.getValue();
            if (0 != component.getPreferredSize().height) {
                keyL.setPreferredSize(new Dimension(keyL.getPreferredSize().width, component.getPreferredSize().height));
            }
            keyLabels.add(keyL);
            valuePane.add(component);
        }
        return UCD.createKVPane(rowMargin, border, keyLabels, valuePane);
    }

    private static JPanel createKVPane(int rowMargin, Border border, List<? extends JComponent> keyLabels, JPanel valuePane) {
        JComponent keyPane = UCD.buildVerticalBox(null, rowMargin, keyLabels.toArray(new Component[keyLabels.size()]));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(10, 12));
        contentPane.add((Component)keyPane, "West");
        contentPane.add((Component)valuePane, "Center");
        contentPane.setOpaque(false);
        if (null != border) {
            contentPane.setBorder(border);
        }
        return UCD.layComponentToTop(contentPane);
    }

    public static JPanel createKVPane(Pair<String, String> ... pairs) {
        return UCD.createKVPane(10, pairs);
    }

    public static JPanel createKVPane(List<Pair<String, JComponent>> pairs) {
        return UCD.createKVPane(pairs, 10);
    }

    public static JPanel createKVPane(int rowMargins, Pair<String, String> ... pairs) {
        ArrayList<Pair<Component, Component>> pairList = new ArrayList<Pair<Component, Component>>(0);
        Pair<JLabel, JLabel> kvPair = null;
        JLabel valLabel = null;
        JLabel keyLabel = null;
        for (Pair<String, String> pair : pairs) {
            keyLabel = new JLabel(pair.getKey(), 10);
            valLabel = new JLabel(pair.getValue(), 10);
            kvPair = new Pair<JLabel, JLabel>(keyLabel, valLabel);
            pairList.add(kvPair);
        }
        return UCD.createKVPane(rowMargins, pairList);
    }

    public static JPanel createKVPane(List<Pair<String, JComponent>> pairs, int rowMargin) {
        ArrayList<Pair<Component, Component>> compPairs = new ArrayList<Pair<Component, Component>>(0);
        JLabel lable = null;
        for (Pair<String, JComponent> pair : pairs) {
            lable = new JLabel(pair.getKey(), 10);
            compPairs.add(new Pair<JLabel, JComponent>(lable, pair.getValue()));
        }
        return UCD.createKVPane(rowMargin, compPairs);
    }

    public static JPanel createKVPane(int rowMargin, List<Pair<Component, Component>> pairs) {
        Insets lInset = new Insets(0, 0, rowMargin, 12);
        return UCD.createKVPane(rowMargin, 2, pairs, lInset);
    }

    public static JPanel createRightKVPane(int rowMargin, List<Pair<Component, Component>> pairs) {
        int kvMargin = 15;
        Component component = null;
        for (Pair<Component, Component> pair : pairs) {
            component = pair.getValue();
            if (!(component instanceof RequiredHBox)) continue;
            kvMargin = 0;
            break;
        }
        return UCD.createRightKVPane(rowMargin, kvMargin, pairs);
    }

    public static JPanel createRightKVPane(int rowMargin, int kvMargin, List<Pair<Component, Component>> pairs) {
        Insets lInset = new Insets(0, 0, rowMargin, kvMargin);
        Component component = null;
        for (Pair<Component, Component> pair : pairs) {
            component = pair.getKey();
            if (!(component instanceof JLabel)) continue;
            component.setFont(IsmFontFactory.getBold12Font());
        }
        return UCD.createKVPane(rowMargin, 4, pairs, lInset);
    }

    public static JPanel createRightKVPane(Pair<String, String> ... pairs) {
        ArrayList<Pair<Component, Component>> pairList = new ArrayList<Pair<Component, Component>>(0);
        JLabel keyLabel = null;
        Pair<JLabel, JLabel> kvPair = null;
        JLabel valLabel = null;
        for (Pair<String, String> pair : pairs) {
            keyLabel = new JLabel(pair.getKey(), 4);
            valLabel = new JLabel(pair.getValue(), 2);
            kvPair = new Pair<JLabel, JLabel>(keyLabel, valLabel);
            pairList.add(kvPair);
        }
        return UCD.createRightKVPane(5, pairList);
    }

    public static JPanel createRightKVPane(int rowMargin, List<Pair<Component, Component[]>> pairs, int[] insets) {
        Insets lInset = new Insets(0, 0, rowMargin, insets[0]);
        Component component = null;
        for (Pair<Component, Component[]> pair : pairs) {
            component = pair.getKey();
            if (!(component instanceof JLabel)) continue;
            component.setFont(IsmFontFactory.getBold12Font());
        }
        JPanel keyValuePane = new JPanel();
        keyValuePane.setLayout(new GridBagLayout());
        Insets rInset = new Insets(0, 0, rowMargin, 0);
        GridBagConstraints lConstraints = UCD.getGridBagConstraint(0, lInset);
        lConstraints.weightx = 0.0;
        int index = 0;
        Box keyComp = null;
        Component[] components = null;
        int i = 0;
        for (Pair<Component, Component[]> pair : pairs) {
            ++index;
            keyComp = UCD.buildHBoxRight(pair.getKey());
            for (Component comp : components = pair.getValue()) {
                comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, ((Component)keyComp).getPreferredSize().height));
            }
            if (index == pairs.size()) {
                lInset = new Insets(0, 0, 0, lInset.right);
                rInset = new Insets(0, 0, 0, 0);
                lConstraints = UCD.getGridBagConstraint(0, lInset);
                lConstraints.weightx = 0.0;
            }
            keyValuePane.add((Component)keyComp, lConstraints);
            i = 0;
            for (Component comp : components) {
                GridBagConstraints rConstraints = UCD.getGridBagConstraint(++i, rInset);
                keyValuePane.add(comp, rConstraints);
            }
        }
        keyValuePane.setOpaque(false);
        return UCD.layComponentToTop(keyValuePane);
    }

    private static JPanel createKVPane(int rowMargin, int keyAlign, List<Pair<Component, Component>> pairs, Insets lInset) {
        JPanel keyValuePane = new JPanel();
        keyValuePane.setLayout(new GridBagLayout());
        Insets rInset = new Insets(0, 0, rowMargin, 0);
        GridBagConstraints lConstraints = UCD.getGridBagConstraint(0, lInset);
        lConstraints.weightx = 0.0;
        GridBagConstraints rConstraints = UCD.getGridBagConstraint(1, rInset);
        int index = 0;
        Component component = null;
        Component keyComp = null;
        Insets actualLInset = lInset;
        for (Pair<Component, Component> pair : pairs) {
            ++index;
            keyComp = pair.getKey();
            if (keyAlign == 4) {
                keyComp = UCD.buildHBoxRight(pair.getKey());
            }
            component = pair.getValue();
            if (0 != component.getPreferredSize().height) {
                keyComp.setPreferredSize(new Dimension(keyComp.getPreferredSize().width, component.getPreferredSize().height));
            }
            if (index == pairs.size()) {
                actualLInset = new Insets(0, 0, 0, actualLInset.right);
                rInset = new Insets(0, 0, 0, 0);
                lConstraints = UCD.getGridBagConstraint(0, actualLInset);
                lConstraints.weightx = 0.0;
                rConstraints = UCD.getGridBagConstraint(1, rInset);
            }
            keyValuePane.add(keyComp, lConstraints);
            keyValuePane.add(component, rConstraints);
        }
        keyValuePane.setOpaque(false);
        return UCD.layComponentToTop(keyValuePane);
    }

    public static JPanel layComponentToTop(JComponent component) {
        JPanel contentPane = new JPanel();
        contentPane.setOpaque(false);
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        contentPane.add((Component)component, gridBagConstraints);
        return contentPane;
    }

    public static Insets getInset(int topMargin) {
        return new Insets(topMargin, 12, 10, 12);
    }

    public static void formatMnemonicDisplay(AbstractButton item) {
        if (null == item) {
            return;
        }
        int mnemonic = item.getMnemonic();
        char upperCaseMnemonic = String.valueOf((char)mnemonic).toUpperCase(ResourceManager.getLocale()).charAt(0);
        char lowerCaseMnemonic = String.valueOf((char)mnemonic).toLowerCase(ResourceManager.getLocale()).charAt(0);
        if (("zh".equals(ResourceManager.getLocale().getLanguage()) || item.getText().indexOf(upperCaseMnemonic) == -1 && item.getText().indexOf(lowerCaseMnemonic) == -1) && 0 != mnemonic) {
            String menuItemText = item.getText();
            String mnemonicText = "(" + KeyEvent.getKeyText(mnemonic) + ")";
            String mnemonicRegex = "\\([a-zA-Z0-9]\\)|\\([a-zA-Z0-9]\\)";
            menuItemText = menuItemText.replaceAll(mnemonicRegex, "");
            String tripleDotText = STR_3_POINT;
            String tripleDotRegex = "\\.";
            int tripleDotIndex = menuItemText.lastIndexOf(tripleDotText);
            if (-1 != tripleDotIndex) {
                menuItemText = menuItemText.replaceAll(tripleDotRegex, "");
                menuItemText = menuItemText + mnemonicText;
                menuItemText = menuItemText + tripleDotText;
            } else {
                menuItemText = menuItemText + mnemonicText;
            }
            item.setText(menuItemText);
            int mnemonicIndex = menuItemText.lastIndexOf(mnemonic);
            if (-1 != mnemonicIndex) {
                item.setDisplayedMnemonicIndex(mnemonicIndex);
            }
        }
    }

    public static Dimension computeButtonPreferredSize(AbstractButton button) {
        Dimension dimension = button.getPreferredSize();
        Integer[] widthChoices = buttonWidthChoices;
        int widthMultiple = 10;
        int height = BUTTON_HEIGHT;
        int preferredWidthIndex = UCD.findNearest(dimension.width, widthChoices);
        dimension.width = preferredWidthIndex >= 0 ? widthChoices[preferredWidthIndex] : (dimension.width + widthMultiple / 2) / widthMultiple * widthMultiple;
        dimension.height = height;
        return dimension;
    }

    public static Dimension computeButtonPreferredSize(AbstractButton button, boolean limited) {
        Dimension dimension = UCD.computeButtonPreferredSize(button);
        int maxW = buttonWidthChoices[buttonWidthChoices.length - 1];
        if (limited && dimension.width > buttonWidthChoices[buttonWidthChoices.length - 1]) {
            dimension.width = maxW;
        }
        return dimension;
    }

    private static Integer findNearest(Integer value, Integer[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (value > array[i]) continue;
            return i;
        }
        return -1;
    }

    public static Box buildButtonBoxRight(JButton[] ... sameGroups) {
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(UCD.buildButtonBox(sameGroups));
        return buttonBox;
    }

    public static Box buildHBoxLeft(Component ... components) {
        Assert.notNullArray(components);
        return UCD.buildHBoxLeft(12, components);
    }

    public static Box buildHBoxLeft(int colMargins, Component ... components) {
        Assert.notNullArray(components);
        Box box = Box.createHorizontalBox();
        box.add(UCD.buildHorizotalBox(null, colMargins, components));
        box.add(Box.createGlue());
        return box;
    }

    public static Box buildHBoxRight(Component ... components) {
        Assert.notNullArray(components);
        return UCD.buildHBoxRight(12, components);
    }

    public static Box buildHBoxRight(int colMargins, Component ... components) {
        Assert.notNullArray(components);
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        box.add(UCD.buildHorizotalBox(null, colMargins, components));
        return box;
    }

    public static Box buildHBoxCentert(Component ... components) {
        Assert.notNullArray(components);
        return UCD.buildHBoxCentert(12, components);
    }

    public static Box buildHBoxCentert(int colMargins, Component ... components) {
        Assert.notNullArray(components);
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        box.add(UCD.buildHorizotalBox(null, colMargins, components));
        box.add(Box.createGlue());
        return box;
    }

    public static CompoundBorder getCompoundTitleBorder(String titleName) {
        TitledBorder titledBorder = new TitledBorder(titleName);
        Border outBorder = UCD.createEmptyBorder();
        return UCD.getCompoundBorder(titledBorder, outBorder);
    }

    public static CompoundBorder getCompoundTitleBorder(TitledBorder titledBorder) {
        EmptyBorder outBorder = UCD.getEmptyBorder();
        return UCD.getCompoundBorder(titledBorder, outBorder);
    }

    public static EmptyBorder getEmptyBorder() {
        return UCD.getEmptyBorder(8);
    }

    public static EmptyBorder getEmptyBorder(int topMargin) {
        Insets insets = new Insets(topMargin, 8, 8, 8);
        EmptyBorder emptyBorder = new EmptyBorder(insets);
        return emptyBorder;
    }

    public static Border getEtchedLineBorder() {
        return BorderFactory.createEtchedBorder(1, Color.WHITE, Color.GRAY);
    }

    public static CompoundBorder getCompoundBorder(Border outer, Border inner) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outer, inner);
        return compoundBorder;
    }

    public static JSeparator getMatteBorder() {
        JSeparator separator = new JSeparator(0);
        separator.setName("ISMV1R2_platform_SwingUtil_separator");
        separator.setBorder(new EtchedBorder(1));
        return separator;
    }

    public static Box buildHorizontalBoxLeft(Component com) {
        Box box = Box.createHorizontalBox();
        box.add(com);
        box.add(Box.createGlue());
        return box;
    }

    public static Box buildHorizontalBoxRight(Component com) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        box.add(com);
        return box;
    }

    public static void setJLabelSizeAndAlign(JLabel label, Dimension size, int alignment) {
        label.setHorizontalAlignment(alignment);
        UCD.setJComponentSize(label, size);
    }

    public static void setSameWidth(int width, JComponent ... components) {
        for (JComponent component : components) {
            UCD.setJComponentSize(component, width, component.getPreferredSize().height);
        }
    }

    public static void setSameWidth(JComponent ... components) {
        int maxWidth = 0;
        int width = 0;
        for (JComponent component : components) {
            width = component.getPreferredSize().width;
            maxWidth = width > maxWidth ? width : maxWidth;
        }
        UCD.setSameWidth(maxWidth, components);
    }

    public static void setSameWidthAndAlign(int alignment, JLabel ... labels) {
        UCD.setSameWidth(labels);
        for (JLabel label : labels) {
            label.setHorizontalAlignment(alignment);
        }
    }

    public static JPanel createBoxLayoutPane(int layoutOrientation) {
        if (layoutOrientation != 0 && layoutOrientation != 1) {
            throw new IllegalArgumentException("The layout orientation is illegal");
        }
        JPanel pane = new JPanel();
        pane.setOpaque(false);
        pane.setLayout(new BoxLayout(pane, layoutOrientation));
        return pane;
    }

    public static JPanel createTransparentPane(LayoutManager layout) {
        JPanel pane = new JPanel();
        pane.setOpaque(false);
        pane.setLayout(layout);
        return pane;
    }

    public static JTextPane createTextViewPane(String str, ComponentOrientation orient) {
        JTextPane elecLabel = new JTextPane();
        elecLabel.setText(BLANK_CONTENT);
        elecLabel.setEditable(false);
        elecLabel.setOpaque(false);
        elecLabel.setBorder(null);
        if (!Utils.isNullStr(str)) {
            elecLabel.setText(str);
        }
        elecLabel.setComponentOrientation(orient);
        return elecLabel;
    }

    public static CompoundBorder getCompoundTitleTableBorder(TitledBorder titledBorder) {
        LineBorder lineBorder = new LineBorder(Color.GRAY);
        EmptyBorder outBorder = UCD.getEmptyBorder();
        return UCD.getCompoundBorder(titledBorder, UCD.getCompoundBorder(outBorder, lineBorder));
    }

    public static String getRoleTableDisplay(Boolean bean) {
        String str = BLANK_CONTENT;
        if (null != bean) {
            str = bean != false ? ResourceManager.getString("PROPERTYPANE_HYPERMIRRORS_ISPRIMARY") : ResourceManager.getString("PROPERTYPANE_HYPERMIRRORS_ISSECOND");
        }
        return str;
    }

    public static Dimension getPreferedSize(JComponent ... components) {
        int preferedWitdh = 0;
        int preferedHeight = 0;
        int comPreWidth = 0;
        int comPreHeight = 0;
        for (JComponent component : components) {
            comPreWidth = component.getPreferredSize().width;
            comPreHeight = component.getPreferredSize().height;
            if (comPreWidth > preferedWitdh) {
                preferedWitdh = comPreWidth;
            }
            if (comPreHeight <= preferedHeight) continue;
            preferedHeight = comPreHeight;
        }
        return new Dimension(preferedWitdh, preferedHeight);
    }

    public static EtchedBorder getEtchedBorder() {
        EtchedBorder etchedBorder = new EtchedBorder(1);
        return etchedBorder;
    }

    public static CompoundBorder getCompoundEtchedBorder() {
        EtchedBorder outBorder = new EtchedBorder(1);
        EmptyBorder inBorder = UCD.getEmptyBorder();
        CompoundBorder border = UCD.getCompoundBorder(outBorder, inBorder);
        return border;
    }

    public static void setPreferredWidth(Component component, int width) {
        Dimension initDimension = component.getPreferredSize();
        initDimension.width = width;
        component.setPreferredSize(initDimension);
    }
}

