/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static String getTextContentOfChild(Element parent, String childTagName) {
        String result = null;
        Node node = parent.getFirstChild();
        Element element = null;
        String tagName = null;
        String content = null;
        while (null != node) {
            if (!(node instanceof Element)) {
                node = node.getNextSibling();
                continue;
            }
            element = (Element)node;
            tagName = element.getTagName();
            content = element.getTextContent();
            if (childTagName.equals(tagName)) {
                result = content.trim();
                break;
            }
            node = node.getNextSibling();
        }
        return result;
    }

    public static Collection<Element> getChildren(Element parent, String childTagName) {
        ArrayList<Element> children = new ArrayList<Element>(0);
        if (null == parent) {
            return children;
        }
        Element element = null;
        String tagName = null;
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            element = (Element)child;
            tagName = element.getTagName();
            if (null != childTagName) {
                if (!childTagName.equals(tagName)) continue;
                children.add(element);
                continue;
            }
            children.add(element);
        }
        return children;
    }

    public static Element getChild(Element parent, String childTagName) {
        Element result = null;
        Element element = null;
        String tagName = null;
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !(tagName = (element = (Element)child).getTagName()).equals(childTagName)) continue;
            result = element;
            break;
        }
        return result;
    }

    public static Collection<Element> getChildren(Element parent) {
        return XmlUtils.getChildren(parent, null);
    }

    public static String getAttribute(Element element, String attribute) {
        String result = element.getAttribute(attribute);
        if (null != result) {
            return result.trim();
        }
        return null;
    }
}

