/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.ArrayIterator;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;

public final class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private ArrayUtils() {
    }

    public static <E extends Comparable<E>> int binarySearch(E[] array, E key) {
        return ArrayUtils.binarySearch(array, key, Function.identity(), ObjectUtils::compare);
    }

    public static <E, K extends Comparable<K>> int binarySearch(E[] array, K key, Function<E, K> mapper) {
        return ArrayUtils.binarySearch(array, key, mapper, ObjectUtils::compare);
    }

    public static <E, K extends Comparable<K>> int binarySearch(E[] array, K key, Function<E, K> mapper, Comparator<K> comparator) {
        Validation.notNull(array, "The array to binary search cannot be null.", new Object[0]);
        Validation.notNull(mapper, "The mapper to map element cannot be null.", new Object[0]);
        Validation.notNull(comparator, "The comparator to compare elements cannot be null.", new Object[0]);
        if (array.length < 1) {
            return -1;
        }
        int compareResult = comparator.compare(mapper.apply(array[0]), key);
        if (compareResult > 0) {
            return -1;
        }
        if (compareResult == 0) {
            return 0;
        }
        compareResult = comparator.compare(mapper.apply(array[array.length - 1]), key);
        if (compareResult < 0) {
            return -1 - array.length;
        }
        if (compareResult == 0) {
            return array.length - 1;
        }
        return ArrayUtils.binarySearch0(array, key, mapper, comparator);
    }

    private static <E, K> int binarySearch0(E[] array, K key, Function<E, K> mapper, Comparator<K> comparator) {
        int left = 0;
        int right = array.length - 1;
        while (left <= right) {
            int mid = left + right >>> 1;
            int compareResult = comparator.compare(mapper.apply(array[mid]), key);
            if (compareResult < 0) {
                left = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                right = mid - 1;
                continue;
            }
            return mid;
        }
        return -(left + 1);
    }

    public static Object[] concrete(Object array) {
        Validation.notNull(array, "Array cannot be null.", new Object[0]);
        Object[] actualArray = new Object[Array.getLength(array)];
        for (int i = 0; i < actualArray.length; ++i) {
            actualArray[i] = Array.get(array, i);
        }
        return actualArray;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length < 1;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... items) {
        return new ArrayIterator<T>(items);
    }

    public static <T> String toString(T[] array) {
        return ArrayUtils.toString(array, null);
    }

    public static <T> String toString(T[] array, Function<T, String> toStringMapper) {
        if (array == null) {
            return "";
        }
        Function<Object, String> actualToString = ObjectUtils.nullIf(toStringMapper, ObjectUtils::toString);
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (array.length > 0) {
            builder.append(actualToString.apply(array[0]));
            for (int i = 1; i < array.length; ++i) {
                builder.append(", ").append(actualToString.apply(array[i]));
            }
        }
        builder.append(']');
        return builder.toString();
    }
}

