/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static <T extends Enum<T>> T firstOrDefault(Class<T> clz, Predicate<T> predicate) {
        Validation.notNull(clz, "The enum class to find value cannot be null.", new Object[0]);
        Predicate<Enum> actualPredicate = ObjectUtils.nullIf(predicate, item -> true);
        return (T)((Enum)EnumSet.allOf(clz).stream().filter(actualPredicate).findAny().orElse(null));
    }

    public static <T extends Enum<T>> List<T> find(Class<T> clz, Predicate<T> predicate) {
        Validation.notNull(clz, "The enum class to find values cannot be null.", new Object[0]);
        Predicate<Enum> actualPredicate = ObjectUtils.nullIf(predicate, item -> true);
        return EnumSet.allOf(clz).stream().filter(actualPredicate).collect(Collectors.toList());
    }
}

