/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import java.util.HashSet;

public class ExceptionUtils {
    private static final int MAX_DEPTH = 10;

    private ExceptionUtils() {
    }

    public static Throwable getActualCause(MethodInvocationException exception) {
        HashSet<Throwable> exist = new HashSet<Throwable>();
        Throwable origin = exception;
        exist.add(origin);
        int depth = 0;
        while (origin instanceof MethodInvocationException) {
            if (++depth >= 10) {
                throw new IllegalStateException("Too many duplicated throwable.", exception);
            }
            Throwable cause = origin.getCause();
            if (exist.contains(cause)) {
                throw new IllegalStateException("Cyclic throwable cause.", exception);
            }
            exist.add(cause);
            origin = cause;
        }
        return origin;
    }

    public static String getReason(Throwable throwable) {
        if (throwable == null) {
            return "No exception";
        }
        return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
    }
}

