/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IoUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    private IoUtils() {
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copy(File inputFile, File outputFile) throws IOException {
        IoUtils.copy(inputFile, outputFile, 1024);
    }

    public static void copy(File inputFile, File outputFile, int bufferSize) throws IOException {
        IoUtils.validateInputFile(inputFile);
        try (FileInputStream in = new FileInputStream(inputFile);){
            IoUtils.copy((InputStream)in, outputFile, bufferSize, inputFile.length());
        }
    }

    public static void copy(File inputFile, OutputStream out) throws IOException {
        IoUtils.copy(inputFile, out, 1024);
    }

    public static void copy(File inputFile, OutputStream out, int bufferSize) throws IOException {
        IoUtils.validateInputFile(inputFile);
        try (FileInputStream in = new FileInputStream(inputFile);){
            IoUtils.copy((InputStream)in, out, bufferSize, inputFile.length());
        }
    }

    public static void copy(InputStream in, File outputFile) throws IOException {
        IoUtils.copy(in, outputFile, 1024);
    }

    public static void copy(InputStream in, File outputFile, int bufferSize) throws IOException {
        IoUtils.validateOutputFile(outputFile);
        try (FileOutputStream out = new FileOutputStream(outputFile, false);){
            IoUtils.copy(in, (OutputStream)out, bufferSize);
        }
    }

    public static void copy(InputStream in, File outputFile, int bufferSize, long length) throws IOException {
        IoUtils.validateOutputFile(outputFile);
        try (FileOutputStream out = new FileOutputStream(outputFile, false);){
            IoUtils.copy(in, out, bufferSize, length);
        }
    }

    public static void copy(InputStream in, File outputFile, long length) throws IOException {
        IoUtils.copy(in, outputFile, 1024, length);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IoUtils.copy(in, out, 1024);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int read;
        IoUtils.validateInputStream(in);
        IoUtils.validateOutputStream(out);
        IoUtils.validateBufferSize(bufferSize);
        byte[] buffer = new byte[bufferSize];
        while ((read = in.read(buffer, 0, bufferSize)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize, long length) throws IOException {
        int part;
        IoUtils.validateInputStream(in);
        IoUtils.validateOutputStream(out);
        IoUtils.validateBufferSize(bufferSize);
        IoUtils.validateLength(length);
        byte[] buffer = new byte[bufferSize];
        for (long read = 0L; read < length; read += (long)part) {
            part = in.read(buffer, 0, (int)Math.min(length - read, (long)bufferSize));
            out.write(buffer, 0, part);
        }
    }

    public static void copy(InputStream in, OutputStream out, long length) throws IOException {
        IoUtils.copy(in, out, 1024, length);
    }

    public static Properties properties(Class<?> clazz, String resourceKey) {
        Properties properties = new Properties();
        try (InputStream in = IoUtils.resource(clazz, resourceKey);){
            properties.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format("Fail to read properties from embedded resource. [resourceKey={0}]", resourceKey), e);
        }
        return properties;
    }

    public static Properties properties(ClassLoader loader, String resourceKey) {
        Properties properties = new Properties();
        try (InputStream in = IoUtils.resource(loader, resourceKey);){
            properties.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format("Fail to read properties from embedded resource. [resourceKey={0}]", resourceKey), e);
        }
        return properties;
    }

    public static String read(Class<?> clazz, String resourceName) throws IOException {
        Validation.notNull(clazz, "The coordinate class to read resource cannot be null.", new Object[0]);
        return IoUtils.readResource(clazz::getResourceAsStream, resourceName);
    }

    public static String read(ClassLoader classLoader, String resourceName) throws IOException {
        Validation.notNull(classLoader, "The coordinate class loader to read resource cannot be null.", new Object[0]);
        return IoUtils.readResource(classLoader::getResourceAsStream, resourceName);
    }

    public static String read(InputStream in) throws IOException {
        return IoUtils.read(in, null);
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        Validation.notNull(in, "The input stream to read cannot be null.", new Object[0]);
        Charset actualCharset = ObjectUtils.nullIf(charset, StandardCharsets.UTF_8);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, actualCharset));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static byte[] read(InputStream in, int length) throws IOException {
        int current;
        Validation.notNull(in, "The input stream to read cannot be null.", new Object[0]);
        Validation.greaterThanOrEquals(length, 0, "The length of data to read cannot be negative.", new Object[0]);
        if (length < 1) {
            return new byte[0];
        }
        byte[] buffer = new byte[length];
        int read = 0;
        do {
            if ((current = in.read(buffer, read, length - read)) >= 0) continue;
            throw new IOException(StringUtils.format("Fail to read from input stream: no enough available bytes. [expectedLength={0}, actualLength={1}]", length, read));
        } while ((read += current) < length);
        return buffer;
    }

    public static InputStream resource(Class<?> clazz, String key) {
        Validation.notNull(clazz, "The class to load resource cannot be null.", new Object[0]);
        Validation.notBlank(key, "The key of resource to load cannot be blank.", new Object[0]);
        InputStream stream = clazz.getResourceAsStream(key);
        if (stream == null) {
            throw new IllegalStateException(StringUtils.format("The embedded resource with specific key not found. [key={0}]", key));
        }
        return stream;
    }

    public static InputStream resource(ClassLoader loader, String key) {
        Validation.notNull(loader, "The loader to load resource cannot be null.", new Object[0]);
        Validation.notBlank(key, "The key of resource to load cannot be blank.", new Object[0]);
        InputStream stream = loader.getResourceAsStream(key);
        if (stream == null) {
            throw new IllegalStateException(StringUtils.format("The embedded resource with specific key not found. [key={0}]", key));
        }
        return stream;
    }

    private static String readResource(Function<String, InputStream> inSupplier, String resourceName) throws IOException {
        Validation.notBlank(resourceName, "The name of resource to read cannot be null.", new Object[0]);
        try (InputStream in = inSupplier.apply(resourceName);){
            Validation.notNull(in, () -> new IllegalStateException("The input stream to read cannot be null."));
            String string = IoUtils.read(in);
            return string;
        }
    }

    private static void validateBufferSize(int bufferSize) {
        Validation.greaterThan(bufferSize, 0, "The size of buffer to copy data must be positive.", new Object[0]);
    }

    private static void validateInputFile(File inputFile) {
        Validation.notNull(inputFile, "The input file to copy data cannot be null.", new Object[0]);
        Validation.isTrue(inputFile.exists(), "The input file to copy data not exists.", new Object[0]);
    }

    private static void validateInputStream(InputStream in) {
        Validation.notNull(in, "The input stream to copy data cannot be null.", new Object[0]);
    }

    private static void validateLength(long length) {
        Validation.greaterThanOrEquals(length, 0L, "The length of data to copy cannot be negative.", new Object[0]);
    }

    private static void validateOutputFile(File outputFile) {
        Validation.notNull(outputFile, "The output file to copy data cannot be null.", new Object[0]);
    }

    private static void validateOutputStream(OutputStream out) {
        Validation.notNull(out, "The output stream to copy data cannot be null.", new Object[0]);
    }
}

